/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.osgi.framework.Bundle;

public class JSFTestUtil {
    public static void setValidationEnabled(boolean isEnabled) throws InvocationTargetException {
        GlobalConfiguration config = new GlobalConfiguration(ConfigurationManager.getManager().getGlobalConfiguration());
        config.setDisableAllValidation(!isEnabled);
        config.passivate();
        config.store();
    }

    public static void setInternetProxyPreferences(boolean proxied, String proxyHostName, String proxyPort) {
    }

    public static void loadSourceClass(Bundle bundle, String fileName, String beanClassName, String srcFolderName, String packageName, JDTTestEnvironment jdtTestEnvironment) throws Exception {
        TestFileResource codeRes = new TestFileResource();
        codeRes.load(bundle, fileName);
        String code = codeRes.toString();
        jdtTestEnvironment.addSourceFile(srcFolderName, packageName, beanClassName, code);
    }

    public static URI getPlatformAbsPath(String relativePath) throws MalformedURLException, URISyntaxException {
        URL url = new URL(Platform.getInstanceLocation().getURL(), relativePath);
        return url.toURI();
    }

    public static IPath getAbsolutePath(Bundle bundle, String relativePath) throws IOException, URISyntaxException {
        URL url = FileLocator.resolve((URL)bundle.getEntry(relativePath));
        return new Path(new File(url.toURI()).getAbsolutePath());
    }

    public static void savePlatformRelative(TestFileResource testFile, String relativePath) throws IOException, URISyntaxException {
        JSFTestUtil.saveToFileSystem(testFile, JSFTestUtil.getPlatformAbsPath(relativePath));
    }

    public static void saveToFileSystem(TestFileResource testFile, URI absPath) throws IOException {
        JSFTestUtil.saveToFileSystem(testFile.toBytes(), absPath);
    }

    public static void saveToFileSystem(byte[] buffer, URI absPath) throws IOException {
        File file = new File(absPath);
        FileOutputStream outFile = null;
        try {
            outFile = new FileOutputStream(file);
            outFile.write(buffer);
        }
        finally {
            if (outFile != null) {
                outFile.close();
            }
        }
    }

    public static boolean areEqual(TestFileResource testFile, URI absPath) throws IOException {
        File file = new File(absPath);
        return Arrays.equals(JSFTestUtil.loadFromFile(file).toByteArray(), testFile.toBytes());
    }

    public static ByteArrayOutputStream loadFromFile(File file) throws IOException {
        FileInputStream inFile = null;
        ByteArrayOutputStream buffer = null;
        try {
            int bytesRead;
            inFile = new FileInputStream(file);
            buffer = new ByteArrayOutputStream();
            byte[] inBuffer = new byte[1024];
            int curPos = 0;
            while ((bytesRead = inFile.read(inBuffer)) != -1) {
                buffer.write(inBuffer, 0, bytesRead);
                curPos += bytesRead;
            }
            ByteArrayOutputStream byteArrayOutputStream = buffer;
            return byteArrayOutputStream;
        }
        finally {
            if (inFile != null) {
                inFile.close();
            }
        }
    }
}

