/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.tests.format;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.format.FormatProcessorCSS;
import org.eclipse.wst.css.core.tests.util.StringCompareUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class TestFormatProcessorCSS
extends TestCase {
    private static final String UTF_8 = "UTF-8";
    private StringCompareUtil fStringCompareUtil;
    private FormatProcessorCSS formatProcessor;
    private boolean fOldClearBlankLinesPref;
    private int fOldMaxLineWidthPref;
    private String fOldIndentationCharPref;
    private int fOldIndentationSizePref;

    public TestFormatProcessorCSS(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        Preferences prefs = CSSCorePlugin.getDefault().getPluginPreferences();
        this.fOldClearBlankLinesPref = prefs.getBoolean("clearAllBlankLines");
        this.fOldMaxLineWidthPref = prefs.getInt("lineWidth");
        this.fOldIndentationCharPref = prefs.getString("indentationChar");
        this.fOldIndentationSizePref = prefs.getInt("indentationSize");
        prefs.setValue("clearAllBlankLines", false);
        prefs.setValue("lineWidth", 72);
        prefs.setValue("indentationChar", "tab");
        prefs.setValue("indentationSize", 1);
        this.formatProcessor = new FormatProcessorCSS();
        this.fStringCompareUtil = new StringCompareUtil();
    }

    protected void tearDown() throws Exception {
        Preferences prefs = CSSCorePlugin.getDefault().getPluginPreferences();
        prefs.setValue("clearAllBlankLines", this.fOldClearBlankLinesPref);
        prefs.setValue("lineWidth", this.fOldMaxLineWidthPref);
        prefs.setValue("indentationChar", this.fOldIndentationCharPref);
        prefs.setValue("indentationSize", this.fOldIndentationSizePref);
    }

    private IStructuredModel getModelForEdit(String filename) {
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
            if (inStream == null) {
                throw new FileNotFoundException("Can't file resource stream " + filename);
            }
            String baseFile = ((Object)((Object)this)).getClass().getResource(filename).toString();
            model = modelManager.getModelForEdit(baseFile, inStream, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return model;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void formatAndAssertEquals(String beforePath, String afterPath) throws UnsupportedEncodingException, IOException, CoreException {
        IStructuredModel afterModel;
        block4: {
            IStructuredModel beforeModel = null;
            afterModel = null;
            try {
                beforeModel = this.getModelForEdit(beforePath);
                TestFormatProcessorCSS.assertNotNull((String)("could not retrieve structured model for : " + beforePath), (Object)beforeModel);
                afterModel = this.getModelForEdit(afterPath);
                TestFormatProcessorCSS.assertNotNull((String)("could not retrieve structured model for : " + afterPath), (Object)afterModel);
                this.formatProcessor.formatModel(beforeModel);
                ByteArrayOutputStream formattedBytes = new ByteArrayOutputStream();
                beforeModel.save((OutputStream)formattedBytes);
                ByteArrayOutputStream afterBytes = new ByteArrayOutputStream();
                afterModel.save((OutputStream)afterBytes);
                String formattedContents = new String(afterBytes.toByteArray(), UTF_8);
                String expectedContents = new String(formattedBytes.toByteArray(), UTF_8);
                TestFormatProcessorCSS.assertTrue((String)"Formatted document differs from the expected", (boolean)this.fStringCompareUtil.equalsIgnoreLineSeperator(formattedContents, expectedContents));
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (beforeModel != null) {
                    beforeModel.releaseFromEdit();
                }
                if (afterModel == null) throw throwable;
                afterModel.releaseFromEdit();
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (beforeModel == null) break block4;
            }
            beforeModel.releaseFromEdit();
        }
        if (afterModel == null) return;
        afterModel.releaseFromEdit();
    }

    public void testBUG73990SelectorFormat() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/BUG73990_selector_unformatted.css", "testfiles/BUG73990_selector_formatted.css");
    }

    public void testBUG111569extraSemicolonFormat() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/bug111569-extrasemicolon.css", "testfiles/bug111569-extrasemicolon-formatted.css");
    }

    public void testBUG146198attributeSpecifierFormat() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/bug146198-attributespecifier.css", "testfiles/bug146198-attributespecifier-formatted.css");
    }

    public void testBUG110539multipleClassFormat() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/bug110539-multipleclass.css", "testfiles/bug110539-multipleclass-formatted.css");
    }
}

