/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.contentassist;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslator;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class JSPJavaTranslatorTest
extends TestCase {
    public JSPJavaTranslatorTest(String name) {
        super(name);
    }

    public void testAllFiles() throws UnsupportedEncodingException, IOException {
        this.testJSPInJavascript("testfiles/jspInJavascript.jsp");
    }

    public void testJSPInJavascript(String filename) throws UnsupportedEncodingException, IOException {
        IStructuredModel sm = this.getStructuredModelForRead(filename);
        if (sm != null) {
            IDOMNode xmlNode = (IDOMNode)sm.getIndexedRegion(0);
            if (xmlNode != null) {
                JSPTranslator jspt = new JSPTranslator();
                jspt.reset(xmlNode, null);
                jspt.translate();
                String translation = jspt.getTranslation().toString();
                int cursorStart = translation.indexOf("out.print(\"\"+\n testJspString") + 14;
                JSPJavaTranslatorTest.assertEquals((String)("incorrect cursor position >" + cursorStart), (int)667, (int)cursorStart);
            }
            sm.releaseFromRead();
        }
    }

    protected IStructuredModel getStructuredModelForRead(String filename) throws UnsupportedEncodingException, IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        IStructuredModel sModel = modelManager.getModelForRead(filename, inStream, null);
        return sModel;
    }
}

