/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.tests.j2ee;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.server.core.tests.TestsPlugin;
import org.eclipse.jst.server.core.tests.j2ee.ModuleHelper;
import org.eclipse.jst.server.core.tests.j2ee.ProjectUnzipUtil;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.util.ProjectModule;
import org.osgi.framework.Bundle;

public class ModuleHelper {
    static /* synthetic */ Class class$0;

    protected static IPath getLocalPath(IPath path) {
        try {
            URL url = FileLocator.find((Bundle)TestsPlugin.instance.getBundle(), (IPath)path, null);
            url = FileLocator.toFileURL((URL)url);
            return new Path(url.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean importProject(String zipName, String[] projectNames) {
        IPath zipPath = ModuleHelper.getLocalPath(new Path("data").append(zipName));
        ProjectUnzipUtil util = new ProjectUnzipUtil(zipPath, projectNames);
        return util.createProjects();
    }

    public static void deleteProject(String projectName) throws Exception {
        class DeleteJob
        extends Job {
            private final /* synthetic */ String val$projectName;

            public DeleteJob(String string) {
                super("Deleting project");
                this.val$projectName = string;
                IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
                this.setRule(ruleFactory.createRule((IResource)ResourcesPlugin.getWorkspace().getRoot()));
            }

            protected IStatus run(IProgressMonitor monitor) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.val$projectName);
                try {
                    project.delete(true, null);
                }
                catch (CoreException ce) {
                    return ce.getStatus();
                }
                return Status.OK_STATUS;
            }
        }
        DeleteJob job = new DeleteJob(projectName);
        job.schedule();
        job.join();
    }

    public static void buildIncremental() throws CoreException {
        ResourcesPlugin.getWorkspace().build(10, null);
        boolean interrupted = true;
        while (interrupted) {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
                interrupted = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void buildFull() throws CoreException {
        ResourcesPlugin.getWorkspace().build(6, null);
        boolean interrupted = true;
        while (interrupted) {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
                interrupted = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void buildClean() throws CoreException {
        ResourcesPlugin.getWorkspace().build(15, null);
        boolean interrupted = true;
        while (interrupted) {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
                interrupted = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static IModule getModuleFromProject(String name) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        IModule module = ServerUtil.getModule((IProject)project);
        if (module == null) {
            throw new Exception("No module in project");
        }
        return module;
    }

    public static IModule getModule(String type, String name) throws Exception {
        IModule[] module = ServerUtil.getModules((String)type);
        int size = module.length;
        int i = 0;
        while (i < size) {
            if (module[i].getName().equals(name)) {
                return module[i];
            }
            ++i;
        }
        return null;
    }

    public static int countFiles(IModule module) throws CoreException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.util.ProjectModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ProjectModule pm = (ProjectModule)module.loadAdapter((Class)clazz, null);
        IModuleResource[] mr = pm.members();
        int count = 0;
        int size = mr.length;
        int i = 0;
        while (i < size) {
            count = mr[i] instanceof IModuleFolder ? (count += ModuleHelper.countFiles((IModuleFolder)mr[i])) : ++count;
            ++i;
        }
        return count;
    }

    protected static int countFiles(IModuleFolder mf) {
        int count = 0;
        IModuleResource[] mr = mf.members();
        if (mr == null) {
            return 0;
        }
        int size = mr.length;
        int i = 0;
        while (i < size) {
            count = mr[i] instanceof IModuleFolder ? (count += ModuleHelper.countFiles((IModuleFolder)mr[i])) : ++count;
            ++i;
        }
        return count;
    }

    public static int countFolders(IModule module) throws CoreException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.util.ProjectModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ProjectModule pm = (ProjectModule)module.loadAdapter((Class)clazz, null);
        IModuleResource[] mr = pm.members();
        int count = 0;
        int size = mr.length;
        int i = 0;
        while (i < size) {
            if (mr[i] instanceof IModuleFolder) {
                ++count;
                count += ModuleHelper.countFolders((IModuleFolder)mr[i]);
            }
            ++i;
        }
        return count;
    }

    protected static int countFolders(IModuleFolder mf) {
        int count = 0;
        IModuleResource[] mr = mf.members();
        if (mr == null) {
            return 0;
        }
        int size = mr.length;
        int i = 0;
        while (i < size) {
            if (mr[i] instanceof IModuleFolder) {
                ++count;
                count += ModuleHelper.countFolders((IModuleFolder)mr[i]);
            }
            ++i;
        }
        return count;
    }

    public static int countFilesInDelta(IModuleResourceDelta delta) throws CoreException {
        int count = 0;
        if (delta.getModuleResource() instanceof IModuleFile) {
            ++count;
        }
        IModuleResourceDelta[] children = delta.getAffectedChildren();
        int size = children.length;
        int i = 0;
        while (i < size) {
            count += ModuleHelper.countFilesInDelta(children[i]);
            ++i;
        }
        return count;
    }

    public static IModuleFile getModuleFile(IModule module, IPath path) throws CoreException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.util.ProjectModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ProjectModule pm = (ProjectModule)module.loadAdapter((Class)clazz, null);
        IModuleResource[] mr = pm.members();
        int size = mr.length;
        int i = 0;
        while (i < size) {
            IModuleFile mf2;
            if (mr[i].getModuleRelativePath().append(mr[i].getName()).equals((Object)path)) {
                if (mr[i] instanceof IModuleFile) {
                    return (IModuleFile)mr[i];
                }
                return null;
            }
            if (mr[i].getModuleRelativePath().isPrefixOf(path) && mr[i] instanceof IModuleFolder && (mf2 = ModuleHelper.getModuleFile((IModuleFolder)mr[i], path)) != null) {
                return mf2;
            }
            ++i;
        }
        return null;
    }

    protected static IModuleFile getModuleFile(IModuleFolder mf, IPath path) {
        IModuleResource[] mr = mf.members();
        if (mr == null) {
            return null;
        }
        int size = mr.length;
        int i = 0;
        while (i < size) {
            IModuleFile mf2;
            if (mr[i].getModuleRelativePath().append(mr[i].getName()).equals((Object)path)) {
                if (mr[i] instanceof IModuleFile) {
                    return (IModuleFile)mr[i];
                }
                return null;
            }
            if (mr[i].getModuleRelativePath().isPrefixOf(path) && mr[i] instanceof IModuleFolder && (mf2 = ModuleHelper.getModuleFile((IModuleFolder)mr[i], path)) != null) {
                return mf2;
            }
            ++i;
        }
        return null;
    }

    public static boolean fileExists(IModule module, IPath path) throws CoreException {
        return ModuleHelper.getModuleFile(module, path) != null;
    }

    public static boolean fileExists(IModule module, String path) throws CoreException {
        return ModuleHelper.fileExists(module, (IPath)new Path(path));
    }

    public static IModuleFolder getModuleFolder(IModule module, IPath path) throws CoreException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.util.ProjectModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ProjectModule pm = (ProjectModule)module.loadAdapter((Class)clazz, null);
        IModuleResource[] mr = pm.members();
        int size = mr.length;
        int i = 0;
        while (i < size) {
            IModuleFolder mf2;
            if (mr[i].getModuleRelativePath().append(mr[i].getName()).equals((Object)path)) {
                if (mr[i] instanceof IModuleFolder) {
                    return (IModuleFolder)mr[i];
                }
                return null;
            }
            if (mr[i].getModuleRelativePath().isPrefixOf(path) && mr[i] instanceof IModuleFolder && (mf2 = ModuleHelper.getModuleFolder((IModuleFolder)mr[i], path)) != null) {
                return mf2;
            }
            ++i;
        }
        return null;
    }

    protected static IModuleFolder getModuleFolder(IModuleFolder mf, IPath path) {
        IModuleResource[] mr = mf.members();
        if (mr == null) {
            return null;
        }
        int size = mr.length;
        int i = 0;
        while (i < size) {
            IModuleFolder mf2;
            if (mr[i].getModuleRelativePath().append(mr[i].getName()).equals((Object)path)) {
                if (mr[i] instanceof IModuleFolder) {
                    return (IModuleFolder)mr[i];
                }
                return null;
            }
            if (mr[i].getModuleRelativePath().isPrefixOf(path) && mr[i] instanceof IModuleFolder && (mf2 = ModuleHelper.getModuleFolder((IModuleFolder)mr[i], path)) != null) {
                return mf2;
            }
            ++i;
        }
        return null;
    }

    public static boolean folderExists(IModule module, IPath path) throws CoreException {
        return ModuleHelper.getModuleFile(module, path) != null;
    }

    public static boolean folderExists(IModule module, String path) throws CoreException {
        return ModuleHelper.folderExists(module, (IPath)new Path(path));
    }

    public static void listModule(IModule module) throws CoreException {
        System.out.println("--- Contents of " + module.getName() + "/" + module.getId() + "---");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.util.ProjectModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ProjectModule pm = (ProjectModule)module.loadAdapter((Class)clazz, null);
        IModuleResource[] mr = pm.members();
        int size = mr.length;
        int i = 0;
        while (i < size) {
            if (mr[i] instanceof IModuleFile) {
                System.out.println(mr[i].getName());
            } else {
                System.out.println(String.valueOf(mr[i].getName()) + "/");
                ModuleHelper.listFolder((IModuleFolder)mr[i], "  ");
            }
            ++i;
        }
        System.out.println("------");
    }

    protected static void listFolder(IModuleFolder mf, String pad) {
        IModuleResource[] mr = mf.members();
        if (mr == null) {
            return;
        }
        int size = mr.length;
        int i = 0;
        while (i < size) {
            if (mr[i] instanceof IModuleFile) {
                System.out.println(String.valueOf(pad) + mr[i].getName());
            } else {
                System.out.println(String.valueOf(pad) + mr[i].getName() + "/");
                ModuleHelper.listFolder((IModuleFolder)mr[i], String.valueOf(pad) + "  ");
            }
            ++i;
        }
    }
}

