/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.tests.j2ee;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.tests.j2ee.ModuleHelper;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerUtil;

public class NoSourceTestCase
extends TestCase {
    private static final String[] PROJECT_NAMES = new String[]{"PublishTestEAR", "PublishTestEJB", "test", "test2", "PublishTestWeb", "PublishTestWeb2", "PublishTestConnector", "PublishTestClient"};
    protected static IRuntime runtime;
    protected static IModule module;
    protected static IEnterpriseApplication ent;
    protected static IWebModule webModule;
    protected static IJ2EEModule j2eeModule;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void test001ImportModules() throws Exception {
        ModuleHelper.importProject("PublishEARNoSource.zip", PROJECT_NAMES);
    }

    public void test002IncrementalBuild() throws Exception {
        ModuleHelper.buildIncremental();
    }

    public void test003NumModules() throws Exception {
        NoSourceTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.ear").length, (int)1);
    }

    public void test004NumModules() throws Exception {
        NoSourceTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.web").length, (int)2);
    }

    public void test005NumModules() throws Exception {
        NoSourceTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.ejb").length, (int)1);
    }

    public void test006NumModules() throws Exception {
        NoSourceTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.utility").length, (int)2);
    }

    public void test007NumModules() throws Exception {
        NoSourceTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.appclient").length, (int)1);
    }

    public void test008NumModules() throws Exception {
        NoSourceTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.connector").length, (int)1);
    }

    public void test020EAR() throws Exception {
        module = ModuleHelper.getModuleFromProject("PublishTestEAR");
        NoSourceTestCase.assertNotNull((Object)module);
    }

    public void test021EAR() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/application.xml")) {
            NoSourceTestCase.fail();
        }
    }

    public void test022EAR() throws Exception {
        if (!ModuleHelper.fileExists(module, "PublishTestUtil2.jar")) {
            NoSourceTestCase.fail();
        }
    }

    public void test023EAR() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)3);
    }

    public void test024EAR() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)1);
    }

    public void test025EAR() throws Exception {
        NoSourceTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.ear");
    }

    public void test026EAR() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.core.IEnterpriseApplication");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ent = (IEnterpriseApplication)module.loadAdapter((Class)clazz, null);
        NoSourceTestCase.assertNotNull((Object)ent);
    }

    public void test027EAR() throws Exception {
        NoSourceTestCase.assertEquals((int)ent.getResourceFolders().length, (int)1);
    }

    public void test028EAR() throws Exception {
        NoSourceTestCase.assertEquals((int)ent.getModules().length, (int)6);
    }

    public void test029EAR() throws Exception {
        IModule[] modules = ent.getModules();
        int size = modules.length;
        ArrayList<String> list = new ArrayList<String>(size);
        int i = 0;
        while (i < size) {
            list.add(modules[i].getName());
            ++i;
        }
        String[] s = new String[]{"PublishTestEJB", "test2", "PublishTestWeb", "PublishTestWeb2", "PublishTestConnector", "PublishTestClient"};
        size = s.length;
        int i2 = 0;
        while (i2 < size) {
            if (!list.contains(s[i2])) {
                NoSourceTestCase.fail((String)("EAR does not contain " + s[i2]));
            }
            ++i2;
        }
    }

    public void test040Util() throws Exception {
        module = ModuleHelper.getModuleFromProject("test");
        NoSourceTestCase.assertNotNull((Object)module);
    }

    public void test041Util() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/MANIFEST.MF")) {
            NoSourceTestCase.fail();
        }
    }

    public void test042Util() throws Exception {
        if (!ModuleHelper.fileExists(module, "test.properties")) {
            NoSourceTestCase.fail();
        }
    }

    public void test043Util() throws Exception {
        if (!ModuleHelper.fileExists(module, "publish/TestUtil.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void test044Util() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)3);
    }

    public void test045Util() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)2);
    }

    public void test046Util() throws Exception {
        NoSourceTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.utility");
    }

    public void test047Util() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.core.IJ2EEModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        j2eeModule = (IJ2EEModule)module.loadAdapter((Class)clazz, null);
        NoSourceTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test048Util() throws Exception {
        NoSourceTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)2);
    }

    public void test049Util() throws Exception {
        NoSourceTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)1);
    }

    public void test050Util() throws Exception {
        NoSourceTestCase.assertFalse((boolean)j2eeModule.isBinary());
    }

    public void test060Util() throws Exception {
        module = ModuleHelper.getModuleFromProject("test2");
        NoSourceTestCase.assertNotNull((Object)module);
    }

    public void test061Util() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/MANIFEST.MF")) {
            NoSourceTestCase.fail();
        }
    }

    public void test062Util() throws Exception {
        if (!ModuleHelper.fileExists(module, "test.properties")) {
            NoSourceTestCase.fail();
        }
    }

    public void test063Util() throws Exception {
        if (!ModuleHelper.fileExists(module, "publish/TestUtil.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void test064Util() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)3);
    }

    public void test065Util() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)2);
    }

    public void test066Util() throws Exception {
        NoSourceTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.utility");
    }

    public void test067Util() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.core.IJ2EEModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        j2eeModule = (IJ2EEModule)module.loadAdapter((Class)clazz, null);
        NoSourceTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test068Util() throws Exception {
        NoSourceTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)2);
    }

    public void test069Util() throws Exception {
        NoSourceTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)1);
    }

    public void test070Util() throws Exception {
        NoSourceTestCase.assertFalse((boolean)j2eeModule.isBinary());
    }

    public void test080EJB() throws Exception {
        module = ModuleHelper.getModuleFromProject("PublishTestEJB");
        NoSourceTestCase.assertNotNull((Object)module);
    }

    public void test081EJB() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/MANIFEST.MF")) {
            NoSourceTestCase.fail();
        }
    }

    public void test082EJB() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/ejb-jar.xml")) {
            NoSourceTestCase.fail();
        }
    }

    public void test083EJB() throws Exception {
        if (!ModuleHelper.fileExists(module, "ejbs/MyBeanLocalHome.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void test084EJB() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)7);
    }

    public void test085EJB() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)2);
    }

    public void test086EJB() throws Exception {
        NoSourceTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.ejb");
    }

    public void test087EJB() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.core.IJ2EEModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        j2eeModule = (IJ2EEModule)module.loadAdapter((Class)clazz, null);
        NoSourceTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test088EJB() throws Exception {
        NoSourceTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)2);
    }

    public void test089EJB() throws Exception {
        NoSourceTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)1);
    }

    public void test090EJB() throws Exception {
        NoSourceTestCase.assertFalse((boolean)j2eeModule.isBinary());
    }

    public void test100Connector() throws Exception {
        module = ModuleHelper.getModuleFromProject("PublishTestConnector");
        NoSourceTestCase.assertNotNull((Object)module);
    }

    public void test101Connector() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/MANIFEST.MF")) {
            NoSourceTestCase.fail();
        }
    }

    public void test102Connector() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/ra.xml")) {
            NoSourceTestCase.fail();
        }
    }

    public void _test103Connector() throws Exception {
        if (!ModuleHelper.fileExists(module, "test/MyOtherConnectorClass.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void _test104Connector() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)5);
    }

    public void _test105Connector() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)3);
    }

    public void test106Connector() throws Exception {
        NoSourceTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.connector");
    }

    public void test107Connector() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.core.IJ2EEModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        j2eeModule = (IJ2EEModule)module.loadAdapter((Class)clazz, null);
        NoSourceTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test108Connector() throws Exception {
        NoSourceTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)1);
    }

    public void test109Connector() throws Exception {
        NoSourceTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)1);
    }

    public void test110Connector() throws Exception {
        NoSourceTestCase.assertFalse((boolean)j2eeModule.isBinary());
    }

    public void test120Client() throws Exception {
        module = ModuleHelper.getModuleFromProject("PublishTestClient");
        NoSourceTestCase.assertNotNull((Object)module);
    }

    public void test121Client() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/MANIFEST.MF")) {
            NoSourceTestCase.fail();
        }
    }

    public void test122Client() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/application-client.xml")) {
            NoSourceTestCase.fail();
        }
    }

    public void test123Client() throws Exception {
        if (!ModuleHelper.fileExists(module, "Main.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void test124Client() throws Exception {
        if (!ModuleHelper.fileExists(module, "Main2.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void _test125Client() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)4);
    }

    public void test126Client() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)1);
    }

    public void test127Client() throws Exception {
        NoSourceTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.appclient");
    }

    public void test128Client() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.core.IJ2EEModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        j2eeModule = (IJ2EEModule)module.loadAdapter((Class)clazz, null);
        NoSourceTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test129Client() throws Exception {
        NoSourceTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)2);
    }

    public void test130Client() throws Exception {
        NoSourceTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)1);
    }

    public void test131Client() throws Exception {
        NoSourceTestCase.assertFalse((boolean)j2eeModule.isBinary());
    }

    public void test140Web() throws Exception {
        module = ModuleHelper.getModuleFromProject("PublishTestWeb");
        NoSourceTestCase.assertNotNull((Object)module);
    }

    public void test141Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/MANIFEST.MF")) {
            NoSourceTestCase.fail();
        }
    }

    public void test142Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "WEB-INF/web.xml")) {
            NoSourceTestCase.fail();
        }
    }

    public void test143Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "test.jsp")) {
            NoSourceTestCase.fail();
        }
    }

    public void test144Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "WEB-INF/classes/servtest/TestServlet2.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void test145Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "WEB-INF/classes/servtest/TestServlet.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void test146Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "WEB-INF/lib/PublishTestUtil.jar")) {
            NoSourceTestCase.fail();
        }
    }

    public void _test147Web() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)6);
    }

    public void _test148Web() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)5);
    }

    public void test149Web() throws Exception {
        NoSourceTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.web");
    }

    public void test150Web() throws Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jst.server.core.IWebModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        webModule = (IWebModule)module.loadAdapter((Class)clazz, null);
        j2eeModule = webModule;
        NoSourceTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test151Web() throws Exception {
        NoSourceTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)1);
    }

    public void test152Web() throws Exception {
        NoSourceTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)1);
    }

    public void test153Web() throws Exception {
        NoSourceTestCase.assertEquals((int)webModule.getModules().length, (int)0);
    }

    public void test154Web() throws Exception {
        NoSourceTestCase.assertEquals((String)webModule.getContextRoot(), (String)"PublishTestWeb");
    }

    public void test155Web() throws Exception {
        NoSourceTestCase.assertFalse((boolean)webModule.isBinary());
    }

    public void test160Web() throws Exception {
        module = ModuleHelper.getModuleFromProject("PublishTestWeb2");
        NoSourceTestCase.assertNotNull((Object)module);
    }

    public void test161Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/MANIFEST.MF")) {
            NoSourceTestCase.fail();
        }
    }

    public void test162Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "WEB-INF/web.xml")) {
            NoSourceTestCase.fail();
        }
    }

    public void test163Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "WEB-INF/lib/test.jar")) {
            NoSourceTestCase.fail();
        }
    }

    public void test164Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "WEB-INF/classes/serv/AServlet.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void test165Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "WEB-INF/classes/serv/BServlet.class")) {
            NoSourceTestCase.fail();
        }
    }

    public void test166Web() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)5);
    }

    public void test167Web() throws Exception {
        NoSourceTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)5);
    }

    public void test168Web() throws Exception {
        NoSourceTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.web");
    }

    public void test169Web() throws Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jst.server.core.IWebModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        webModule = (IWebModule)module.loadAdapter((Class)clazz, null);
        j2eeModule = webModule;
        NoSourceTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test170Web() throws Exception {
        NoSourceTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)1);
    }

    public void test171Web() throws Exception {
        NoSourceTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)1);
    }

    public void test172Web() throws Exception {
        NoSourceTestCase.assertEquals((int)webModule.getModules().length, (int)1);
    }

    public void test173Web() throws Exception {
        NoSourceTestCase.assertEquals((String)webModule.getModules()[0].getName(), (String)"test");
    }

    public void test174Web() throws Exception {
        NoSourceTestCase.assertEquals((String)webModule.getContextRoot(), (String)"PublishTestWeb2");
    }

    public void test175Web() throws Exception {
        NoSourceTestCase.assertFalse((boolean)webModule.isBinary());
    }

    public void test199Cleanup() throws Exception {
        int size = PROJECT_NAMES.length;
        int i = 0;
        while (i < size) {
            ModuleHelper.deleteProject(PROJECT_NAMES[i]);
            ++i;
        }
    }
}

