/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.headless.tests.savestrategy;

import java.io.File;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wtp.headless.tests.savestrategy.AppClientImportOperationTest;
import org.eclipse.wtp.headless.tests.savestrategy.EJBImportOperationTest;
import org.eclipse.wtp.headless.tests.savestrategy.RARImportOperationTest;
import org.eclipse.wtp.headless.tests.savestrategy.WebImportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.plugin.HeadlessTestsPlugin;

public abstract class ModuleImportOperationTestCase
extends OperationTestCase {
    protected boolean dataModelShouldBeValid = true;
    public String TESTS_PATH = "TestData" + File.separator + this.getDirectory() + File.separator;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(RARImportOperationTest.class);
        suite.addTestSuite(EJBImportOperationTest.class);
        suite.addTestSuite(WebImportOperationTest.class);
        suite.addTestSuite(AppClientImportOperationTest.class);
        return suite;
    }

    public ModuleImportOperationTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.dataModelShouldBeValid = true;
    }

    protected abstract String getDirectory();

    protected abstract IDataModel getModelInstance();

    public void testImport(String projectName, String filename) throws Exception {
        IDataModel dataModel = this.getModelInstance();
        dataModel.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)filename);
        dataModel.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", (Object)projectName);
        if (this.dataModelShouldBeValid) {
            ModuleImportOperationTestCase.runAndVerify((IDataModel)dataModel);
        } else {
            ModuleImportOperationTestCase.verifyInvalidDataModel((IDataModel)dataModel);
        }
    }

    public void setServerTargetProperty(IDataModel dataModel) {
    }

    public void testImportTestCase_0() throws Exception {
        this.importIndex(0);
    }

    public void testImportTestCase_1() throws Exception {
        this.importIndex(1);
    }

    public void testImportTestCase_2() throws Exception {
        this.importIndex(2);
    }

    public void testImportTestCase_3() throws Exception {
        this.importIndex(3);
    }

    public void testImportTestCase_4() throws Exception {
        this.importIndex(4);
    }

    public void testImportTestCase_5() throws Exception {
        this.importIndex(5);
    }

    public void testImportTestCase_6() throws Exception {
        this.importIndex(6);
    }

    public void testImportTestCase_7() throws Exception {
        this.importIndex(7);
    }

    public void testImportTestCase_8() throws Exception {
        this.importIndex(8);
    }

    public void testImportTestCase_9() throws Exception {
        this.importIndex(9);
    }

    private void importIndex(int index) throws Exception {
        List projects = this.getImportableArchiveFileNames();
        if (index < projects.size()) {
            String jarName = projects.get(index).toString();
            String projectName = jarName.substring(jarName.lastIndexOf(File.separator) + 1, jarName.length() - 4);
            this.testImport(projectName, jarName);
        }
    }

    public void testImportTestCase_rest() throws Exception {
        List projects = this.getImportableArchiveFileNames();
        int i = 10;
        while (i < projects.size()) {
            String jarName = projects.get(i).toString();
            String projectName = jarName.substring(jarName.lastIndexOf(File.separator) + 1, jarName.length() - 4);
            this.testImport(projectName, jarName);
            ++i;
        }
    }

    public void testAllImportTestCases() throws Exception {
        List projects = this.getImportableArchiveFileNames();
        int i = 0;
        while (i < projects.size()) {
            String jarName = projects.get(i).toString();
            String projectName = jarName.substring(jarName.lastIndexOf(File.separator) + 1, jarName.length() - 4);
            this.testImport(projectName, jarName);
            ++i;
        }
    }

    protected List getImportableArchiveFileNames() {
        return ProjectUtility.getJarsInDirectory((Plugin)HeadlessTestsPlugin.getDefault(), (String)this.TESTS_PATH);
    }

    public void testBadFileName() throws Exception {
        this.dataModelShouldBeValid = false;
        this.testImport("BobTheProject", "BobTheFile");
    }
}

