/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.ear.operations;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.application.internal.operations.EARComponentImportDataModelProvider;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.FileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.WARFileImpl;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.tests.LogUtility;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wst.common.tests.SimpleTestSuite;
import org.eclipse.wtp.headless.tests.savestrategy.ModuleImportOperationTestCase;
import org.eclipse.wtp.j2ee.headless.tests.plugin.HeadlessTestsPlugin;

public class EARImportOperationTest
extends ModuleImportOperationTestCase {
    public static String fileSep = System.getProperty("file.separator");

    public EARImportOperationTest(String name) {
        super(name);
    }

    public List getUtilityJarsInEAR(EARFile earFile) {
        ArrayList<FileImpl> utilJars = new ArrayList<FileImpl>();
        try {
            List files = earFile.getArchiveFiles();
            int i = 0;
            while (i < files.size()) {
                FileImpl file = (FileImpl)files.get(i);
                if (file.isArchive() && !file.isModuleFile() && file.getURI().endsWith(".jar")) {
                    utilJars.add(file);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return utilJars;
    }

    public void testEARImportRootLocation() throws Exception {
    }

    private List getWebLibs(EARFile earFile) {
        List files = earFile.getArchiveFiles();
        ArrayList webLibs = new ArrayList();
        int i = 0;
        while (i < files.size()) {
            List webLib;
            FileImpl file = (FileImpl)files.get(i);
            if (file.isWARFile() && !(webLib = ((WARFileImpl)file).getLibArchives()).isEmpty()) {
                webLibs.addAll(webLib);
            }
            ++i;
        }
        return webLibs;
    }

    public static String getFullTestDataPath(String dataPath) {
        try {
            return ProjectUtility.getFullFileName((Plugin)HeadlessTestsPlugin.getDefault(), (String)dataPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void testImportEAR14() throws Exception {
    }

    public static Test suite() {
        return new SimpleTestSuite(EARImportOperationTest.class);
    }

    public void testImportProjectNameCollisionForEARImport() {
        try {
            String earName = "TestData" + fileSep + "EARImportTests" + fileSep + "Test13WEBEJBEAR.ear";
            EARImportOperationTest.load(null, earName);
            EARImportOperationTest.load(null, earName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testImportEAR12() throws Exception {
        String projectName = "Test12WEBEJBEAR";
        String earName = "TestData" + fileSep + "EARImportTests" + fileSep + "Test12WEBEJBEAR.ear";
        EARImportOperationTest.load(projectName, earName);
    }

    public void testImportEAR13() throws Exception {
        String projectName = "Test13WEBEJBEAR";
        String earName = "TestData" + fileSep + "EARImportTests" + fileSep + "Test13WEBEJBEAR.ear";
        EARImportOperationTest.load(projectName, earName);
    }

    public static void testAllEARImportProjects() throws Exception {
        String projectName = "EARTest";
        String earName = "TestData" + fileSep + "EARImportTests" + fileSep;
        List projects = ProjectUtility.getEarsInDirectory((Plugin)HeadlessTestsPlugin.getDefault(), (String)EARImportOperationTest.getFullTestDataPath(earName));
        int i = 0;
        while (i < projects.size()) {
            EARImportOperationTest.deleteAllProjects();
            LogUtility.getInstance().resetLogging();
            EARImportOperationTest.load(projectName, String.valueOf(earName) + projects.get(i));
            ++i;
        }
    }

    public static void load(String projectName, String earName) throws Exception {
    }

    public List getArchiveInEAR(String earFileURI) {
        CommonarchiveFactory factory = CommonarchiveFactory.eINSTANCE;
        ArrayList<File> moduleArchives = new ArrayList<File>();
        try {
            Archive archive = factory.openArchive(earFileURI);
            EList files = archive.getFiles();
            if (!files.isEmpty()) {
                int i = 0;
                while (i < files.size()) {
                    moduleArchives = new ArrayList();
                    File file = (File)files.get(i);
                    if (file.isArchive()) {
                        moduleArchives.add(file);
                    }
                    ++i;
                }
            }
        }
        catch (OpenFailureException oe) {
            oe.printStackTrace();
        }
        return moduleArchives;
    }

    protected String getDirectory() {
        return "EARImportTests";
    }

    protected List getImportableArchiveFileNames() {
        return ProjectUtility.getEarsInDirectory((Plugin)HeadlessTestsPlugin.getDefault(), (String)this.TESTS_PATH);
    }

    protected IDataModel getModelInstance() {
        return DataModelFactory.createDataModel((IDataModelProvider)new EARComponentImportDataModelProvider());
    }
}

