/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.ejb.operations;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wtp.headless.tests.savestrategy.EJBImportOperationTest;
import org.eclipse.wtp.headless.tests.savestrategy.ModuleImportOperationTestCase;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleExportOperationTestCase;

public class EJBExportOperationTest
extends ModuleExportOperationTestCase {
    public EJBExportOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(EJBExportOperationTest.class);
    }

    protected IDataModel getModelInstance() {
        return DataModelFactory.createDataModel((IDataModelProvider)new EJBComponentExportDataModelProvider());
    }

    protected ModuleImportOperationTestCase getImportTestCase() {
        return new EJBImportOperationTest("");
    }

    public void testExport(IVirtualComponent component, String filename) throws Exception {
        super.testExport(component, filename);
        this.testDDExported(component);
    }

    protected void testDDExported(IVirtualComponent component) throws Exception {
        block7: {
            EJBArtifactEdit ejbEdit = null;
            EJBJarFile ejbJarFile = null;
            try {
                ejbEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)component);
                if (ejbEdit == null) break block7;
                ejbJarFile = (EJBJarFile)ejbEdit.asArchive(true);
                Resource res = ejbJarFile.getDeploymentDescriptorResource();
                EJBExportOperationTest.assertNotNull((Object)res);
            }
            finally {
                if (ejbEdit != null) {
                    ejbEdit.dispose();
                }
                if (ejbJarFile != null) {
                    ejbJarFile.close();
                }
            }
        }
    }

    protected IProject[] getExportableProjects() throws Exception {
        IProject[] projs = super.getExportableProjects();
        ArrayList<IProject> filteredProjs = new ArrayList<IProject>();
        int i = 0;
        while (i < projs.length) {
            IProject project = projs[i];
            IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
            if (J2EEProjectUtilities.isEJBProject((IProject)comp.getProject())) {
                filteredProjs.add(project);
            }
            ++i;
        }
        return filteredProjs.toArray(new IProject[filteredProjs.size()]);
    }
}

