/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.ejb.operations;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.ejb.project.operations.IEjbFacetInstallDataModelProperties;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleProjectCreationOperationTest;

public class EJBProjectCreationOperationTest
extends ModuleProjectCreationOperationTest {
    public EJBProjectCreationOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(EJBProjectCreationOperationTest.class);
    }

    public IDataModel getComponentCreationDataModel() {
        return DataModelFactory.createDataModel(IEjbFacetInstallDataModelProperties.class);
    }

    public void testFindFilesUtility() {
        IFile file = null;
        IResource eclipseFile = null;
        try {
            this.testDefaults();
            IProject project = J2EEProjectUtilities.getAllProjectsInWorkspaceOfType((String)"jst.ejb")[0];
            IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
            try {
                if (!project.isSynchronized(2)) {
                    project.refreshLocal(2, null);
                }
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            eclipseFile = project.findMember((IPath)new Path("ejbModule/META-INF/ejb-jar.xml"));
            file = comp.getRootFolder().getFile((IPath)new Path("META-INF/ejb-jar.xml")).getUnderlyingFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Assert.assertTrue((eclipseFile != null && file != null && file.exists() ? 1 : 0) != 0);
    }

    public IDataModel getComponentCreationDataModelWithEar() {
        IDataModel model = this.getComponentCreationDataModel();
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetDM = map.getFacetDataModel("jst.ejb");
        facetDM.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", true);
        return model;
    }

    public void testUsingPublicAPI() throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel(IEjbFacetInstallDataModelProperties.class);
        String projName = "TestAPIEjbProject";
        String ejbVersionString = J2EEVersionUtil.convertVersionIntToString((int)21);
        IProjectFacet ejbFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
        IProjectFacetVersion ejbFacetVersion = ejbFacet.getVersion(ejbVersionString);
        this.addEJBProjectProperties(dataModel, projName, ejbFacetVersion);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        this.validateEJBProjectProperties(projName, ejbFacetVersion);
        this.validateEJBDescriptorProperties(projName);
    }

    public void testUsingPublicAPIEJB30() throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel(IEjbFacetInstallDataModelProperties.class);
        String projName = "TestAPIEjbProject";
        String ejbVersionString = J2EEVersionUtil.convertVersionIntToString((int)30);
        IProjectFacet ejbFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
        IProjectFacetVersion ejbFacetVersion = ejbFacet.getVersion(ejbVersionString);
        this.addEJBProjectProperties(dataModel, projName, ejbFacetVersion);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        this.validateEJBProjectProperties(projName, ejbFacetVersion);
    }

    private void validateEJBDescriptorProperties(String projName) {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        IVirtualComponent component = ComponentCore.createComponent((IProject)proj);
        IFile deploymentDescriptorFile = component.getRootFolder().getFile("META-INF/ejb-jar.xml").getUnderlyingFile();
        Assert.assertTrue((boolean)deploymentDescriptorFile.exists());
        EJBArtifactEdit jar = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)proj);
        Assert.assertNotNull((Object)jar);
        if (jar != null) {
            Assert.assertNotNull((Object)jar.getEJBJar());
        }
    }

    private void validateEJBProjectProperties(String projName, IProjectFacetVersion ejbFacetVersion) throws CoreException {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        Assert.assertTrue((boolean)proj.exists());
        IVirtualComponent component = ComponentCore.createComponent((IProject)proj);
        Assert.assertNotNull((Object)component);
        if (component != null) {
            Assert.assertNotNull((Object)component.getName());
        }
        Assert.assertTrue((boolean)proj.exists((IPath)new Path("/ejb333")));
        IFacetedProject facetedEJBProject = ProjectFacetsManager.create((IProject)proj);
        Assert.assertTrue((boolean)facetedEJBProject.hasProjectFacet(ejbFacetVersion));
    }

    public void testUsingPublicAPIEJB30WithAddToEar() throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel(IEjbFacetInstallDataModelProperties.class);
        String projName = "TestAPIEjbProject";
        String ejbVersionString = J2EEVersionUtil.convertVersionIntToString((int)30);
        IProjectFacet ejbFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
        IProjectFacetVersion ejbFacetVersion = ejbFacet.getVersion(ejbVersionString);
        this.addEJBProjectProperties(dataModel, projName, ejbFacetVersion);
        String earProjName = String.valueOf(projName) + "EAR";
        this.addEARProperties(dataModel, earProjName);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        this.validateEJBProjectProperties(projName, ejbFacetVersion);
        this.validateEARProjectProperties(earProjName, J2EEVersionUtil.getJ2EETextVersion((int)J2EEVersionUtil.convertEJBVersionStringToJ2EEVersionID((String)ejbVersionString)));
    }

    public void testUsingPublicAPIEJB30WithCreateEJBClient() throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel(IEjbFacetInstallDataModelProperties.class);
        String projName = "TestAPIEjbProject";
        String ejbVersionString = J2EEVersionUtil.convertVersionIntToString((int)30);
        IProjectFacet ejbFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
        IProjectFacetVersion ejbFacetVersion = ejbFacet.getVersion(ejbVersionString);
        this.addEJBProjectProperties(dataModel, projName, ejbFacetVersion);
        String ejbClientName = String.valueOf(projName) + "Client";
        this.addEJBClientProperties(dataModel, ejbClientName);
        String earProjName = String.valueOf(projName) + "EAR";
        this.addEARProperties(dataModel, earProjName);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        this.validateEJBProjectProperties(projName, ejbFacetVersion);
        this.validateEJBClientProjectProperties(ejbClientName);
        this.validateEARProjectProperties(earProjName, J2EEVersionUtil.getJ2EETextVersion((int)J2EEVersionUtil.convertEJBVersionStringToJ2EEVersionID((String)ejbVersionString)));
    }

    private void validateEJBClientProjectProperties(String ejbClientName) {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(ejbClientName);
        Assert.assertTrue((boolean)proj.exists());
    }

    private void validateEARProjectProperties(String earProjName, String earFacetVersionString) throws CoreException {
        IProject earProj = ResourcesPlugin.getWorkspace().getRoot().getProject(earProjName);
        Assert.assertTrue((boolean)earProj.exists());
        IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProj);
        Assert.assertNotNull((Object)earComponent);
        if (earComponent != null) {
            Assert.assertNotNull((Object)earComponent.getName());
        }
        IVirtualReference[] references = earComponent.getReferences();
        Assert.assertNotNull((Object)references);
        IProjectFacet earFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
        IProjectFacetVersion earFacetVersion = earFacet.getVersion(earFacetVersionString);
        IFacetedProject facetedEARProject = ProjectFacetsManager.create((IProject)earProj);
        Assert.assertTrue((boolean)facetedEARProject.hasProjectFacet(earFacetVersion));
    }

    private void addEARProperties(IDataModel dataModel, String earProjName) {
        dataModel.setBooleanProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", true);
        dataModel.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)earProjName);
    }

    private void addEJBProjectProperties(IDataModel dataModel, String projName, IProjectFacetVersion ejbFacetVersion) {
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel appmodel = (IDataModel)map.get((Object)"jst.ejb");
        appmodel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)ejbFacetVersion);
        appmodel.setStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", "ejb333");
    }

    private void addEJBClientProperties(IDataModel dataModel, String ejbClientName) {
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel appmodel = (IDataModel)map.get((Object)"jst.ejb");
        appmodel.setBooleanProperty("IEjbFacetInstallDataModelProperties.CREATE_CLIENT", true);
        appmodel.setStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_NAME ", ejbClientName);
    }
}

