/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.j2ee.operations;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wtp.headless.tests.savestrategy.ModuleImportOperationTestCase;
import org.eclipse.wtp.j2ee.headless.tests.appclient.operations.AppClientExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.ejb.operations.EJBExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.jca.operations.RARExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.plugin.HeadlessTestsPlugin;
import org.eclipse.wtp.j2ee.headless.tests.web.operations.WebExportOperationTest;

public abstract class ModuleExportOperationTestCase
extends OperationTestCase {
    protected boolean exportSourceFiles = false;
    protected boolean overwriteExisting = false;
    protected boolean dataModelShouldBeValid = true;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(RARExportOperationTest.class);
        suite.addTestSuite(EJBExportOperationTest.class);
        suite.addTestSuite(WebExportOperationTest.class);
        suite.addTestSuite(AppClientExportOperationTest.class);
        return suite;
    }

    public ModuleExportOperationTestCase(String name) {
        super(name);
    }

    public String getOutputPath(String relPath) {
        try {
            return ProjectUtility.getFullFileName((Plugin)HeadlessTestsPlugin.getDefault(), (String)relPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.exportSourceFiles = false;
        this.overwriteExisting = false;
    }

    public String getOutputDirectory() {
        return "testOutputs";
    }

    protected abstract ModuleImportOperationTestCase getImportTestCase();

    protected abstract IDataModel getModelInstance();

    protected IProject[] getExportableProjects() throws Exception {
        ModuleExportOperationTestCase.deleteAllProjects();
        ModuleImportOperationTestCase importTestCase = this.getImportTestCase();
        importTestCase.testAllImportTestCases();
        return ProjectUtility.getAllProjects();
    }

    public void testExport(IVirtualComponent component, String filename) throws Exception {
        IDataModel dataModel = this.getModelInstance();
        dataModel.setProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", (Object)(String.valueOf(this.getTestsOutputPath()) + filename));
        dataModel.setProperty("IJ2EEComponentExportDataModelProperties.COMPONENT", (Object)component);
        dataModel.setBooleanProperty("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES", this.exportSourceFiles);
        dataModel.setBooleanProperty("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING", this.overwriteExisting);
        if (this.dataModelShouldBeValid) {
            ModuleExportOperationTestCase.runAndVerify((IDataModel)dataModel);
        } else {
            ModuleExportOperationTestCase.verifyInvalidDataModel((IDataModel)dataModel);
        }
    }

    public void testAllWithExportSourceFilesWithOverwriteExisting() throws Exception {
        this.exportSourceFiles = true;
        this.overwriteExisting = true;
        this.testAllExportTestCases();
    }

    public void testAllWithExportSourceFilesWithoutOverwriteExisting() throws Exception {
        this.exportSourceFiles = true;
        this.overwriteExisting = false;
        this.testAllExportTestCases();
    }

    public void testAllWithoutExportSourceFilesWithoutOverwriteExisting() throws Exception {
        this.exportSourceFiles = false;
        this.overwriteExisting = false;
        this.testAllExportTestCases();
    }

    public void testAllWithoutExportSourceFilesWithOverwriteExisting() throws Exception {
        this.exportSourceFiles = false;
        this.overwriteExisting = true;
        this.testAllExportTestCases();
    }

    public void testOverwriteProjectExportSucceed() throws Exception {
        this.testAllWithoutExportSourceFilesWithOverwriteExisting();
    }

    public void testAllExportTestCases() throws Exception {
        int i;
        File exportDirectory = new File(this.getTestsOutputPath());
        if (exportDirectory.isDirectory()) {
            File[] contents = exportDirectory.listFiles();
            i = 0;
            while (i < contents.length) {
                if (!contents[i].isDirectory()) {
                    contents[i].delete();
                }
                ++i;
            }
        }
        IProject[] projects = this.getExportableProjects();
        i = 0;
        while (i < projects.length) {
            this.testExport(ComponentCore.createComponent((IProject)projects[i]), this.getFileName(projects[i].getName()));
            ++i;
        }
    }

    public String getFileName(String baseName) {
        StringBuffer result = new StringBuffer(baseName);
        result.append(this.exportSourceFiles ? "_withSource" : "_withoutSource").append(this.getModuleExportFileExt());
        return result.toString();
    }

    protected String getTestsOutputPath() {
        String relativeOutputTestsPath = "TestData" + File.separator + this.getOutputDirectory() + File.separator;
        return this.getOutputPath(relativeOutputTestsPath);
    }

    public String getModuleExportFileExt() {
        return ".jar";
    }
}

