/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.j2ee.operations;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.tests.DataModelVerifier;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wtp.j2ee.headless.tests.appclient.operations.AppClientProjectCreationOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.ejb.operations.EJBProjectCreationOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.verifiers.DataModelVerifierFactory;
import org.eclipse.wtp.j2ee.headless.tests.jca.operations.ConnectorProjectCreationOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.web.operations.WebProjectCreationOperationTest;

public abstract class ModuleProjectCreationOperationTest
extends OperationTestCase {
    private long componentSeed = System.currentTimeMillis();
    public static String DEFAULT_PROJECT_NAME = "SimpleProject";
    public static String DEFAULT_EAR_PROJECT_NAME = "SimpleEARProject";
    public static String DEFAULT_COMPONENT_NAME = "SimpleComponent";
    public static String DEFAULT_EAR_COMPONENT_NAME = "SimpleEARComponent";
    public static String DEFAULT_COMPONENT_WITH_EAR = "Component";

    public ModuleProjectCreationOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(AppClientProjectCreationOperationTest.class);
        suite.addTestSuite(EJBProjectCreationOperationTest.class);
        suite.addTestSuite(WebProjectCreationOperationTest.class);
        suite.addTestSuite(ConnectorProjectCreationOperationTest.class);
        return suite;
    }

    public void testDefaults() throws Exception {
        this.createSimpleModule(String.valueOf(DEFAULT_COMPONENT_NAME) + this.componentSeed);
    }

    public void createSimpleModule(String componentName) throws Exception {
        IDataModel dataModel = this.getComponentCreationDataModel();
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)componentName);
        ModuleProjectCreationOperationTest.runAndVerify((IDataModel)dataModel, (boolean)false, (boolean)true);
    }

    public abstract IDataModel getComponentCreationDataModel();

    public abstract IDataModel getComponentCreationDataModelWithEar();

    public static void verifyDataModel(IDataModel dataModel) throws Exception {
        DataModelVerifier verifier = DataModelVerifierFactory.getInstance().createVerifier(dataModel);
        verifier.verify(dataModel);
    }

    public void testAddtoEAR() throws Exception {
        this.createModuleWithEAR(String.valueOf(DEFAULT_COMPONENT_WITH_EAR) + this.componentSeed);
    }

    public void createModuleWithEAR(String componentName) throws Exception {
        IDataModel dataModel = this.getComponentCreationDataModelWithEar();
        if (dataModel != null) {
            dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)componentName);
            ModuleProjectCreationOperationTest.runAndVerify((IDataModel)dataModel, (boolean)false, (boolean)true);
            Assert.assertTrue((boolean)dataModel.getStringProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME").equals(String.valueOf(componentName) + "EAR"));
        }
    }
}

