/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.web.operations;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.web.project.facet.IWebFacetInstallDataModelProperties;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleProjectCreationOperationTest;

public class WebProjectCreationOperationTest
extends ModuleProjectCreationOperationTest {
    public WebProjectCreationOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(WebProjectCreationOperationTest.class);
    }

    public IDataModel getComponentCreationDataModel() {
        return DataModelFactory.createDataModel(IWebFacetInstallDataModelProperties.class);
    }

    public IDataModel getComponentCreationDataModelWithEar() {
        IDataModel model = DataModelFactory.createDataModel(IWebFacetInstallDataModelProperties.class);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetDM = map.getFacetDataModel("jst.web");
        facetDM.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", true);
        return model;
    }

    public void testUsingPublicAPI() throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel(IWebFacetInstallDataModelProperties.class);
        String projName = "TestAPIWebProject";
        String webVersionString = J2EEVersionUtil.convertVersionIntToString((int)24);
        IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
        IProjectFacetVersion webFacetVersion = webFacet.getVersion(webVersionString);
        this.addWebProjectProperties(dataModel, projName, webFacetVersion);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        this.validateWebProjectProperties(projName, webFacetVersion);
        this.validateWebDescriptorProperties(projName);
    }

    public void testUsingPublicAPIWeb25() throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel(IWebFacetInstallDataModelProperties.class);
        String projName = "TestAPIWebProject";
        String webVersionString = J2EEVersionUtil.convertVersionIntToString((int)25);
        IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
        IProjectFacetVersion webFacetVersion = webFacet.getVersion(webVersionString);
        this.addWebProjectProperties(dataModel, projName, webFacetVersion);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        this.validateWebProjectProperties(projName, webFacetVersion);
    }

    public void testUsingPublicAPIWeb25WithAddToEar() throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel(IWebFacetInstallDataModelProperties.class);
        String projName = "TestAPIWebProject";
        String webVersionString = J2EEVersionUtil.convertVersionIntToString((int)25);
        IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
        IProjectFacetVersion webFacetVersion = webFacet.getVersion(webVersionString);
        this.addWebProjectProperties(dataModel, projName, webFacetVersion);
        String earProjName = String.valueOf(projName) + "EAR";
        this.addEARProperties(dataModel, earProjName);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        this.validateWebProjectProperties(projName, webFacetVersion);
        this.validateEARProjectProperties(earProjName, J2EEVersionUtil.getJ2EETextVersion((int)J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID((String)webVersionString)));
    }

    private void addEARProperties(IDataModel dataModel, String earProjName) {
        dataModel.setBooleanProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", true);
        dataModel.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)earProjName);
    }

    private void addWebProjectProperties(IDataModel dataModel, String projName, IProjectFacetVersion web25) {
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel webmodel = (IDataModel)map.get((Object)"jst.web");
        webmodel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)web25);
        webmodel.setStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", "web333");
        webmodel.setStringProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER", "src444");
    }

    private void validateWebDescriptorProperties(String projName) {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        IVirtualComponent component = ComponentCore.createComponent((IProject)proj);
        IFile deploymentDescriptorFile = component.getRootFolder().getFile("WEB-INF/web.xml").getUnderlyingFile();
        Assert.assertTrue((boolean)deploymentDescriptorFile.exists());
        WebArtifactEdit web = WebArtifactEdit.getWebArtifactEditForRead((IProject)proj);
        Assert.assertNotNull((Object)web);
        if (web != null) {
            Assert.assertNotNull((Object)web.getWebApp());
        }
    }

    private void validateWebProjectProperties(String projName, IProjectFacetVersion webFacetVersion) throws CoreException {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        Assert.assertTrue((boolean)proj.exists());
        IVirtualComponent component = ComponentCore.createComponent((IProject)proj);
        Assert.assertNotNull((Object)component);
        if (component != null) {
            Assert.assertNotNull((Object)component.getName());
        }
        Assert.assertTrue((boolean)proj.exists((IPath)new Path("/web333")));
        Assert.assertTrue((boolean)proj.exists((IPath)new Path("/src444")));
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)proj);
        Assert.assertTrue((boolean)facetedProject.hasProjectFacet(webFacetVersion));
    }

    private void validateEARProjectProperties(String earProjName, String earFacetVersionString) throws CoreException {
        IProject earProj = ResourcesPlugin.getWorkspace().getRoot().getProject(earProjName);
        Assert.assertTrue((boolean)earProj.exists());
        IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProj);
        Assert.assertNotNull((Object)earComponent);
        if (earComponent != null) {
            Assert.assertNotNull((Object)earComponent.getName());
        }
        IVirtualReference[] references = earComponent.getReferences();
        Assert.assertNotNull((Object)references);
        IProjectFacet earFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
        IProjectFacetVersion earFacetVersion = earFacet.getVersion(earFacetVersionString);
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)earProj);
        Assert.assertTrue((boolean)facetedProject.hasProjectFacet(earFacetVersion));
    }
}

