/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.tests;

import java.util.Collection;
import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.tests.support.TestUtils;

public class FacetConstraintsTests
extends TestCase {
    private static IProjectFacet f1 = ProjectFacetsManager.getProjectFacet((String)"fct_f1");
    private static IProjectFacetVersion f1v10 = f1.getVersion("1.0");
    private static IProjectFacet f3 = ProjectFacetsManager.getProjectFacet((String)"fct_f3");
    private static IProjectFacetVersion f3v10 = f3.getVersion("1.0");
    private static IProjectFacet f4 = ProjectFacetsManager.getProjectFacet((String)"fct_f4");
    private static IProjectFacetVersion f4v10 = f4.getVersion("1.0");
    private static IProjectFacet f5 = ProjectFacetsManager.getProjectFacet((String)"fct_f5");
    private static IProjectFacetVersion f5v10 = f5.getVersion("1.0");
    private static IProjectFacet f6 = ProjectFacetsManager.getProjectFacet((String)"fct_f6");
    private static IProjectFacetVersion f6v10 = f6.getVersion("1.0");
    private static IProjectFacetVersion f6v23 = f6.getVersion("2.3");
    private static IProjectFacetVersion f6v37 = f6.getVersion("3.7");
    private static IProjectFacetVersion f6v40 = f6.getVersion("4.0");
    private static IProjectFacetVersion f6v45 = f6.getVersion("4.5");
    private static IProjectFacet f7 = ProjectFacetsManager.getProjectFacet((String)"fct_f7");
    private static IProjectFacetVersion f7v10 = f7.getVersion("1.0");
    private static IProjectFacetVersion f7v20 = f7.getVersion("2.0");
    private static IProjectFacet f8 = ProjectFacetsManager.getProjectFacet((String)"fct_f8");
    private static IProjectFacetVersion f8v10 = f8.getVersion("1.0");
    private static IProjectFacetVersion f8v20 = f8.getVersion("2.0");
    private static IProjectFacetVersion f8v30 = f8.getVersion("3.0");
    private static IProjectFacet f9 = ProjectFacetsManager.getProjectFacet((String)"fct_f9");
    private static IProjectFacetVersion f9v10 = f9.getVersion("1.0");
    private static IProjectFacet f10 = ProjectFacetsManager.getProjectFacet((String)"fct_f10");
    private static IProjectFacetVersion f10v10 = f10.getVersion("1.0");
    private static IProjectFacetVersion f10v20 = f10.getVersion("2.0");

    private FacetConstraintsTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Facet Constraint Tests");
        suite.addTest((Test)new FacetConstraintsTests("testIndirectConflict1"));
        suite.addTest((Test)new FacetConstraintsTests("testIndirectConflict2"));
        suite.addTest((Test)new FacetConstraintsTests("testIndirectConflict3"));
        suite.addTest((Test)new FacetConstraintsTests("testIndirectConflict4"));
        suite.addTest((Test)new FacetConstraintsTests("testIndirectConflict5"));
        suite.addTest((Test)new FacetConstraintsTests("testIndirectConflict6"));
        suite.addTest((Test)new FacetConstraintsTests("testIndirectConflict7"));
        suite.addTest((Test)new FacetConstraintsTests("testIndirectConflict8"));
        suite.addTest((Test)new FacetConstraintsTests("testRequiresWithNoVersion"));
        suite.addTest((Test)new FacetConstraintsTests("testRequiresWithUnknownVersion"));
        suite.addTest((Test)new FacetConstraintsTests("testGroupRequires"));
        suite.addTest((Test)new FacetConstraintsTests("testGroupRequiresSoft"));
        return suite;
    }

    public void testIndirectConflict1() {
        FacetConstraintsTests.assertTrue((boolean)f1v10.conflictsWith(f3v10));
    }

    public void testIndirectConflict2() {
        FacetConstraintsTests.assertTrue((boolean)f3v10.conflictsWith(f1v10));
    }

    public void testIndirectConflict3() {
        FacetConstraintsTests.assertTrue((boolean)f4v10.conflictsWith(f3v10));
    }

    public void testIndirectConflict4() {
        FacetConstraintsTests.assertTrue((boolean)f3v10.conflictsWith(f4v10));
    }

    public void testIndirectConflict5() {
        FacetConstraintsTests.assertFalse((boolean)f1v10.conflictsWith(f5v10));
    }

    public void testIndirectConflict6() {
        FacetConstraintsTests.assertFalse((boolean)f5v10.conflictsWith(f1v10));
    }

    public void testIndirectConflict7() {
        FacetConstraintsTests.assertFalse((boolean)f4v10.conflictsWith(f5v10));
    }

    public void testIndirectConflict8() {
        FacetConstraintsTests.assertFalse((boolean)f5v10.conflictsWith(f4v10));
    }

    public void testRequiresWithNoVersion() {
        FacetConstraintsTests.assertFalse((boolean)f7v10.getConstraint().check((Collection)Collections.EMPTY_SET).isOK());
        FacetConstraintsTests.assertTrue((boolean)f7v10.getConstraint().check((Collection)TestUtils.asSet(f6v10)).isOK());
        FacetConstraintsTests.assertTrue((boolean)f7v10.getConstraint().check((Collection)TestUtils.asSet(f6v23)).isOK());
        FacetConstraintsTests.assertTrue((boolean)f7v10.getConstraint().check((Collection)TestUtils.asSet(f6v37)).isOK());
        FacetConstraintsTests.assertTrue((boolean)f7v10.getConstraint().check((Collection)TestUtils.asSet(f6v40)).isOK());
        FacetConstraintsTests.assertTrue((boolean)f7v10.getConstraint().check((Collection)TestUtils.asSet(f6v45)).isOK());
    }

    public void testRequiresWithUnknownVersion() {
        FacetConstraintsTests.assertFalse((boolean)f7v20.getConstraint().check((Collection)Collections.EMPTY_SET).isOK());
        FacetConstraintsTests.assertFalse((boolean)f7v20.getConstraint().check((Collection)TestUtils.asSet(f6v10)).isOK());
        FacetConstraintsTests.assertFalse((boolean)f7v20.getConstraint().check((Collection)TestUtils.asSet(f6v23)).isOK());
        FacetConstraintsTests.assertFalse((boolean)f7v20.getConstraint().check((Collection)TestUtils.asSet(f6v37)).isOK());
        FacetConstraintsTests.assertFalse((boolean)f7v20.getConstraint().check((Collection)TestUtils.asSet(f6v40)).isOK());
        FacetConstraintsTests.assertFalse((boolean)f7v20.getConstraint().check((Collection)TestUtils.asSet(f6v45)).isOK());
    }

    public void testGroupRequires() {
        FacetConstraintsTests.assertFalse((boolean)f10v10.getConstraint().check((Collection)Collections.EMPTY_SET).isOK());
        FacetConstraintsTests.assertTrue((boolean)f10v10.getConstraint().check((Collection)TestUtils.asSet(f8v10)).isOK());
        FacetConstraintsTests.assertTrue((boolean)f10v10.getConstraint().check((Collection)TestUtils.asSet(f8v20)).isOK());
        FacetConstraintsTests.assertFalse((boolean)f10v10.getConstraint().check((Collection)TestUtils.asSet(f8v30)).isOK());
        FacetConstraintsTests.assertTrue((boolean)f10v10.getConstraint().check((Collection)TestUtils.asSet(f9v10)).isOK());
        FacetConstraintsTests.assertFalse((boolean)f10v10.getConstraint().check((Collection)TestUtils.asSet(f1v10)).isOK());
    }

    public void testGroupRequiresSoft() {
        FacetConstraintsTests.assertTrue((boolean)f10v20.getConstraint().check((Collection)Collections.EMPTY_SET).isOK());
        FacetConstraintsTests.assertTrue((boolean)f10v20.getConstraint().check((Collection)TestUtils.asSet(f8v10)).isOK());
        FacetConstraintsTests.assertTrue((boolean)f10v20.getConstraint().check((Collection)TestUtils.asSet(f8v20)).isOK());
        FacetConstraintsTests.assertTrue((boolean)f10v20.getConstraint().check((Collection)TestUtils.asSet(f8v30)).isOK());
        FacetConstraintsTests.assertTrue((boolean)f10v20.getConstraint().check((Collection)TestUtils.asSet(f9v10)).isOK());
        FacetConstraintsTests.assertTrue((boolean)f10v20.getConstraint().check((Collection)TestUtils.asSet(f1v10)).isOK());
    }
}

