/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.tests.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateModuleCommand;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.preferences.PersistentServerRuntimeContext;
import org.eclipse.jst.ws.internal.context.ScenarioContext;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.jst.ws.tests.plugin.TestsPlugin;
import org.eclipse.jst.ws.tests.util.DynamicPopupJUnitWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.common.WaitForAutoBuildCommand;
import org.eclipse.wst.command.internal.env.context.PersistentActionDialogsContext;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.AccumulateStatusHandler;
import org.eclipse.wst.command.internal.env.eclipse.IEclipseStatusHandler;
import org.eclipse.wst.command.internal.env.preferences.ActionDialogPreferenceType;
import org.eclipse.wst.command.internal.env.ui.eclipse.EnvironmentUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.internal.preferences.PersistentWSIAPContext;
import org.eclipse.wst.ws.internal.preferences.PersistentWSISSBPContext;

public class JUnitUtils {
    public static IRuntime createServerRuntime(String runtimeTypeId, String serverInstallPath) throws Exception {
        IRuntimeType rt = ServerCore.findRuntimeType((String)runtimeTypeId);
        IRuntimeWorkingCopy wc = rt.createRuntime("aRuntime", null);
        wc.setLocation((IPath)new Path(serverInstallPath));
        return wc.save(true, null);
    }

    public static IServer createServer(String name, String serverTypeId, IRuntime runtime, IEnvironment env, IProgressMonitor monitor) throws Exception {
        IServerType serverType = ServerCore.findServerType((String)serverTypeId);
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            if (servers[i].getServerType().getId().equals(serverType.getId())) {
                return servers[i];
            }
            ++i;
        }
        IServerWorkingCopy serverWc = serverType.createServer(serverTypeId, null, monitor);
        serverWc.setName(name);
        serverWc.setRuntime(runtime);
        IServer server = serverWc.saveAll(true, monitor);
        return server;
    }

    public static IServer createServer(String javaRuntimePath, String jreID, String name, String serverTypeId, IRuntime runtime, IEnvironment env, IProgressMonitor monitor) throws Exception {
        IServerType serverType = ServerCore.findServerType((String)serverTypeId);
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            if (servers[i].getServerType().getId().equals(serverType.getId())) {
                return servers[i];
            }
            ++i;
        }
        IServerWorkingCopy serverWc = serverType.createServer(serverTypeId, null, monitor);
        serverWc.setName(name);
        serverWc.setRuntime(runtime);
        IServer server = serverWc.saveAll(true, monitor);
        return server;
    }

    public static void startServer(IServer server, IEnvironment env) throws Exception {
        final IServer currentServer = server;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    currentServer.start("run", monitor);
                }
                catch (CoreException e) {
                    InterruptedException wrapper = new InterruptedException(e.getMessage());
                    wrapper.setStackTrace(e.getStackTrace());
                    throw wrapper;
                }
            }
        };
        PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
    }

    public static boolean removeEARFromServer(IServer server, IProject earProject, IEnvironment env, IProgressMonitor monitor) throws Exception {
        int numberOfModules = server.getModules().length;
        if (server != null) {
            IModule earProjectModule = ServerUtil.getModule((IProject)earProject);
            final IModule[] modules = new IModule[]{earProjectModule};
            new ServerUtils().modifyModules(env, server, earProjectModule, false, monitor);
            final IServer currentServer = server;
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    int i = 0;
                    while (i < 1000) {
                        int moduleState = currentServer.getModuleState(modules);
                        if (moduleState != 2 && moduleState != 3) break;
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace(System.err);
                        }
                        ++i;
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
            return server.getModules().length == numberOfModules - 1;
        }
        return false;
    }

    public static boolean removeModuleFromServer(IServer server, IProject webProject, IEnvironment env, IProgressMonitor monitor) throws Exception {
        int numberOfModules = server.getModules().length;
        if (server != null) {
            IModule webProjectModule = ServerUtil.getModule((IProject)webProject);
            final IModule[] modules = new IModule[]{webProjectModule};
            new ServerUtils().modifyModules(env, server, webProjectModule, false, monitor);
            final IServer currentServer = server;
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    int i = 0;
                    while (i < 1000) {
                        int moduleState = currentServer.getModuleState(modules);
                        if (moduleState != 2 && moduleState != 3) break;
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace(System.err);
                        }
                        ++i;
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
            return server.getModules().length == numberOfModules - 1;
        }
        return false;
    }

    public static void syncBuildProject(IProject project, IEnvironment env, IProgressMonitor monitor) throws Exception {
        project.build(6, monitor);
        WaitForAutoBuildCommand cmd = new WaitForAutoBuildCommand();
        cmd.setEnvironment(env);
        cmd.execute(monitor, null);
    }

    private static void copyTestFiles(String pathString, int rootSegmentLength, IFolder destFolder, IEnvironment env, IProgressMonitor monitor) throws Exception {
        Enumeration e = TestsPlugin.getDefault().getBundle().getEntryPaths(pathString);
        while (e.hasMoreElements()) {
            String filePath = (String)e.nextElement();
            if (filePath.endsWith("/")) {
                JUnitUtils.copyTestFiles(filePath, rootSegmentLength, destFolder, env, monitor);
                continue;
            }
            Path fileIPath = new Path(filePath);
            FileResourceUtils.copyFile((ResourceContext)EnvironmentUtils.getResourceContext((IEnvironment)env), (Plugin)TestsPlugin.getDefault(), (IPath)fileIPath.removeLastSegments(fileIPath.segmentCount() - rootSegmentLength), (IPath)new Path(filePath).removeFirstSegments(rootSegmentLength), (IPath)destFolder.getFullPath(), (IProgressMonitor)monitor, (IStatusHandler)env.getStatusHandler());
        }
    }

    public static void copyTestData(String dataSubdirectory, IFolder destFolder, IEnvironment env, IProgressMonitor monitor) throws Exception {
        String pathString = "/data/" + dataSubdirectory;
        JUnitUtils.copyTestFiles(pathString, new Path(pathString).segmentCount(), destFolder, env, monitor);
    }

    public static void hideActionDialogs() {
        PersistentActionDialogsContext actionDialogsCtx = PersistentActionDialogsContext.getInstance();
        ActionDialogPreferenceType[] actionDialogPrefs = actionDialogsCtx.getDialogs();
        int i = 0;
        while (i < actionDialogPrefs.length) {
            actionDialogsCtx.setActionDialogEnabled(actionDialogPrefs[i].getId(), true);
            ++i;
        }
    }

    public static boolean enableProxyGeneration(boolean enable) {
        ScenarioContext ctx = WebServicePlugin.getInstance().getScenarioContext();
        boolean previousSetting = ctx.getGenerateProxy();
        ctx.setGenerateProxy(enable);
        return previousSetting;
    }

    public static boolean enableOverwrite(boolean enable) {
        ResourceContext ctx = WebServicePlugin.getInstance().getResourceContext();
        boolean previousSetting = ctx.isOverwriteFilesEnabled();
        ctx.setOverwriteFilesEnabled(enable);
        return previousSetting;
    }

    public static void setRuntimePreference(String rt) {
        PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        context.setRuntimeId(rt);
    }

    public static void disableWSIDialog(IProject project) {
        PersistentWSIAPContext ctx = WSPlugin.getInstance().getWSIAPContext();
        ctx.updateProjectWSICompliances(project, "2");
        PersistentWSISSBPContext ctx2 = WSPlugin.getInstance().getWSISSBPContext();
        ctx2.updateProjectWSICompliances(project, "2");
    }

    public static void setWSRuntimeServer(String wsRuntimeId, String serverTypeId) {
        PersistentServerRuntimeContext serverRuntimeCtx = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        serverRuntimeCtx.setRuntimeId(wsRuntimeId);
        serverRuntimeCtx.setServerFactoryId(serverTypeId);
    }

    private static IStatus[] launchWizard(String pluginNS, String wizardId, String objectClassId, IStructuredSelection initialSelection) throws Exception {
        AccumulateStatusHandler statusHandler = new AccumulateStatusHandler();
        DynamicPopupJUnitWizard wizard = new DynamicPopupJUnitWizard((IEclipseStatusHandler)statusHandler);
        wizard.setInitialData(wizardId);
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        try {
            wizard.runHeadLess(initialSelection, (IRunnableContext)monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new IStatus[]{StatusUtils.errorStatus((Throwable)e)};
        }
        return statusHandler.getAllReports();
    }

    public static IStatus[] launchCreationWizard(String wizardId, String objectClassId, IStructuredSelection initialSelection) throws Exception {
        return JUnitUtils.launchWizard("org.eclipse.jst.ws.creation.ui", wizardId, objectClassId, initialSelection);
    }

    public static IStatus[] launchConsumptionWizard(String wizardId, String objectClassId, IStructuredSelection initialSelection) throws Exception {
        return JUnitUtils.launchWizard("org.eclipse.jst.ws.internal.consumption.ui", wizardId, objectClassId, initialSelection);
    }

    public static IStatus createWebModule(String webProjectName, String moduleName, String serverFactoryId, String j2eeVersion, IEnvironment env, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            CreateModuleCommand createWeb = new CreateModuleCommand();
            createWeb.setProjectName(webProjectName);
            createWeb.setModuleName(moduleName);
            createWeb.setModuleType(1);
            createWeb.setJ2eeLevel(j2eeVersion);
            createWeb.setServerFactoryId(serverFactoryId);
            createWeb.setEnvironment(env);
            return createWeb.execute(monitor, null);
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((Throwable)e);
            return status;
        }
    }
}

