/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.emftests;

import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.ApplicationPackage;
import org.eclipse.jst.j2ee.application.ApplicationResource;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFEditingTest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;

public class EarEMFEditTest
extends GeneralEMFEditingTest {
    EARFile earFile;
    int createdModules = 0;
    private int NUM_MODULES = 4;

    public EarEMFEditTest(String name) {
        super(name);
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    public EjbFactory getEjbFactory() {
        return EjbPackage.eINSTANCE.getEjbFactory();
    }

    public ApplicationFactory getApplicationFactory() {
        return ApplicationPackage.eINSTANCE.getApplicationFactory();
    }

    public WebapplicationFactory getWebAppFactory() {
        return WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.EarEMFEditTest", "-noloading"};
        TestRunner.main((String[])className);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new EarEMFEditTest("testEAREdit"));
        return suite;
    }

    public void testEAREdit() throws Exception {
        this.getEAR();
        EarEMFEditTest.assertEquals((String)"1.2", (String)this.earFile.getDeploymentDescriptor().getVersion());
        ApplicationResource DD = (ApplicationResource)this.earFile.getDeploymentDescriptorResource();
        this.setVersion(1);
        this.setModuleType(0);
        this.editRoot(DD.getRootObject());
        String curDir = AutomatedBVT.baseDirectory;
        String out = String.valueOf(curDir) + "testOutput/EditOutput/EMFModelCreationTests/EditEAR";
        this.earFile.extractTo(out, 126);
        this.earFile.close();
        String cfr_ignored_0 = String.valueOf(curDir) + "EMFTests/application.xml";
        String cfr_ignored_1 = String.valueOf(curDir) + out + "/META-INF/application.xml";
    }

    public void getEAR() throws OpenFailureException {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "loose_module_workspace/LooseEAR/";
        this.earFile = this.getArchiveFactory().openEARFile(in);
        EarEMFEditTest.assertTrue((this.earFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public HashSet ignorableAttributes() {
        HashSet<String> set = new HashSet<String>();
        set.add("id");
        return set;
    }

    public EObject createInstance(EClass eClassifier) {
        if (eClassifier.getName().equals("Module")) {
            ++this.createdModules;
            switch (this.createdModules) {
                case 1: {
                    return this.createJavaModuleInstance(eClassifier);
                }
                case 2: {
                    return this.createEJBModuleInstance(eClassifier);
                }
                case 3: {
                    return this.createWebModuleInstance(eClassifier);
                }
                case 4: {
                    return this.createConnetorModuleInstance(eClassifier);
                }
            }
            return this.createJavaModuleInstance(eClassifier);
        }
        return super.createInstance(eClassifier);
    }

    private EObject createConnetorModuleInstance(EClass eClassifier) {
        return ((ApplicationFactory)eClassifier.getEPackage().getEFactoryInstance()).createConnectorModule();
    }

    private EObject createWebModuleInstance(EClass eClassifier) {
        return ((ApplicationFactory)eClassifier.getEPackage().getEFactoryInstance()).createWebModule();
    }

    private EObject createEJBModuleInstance(EClass eClassifier) {
        return ((ApplicationFactory)eClassifier.getEPackage().getEFactoryInstance()).createEjbModule();
    }

    private EObject createJavaModuleInstance(EClass eClassifier) {
        return ((ApplicationFactory)eClassifier.getEPackage().getEFactoryInstance()).createJavaClientModule();
    }

    public Object getSharedObjectByType(EObject owner, EReference ref) {
        if (ref.getName().equals("module")) {
            return this.createJavaModuleInstance((EClass)ref.getEType());
        }
        return super.getSharedObjectByType(owner, ref);
    }

    public int getDepthForAttribute(EReference ref) {
        if (ref.getName().equals("modules")) {
            return this.NUM_MODULES;
        }
        return super.getDepthForAttribute(ref);
    }
}

