/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.appconfig.provider;

import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.jsf.core.jsfappconfig.IJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.jsfappconfig.JARFileJSFAppConfigProvider;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.RuntimeClasspathJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentExtensionType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;

public class TestJARFileJSFAppConfigProvider
extends TestCase {
    private WebProjectTestEnvironment _testEnv;
    private JDTTestEnvironment _jdtTestEnv;
    private IClasspathEntry _noExtData;
    private IClasspathEntry _withExtData;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        this._testEnv = new WebProjectTestEnvironment("ELValidationTest_" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName());
        this._testEnv.createProject(false);
        TestJARFileJSFAppConfigProvider.assertNotNull((Object)this._testEnv);
        TestJARFileJSFAppConfigProvider.assertNotNull((Object)this._testEnv.getTestProject());
        TestJARFileJSFAppConfigProvider.assertTrue((boolean)this._testEnv.getTestProject().isAccessible());
        this._jdtTestEnv = new JDTTestEnvironment((ProjectTestEnvironment)this._testEnv);
        this._noExtData = this._jdtTestEnv.addJarClasspathEntry(TestsPlugin.getDefault().getBundle(), "/testfiles/appconfig/noextdata.jar");
        TestJARFileJSFAppConfigProvider.assertNotNull((Object)this._noExtData);
        this._withExtData = this._jdtTestEnv.addJarClasspathEntry(TestsPlugin.getDefault().getBundle(), "/testfiles/appconfig/withextdata.jar");
        TestJARFileJSFAppConfigProvider.assertNotNull((Object)this._withExtData);
        JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this._testEnv);
        jsfFacedEnv.initialize("1.2");
    }

    public void testNoExtensionData() throws Exception {
        JARFileJSFAppConfigProvider provider = this.createProvider(this._noExtData);
        FacesConfigType facesConfig = provider.getFacesConfigModel();
        TestJARFileJSFAppConfigProvider.assertNotNull((Object)facesConfig);
        this.verifyCommonElements(facesConfig);
    }

    public void testWithExtensionData() throws Exception {
        JARFileJSFAppConfigProvider provider = this.createProvider(this._withExtData);
        FacesConfigType facesConfig = provider.getFacesConfigModel();
        TestJARFileJSFAppConfigProvider.assertNotNull((Object)facesConfig);
        this.verifyCommonElements(facesConfig);
        ComponentType componentType = (ComponentType)facesConfig.getComponent().get(0);
        TestJARFileJSFAppConfigProvider.assertEquals((int)1, (int)componentType.getComponentExtension().size());
        ComponentExtensionType extType = (ComponentExtensionType)componentType.getComponentExtension().get(0);
        TestJARFileJSFAppConfigProvider.assertEquals((int)0, (int)extType.getChildNodes().size());
    }

    private void verifyCommonElements(FacesConfigType facesConfig) {
        TestJARFileJSFAppConfigProvider.assertEquals((int)1, (int)facesConfig.getComponent().size());
        ComponentType component = (ComponentType)facesConfig.getComponent().get(0);
        TestJARFileJSFAppConfigProvider.assertEquals((String)"com.ibm.odc.jsf.RichTextEditor", (String)component.getComponentType().getTextContent());
        TestJARFileJSFAppConfigProvider.assertEquals((String)"com.ibm.odc.jsf.components.components.rte.UIRichTextEditor", (String)component.getComponentClass().getTextContent());
        TestJARFileJSFAppConfigProvider.assertEquals((int)1, (int)facesConfig.getManagedBean().size());
        ManagedBeanType managedBean = (ManagedBeanType)facesConfig.getManagedBean().get(0);
        TestJARFileJSFAppConfigProvider.assertEquals((String)"jarBean", (String)managedBean.getManagedBeanName().getTextContent());
        TestJARFileJSFAppConfigProvider.assertEquals((String)"java.util.List", (String)managedBean.getManagedBeanClass().getTextContent());
        TestJARFileJSFAppConfigProvider.assertEquals((String)"request", (String)managedBean.getManagedBeanScope().getTextContent());
    }

    private JARFileJSFAppConfigProvider createProvider(IClasspathEntry forJar) throws Exception {
        String libName = TestJARFileJSFAppConfigProvider.getLibraryName(forJar);
        RuntimeClasspathJSFAppConfigLocater locator = new RuntimeClasspathJSFAppConfigLocater();
        locator.setJSFAppConfigManager(JSFAppConfigManager.getInstance((IProject)this._testEnv.getTestProject()));
        JARFileJSFAppConfigProvider provider = new JARFileJSFAppConfigProvider(libName);
        provider.setJSFAppConfigLocater((IJSFAppConfigLocater)locator);
        return provider;
    }

    private static String getLibraryName(IClasspathEntry classPathEntry) throws Exception {
        IPath libraryPath = classPathEntry.getPath();
        String libraryPathString = libraryPath.toOSString();
        JarFile jarFile = null;
        try {
            JarEntry jarEntry;
            jarFile = new JarFile(libraryPathString);
            if (jarFile != null && (jarEntry = jarFile.getJarEntry("META-INF/faces-config.xml")) != null) {
                String string = libraryPathString;
                return string;
            }
            return null;
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }
}

