/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.jsflibraryconfig;

import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfigDialogSettingData;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfigModel;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfiglModelSource;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryInternalReference;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;
import org.eclipse.jst.jsf.core.internal.project.facet.IJSFFacetInstallDataModelProperties;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;

public class JSFLibraryConfigModelTestCases
extends TestCase {
    private static final String QUALIFIEDNAME = "org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfigProjectData";
    private static final String PROJ_NAME = "_TEST_CFGLIBRARYMODEL_PROJECT";
    private static final String PROJ_NAME2 = "_TEST_CFGLIBRARYMODEL_PROJECT2";
    private JSFLibraryConfiglModelSource modelSrc = null;
    private JSFLibraryConfiglModelSource modelSrcWithServerSupplied = null;
    private IProject project;
    private int numCompLibs;

    protected void setUp() throws Exception {
        super.setUp();
        JSFCoreUtilHelper.createJSFLibraryRegistry();
        JSFLibraryRegistry libReg = JSFCoreUtilHelper.getJSFLibraryRegistryFromJSFLibraryHelper();
        this.numCompLibs = libReg.getNonImplJSFLibraries().size();
        String[] compLibs = new String[1];
        JSFLibrary lib = (JSFLibrary)libReg.getNonImplJSFLibraries().get(0);
        compLibs[0] = String.valueOf(lib.getID()) + ":" + "true";
        this.modelSrc = new JSFLibraryConfigDialogSettingData(true, compLibs);
        this.modelSrcWithServerSupplied = new JSFLibraryConfigDialogSettingData(IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.SERVER_SUPPLIED, true, compLibs);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetJSFImplementationLibraries() {
        JSFLibraryConfigModel model = JSFLibraryConfigModel.JSFLibraryConfigModelFactory.createInstance((JSFLibraryConfiglModelSource)this.modelSrc);
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((model.getJSFImplementationLibraries().size() == 2 ? 1 : 0) != 0);
    }

    public void testGetJSFComponentLibraries() {
        JSFLibraryConfigModel model = JSFLibraryConfigModel.JSFLibraryConfigModelFactory.createInstance((JSFLibraryConfiglModelSource)this.modelSrc);
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((model.getJSFComponentLibraries().size() == this.numCompLibs ? 1 : 0) != 0);
    }

    public void testGetCurrentJSFImplementationLibrarySelection() {
        this.testGetSavedJSFImplementationLibrary();
    }

    public void testGetCurrentJSFComponentLibrarySelection() {
        this.testGetSavedJSFComponentLibraries();
    }

    public void testGetSavedJSFImplementationLibrary() {
        JSFLibraryConfigModel model = JSFLibraryConfigModel.JSFLibraryConfigModelFactory.createInstance((JSFLibraryConfiglModelSource)this.modelSrc);
        JSFLibraryRegistry libReg = JSFCoreUtilHelper.getJSFLibraryRegistryFromJSFLibraryHelper();
        JSFLibraryInternalReference libImplRef = model.getCurrentJSFImplementationLibrarySelection();
        Assert.assertNotNull((Object)libImplRef);
        Assert.assertTrue((boolean)libReg.getDefaultImplementation().getID().equals(libImplRef.getID()));
    }

    public void testGetSavedJSFComponentLibraries() {
        JSFLibraryConfigModel model = JSFLibraryConfigModel.JSFLibraryConfigModelFactory.createInstance((JSFLibraryConfiglModelSource)this.modelSrc);
        JSFCoreUtilHelper.getJSFLibraryRegistryFromJSFLibraryHelper();
        List lstCompRef = model.getCurrentJSFComponentLibrarySelection();
        Assert.assertTrue((lstCompRef.size() == 1 ? 1 : 0) != 0);
        JSFLibraryInternalReference libCompRef = (JSFLibraryInternalReference)lstCompRef.get(0);
        Assert.assertNotNull((Object)libCompRef);
        Assert.assertTrue((boolean)libCompRef.isSelected());
        Assert.assertTrue((boolean)libCompRef.isCheckedToBeDeployed());
    }

    public void testSaveData() {
        try {
            this.project = JSFCoreUtilHelper.createWebProject(PROJ_NAME);
        }
        catch (Exception exception) {
            JSFLibraryConfigModelTestCases.fail((String)"Unable to create project for testing.");
        }
        JSFLibraryConfigModel model = JSFLibraryConfigModel.JSFLibraryConfigModelFactory.createInstance((JSFLibraryConfiglModelSource)this.modelSrc);
        model.saveData(this.project);
        try {
            String content = this.project.getPersistentProperty(new QualifiedName(QUALIFIEDNAME, "jsf.implementation.libraries"));
            Assert.assertNotNull((Object)content);
            Assert.assertTrue((content.length() > 1 ? 1 : 0) != 0);
            String type = this.project.getPersistentProperty(new QualifiedName(QUALIFIEDNAME, "jsf.implementation.type"));
            Assert.assertNotNull((Object)type);
            Assert.assertEquals((String)IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.getStringValue((IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE)IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.CLIENT_SUPPLIED), (String)type);
        }
        catch (CoreException coreException) {
            JSFLibraryConfigModelTestCases.fail((String)"Not expecting an exception.");
        }
    }

    public void testSaveDataWithServerSuppliedImplSelection() {
        try {
            this.project = JSFCoreUtilHelper.createWebProject(PROJ_NAME2);
        }
        catch (Exception exception) {
            JSFLibraryConfigModelTestCases.fail((String)"Unable to create project for testing.");
        }
        JSFLibraryConfigModel model = JSFLibraryConfigModel.JSFLibraryConfigModelFactory.createInstance((JSFLibraryConfiglModelSource)this.modelSrcWithServerSupplied);
        model.saveData(this.project);
        try {
            String content = this.project.getPersistentProperty(new QualifiedName(QUALIFIEDNAME, "jsf.implementation.libraries"));
            Assert.assertNotNull((Object)content);
            Assert.assertTrue((content.length() > 1 ? 1 : 0) != 0);
            String type = this.project.getPersistentProperty(new QualifiedName(QUALIFIEDNAME, "jsf.implementation.type"));
            Assert.assertNotNull((Object)type);
            Assert.assertEquals((String)IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.getStringValue((IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE)IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.SERVER_SUPPLIED), (String)type);
        }
        catch (CoreException coreException) {
            JSFLibraryConfigModelTestCases.fail((String)"Not expecting an exception.");
        }
    }

    public void testGetSavedImplementationType() {
        JSFLibraryConfigModel model = JSFLibraryConfigModel.JSFLibraryConfigModelFactory.createInstance((JSFLibraryConfiglModelSource)this.modelSrc);
        Assert.assertNotNull((Object)model.getImplementationType());
        Assert.assertTrue((model.getImplementationType() == IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.CLIENT_SUPPLIED ? 1 : 0) != 0);
        model = JSFLibraryConfigModel.JSFLibraryConfigModelFactory.createInstance((JSFLibraryConfiglModelSource)this.modelSrcWithServerSupplied);
        Assert.assertNotNull((Object)model.getImplementationType());
        Assert.assertTrue((model.getImplementationType() == IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.SERVER_SUPPLIED ? 1 : 0) != 0);
        model = JSFLibraryConfigModel.JSFLibraryConfigModelFactory.createInstance((JSFLibraryConfiglModelSource)new JSFLibraryConfigDialogSettingData(IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.UNKNOWN, true, null));
        Assert.assertNotNull((Object)model.getImplementationType());
        Assert.assertTrue((model.getImplementationType() == IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.UNKNOWN ? 1 : 0) != 0);
    }
}

