/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.util;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistryFactory;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class JSFCoreUtilHelper {
    public static JSFLibrary constructJSFLib(String id, String name, String[] archivefiles, boolean bImpl) {
        ArchiveFile archiveFile = null;
        String pathTestFiles = String.valueOf(TestsPlugin.getInstallLocation().getPath()) + "testfiles/";
        JSFLibrary jsfLib = JSFLibraryRegistryFactory.eINSTANCE.createJSFLibrary();
        jsfLib.setName(name);
        jsfLib.setImplementation(bImpl);
        int i = 0;
        while (i < archivefiles.length) {
            String testData = String.valueOf(pathTestFiles) + archivefiles[i];
            archiveFile = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
            archiveFile.setRelativeToWorkspace(false);
            archiveFile.setSourceLocation(testData);
            archiveFile.setJSFLibrary(jsfLib);
            ++i;
        }
        return jsfLib;
    }

    public static IProject createWebProject(String aProjectName) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(aProjectName);
        if (!project.exists()) {
            IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
            dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProjectName);
            dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(aProjectName);
    }

    public static void createJSFLibraryRegistry() {
        if (JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getAllJSFLibraries().size() < 2) {
            JSFLibrary lib = JSFCoreUtilHelper.constructJSFLib("AN-IMPL-LIB", "/testfiles/JSFLib/", true, false);
            JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().addJSFLibrary(lib);
            lib = JSFCoreUtilHelper.constructJSFLib("A-NON-IMPL-LIB", "/testfiles/JSFLib/", false, false);
            JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().addJSFLibrary(lib);
            lib = JSFCoreUtilHelper.constructJSFLib("AN-IMPL-LIB-PP", "/testfiles/JSFLib/", true, true);
            JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().addJSFLibrary(lib);
        }
    }

    public static JSFLibraryRegistry getNewJSFLibraryRegistry() {
        return JSFLibraryRegistryFactory.eINSTANCE.createJSFLibraryRegistry();
    }

    public static JSFLibraryRegistry getJSFLibraryRegistryFromJSFLibraryHelper() {
        return JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry();
    }

    public static JSFLibrary constructJSFLib(String name, String relPathToArchives, boolean isImpl, boolean isFakedPlugginLib) {
        Object jsfLib = null;
        jsfLib = isFakedPlugginLib ? JSFLibraryRegistryFactory.eINSTANCE.createPluginProvidedJSFLibrary() : JSFLibraryRegistryFactory.eINSTANCE.createJSFLibrary();
        jsfLib.setName(name);
        jsfLib.setImplementation(isImpl);
        File pathTestFiles = new File(String.valueOf(TestsPlugin.getInstallLocation().getPath()) + File.separator + relPathToArchives);
        FilenameFilter jars = new FilenameFilter(){

            public boolean accept(File dir, String name_) {
                String lastChars;
                return name_.length() >= 5 && ((lastChars = name_.toLowerCase().substring(name_.length() - 4)).equals(".jar") || lastChars.equals(".zip"));
            }
        };
        String[] fileNames = pathTestFiles.list(jars);
        int i = 0;
        while (i < fileNames.length) {
            String fileName = pathTestFiles.getAbsolutePath().concat(File.separator).concat(fileNames[i]);
            ArchiveFile archiveFile = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
            archiveFile.setRelativeToWorkspace(false);
            archiveFile.setSourceLocation(fileName);
            archiveFile.setJSFLibrary((JSFLibrary)jsfLib);
            ++i;
        }
        return jsfLib;
    }
}

