/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.util;

import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.jsf.common.util.JDTBeanIntrospector;
import org.eclipse.jst.jsf.common.util.JDTBeanProperty;
import org.eclipse.jst.jsf.common.util.TypeUtil;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;

public class TestTypeUtil
extends TestCase {
    private JDTTestEnvironment _jdtTestEnvironment;
    private IType _testBean1Type;
    private IType _testBeanSubclassType;
    private IType _testBeanGenericType;
    private Map<String, JDTBeanProperty> _properties;
    private Map<String, JDTBeanProperty> _subClassProperties;
    private Map<String, JDTBeanProperty> _genericTypeProperties;
    private static final String srcFolderName = "src";
    private static final String packageName1 = "com.test";
    private static final String testBeanName1 = "TestBean1";
    private static final String testBeanSubclassName1 = "TestBean1Subclass";
    private static final String testAnotherBeanName = "AnotherBean";
    private static final String testBeanGenericName = "TestBeanGeneric";

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        WebProjectTestEnvironment projectTestEnvironment = new WebProjectTestEnvironment("TestJDTBeanIntrospectorProject");
        projectTestEnvironment.createProject(true);
        this._jdtTestEnvironment = new JDTTestEnvironment((ProjectTestEnvironment)projectTestEnvironment);
        TestFileResource codeRes = new TestFileResource();
        codeRes.load(TestsPlugin.getDefault().getBundle(), "/testfiles/TestBean1.java.data");
        String code = codeRes.toString();
        this._jdtTestEnvironment.addSourceFile(srcFolderName, packageName1, testBeanName1, code);
        this._testBean1Type = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestBean1");
        TestTypeUtil.assertNotNull((Object)this._testBean1Type);
        codeRes = new TestFileResource();
        codeRes.load(TestsPlugin.getDefault().getBundle(), "/testfiles/TestBean1Subclass.java.data");
        code = codeRes.toString();
        this._jdtTestEnvironment.addSourceFile(srcFolderName, packageName1, testBeanSubclassName1, code);
        this._testBeanSubclassType = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestBean1Subclass");
        TestTypeUtil.assertNotNull((Object)this._testBeanSubclassType);
        TestTypeUtil.assertNotSame((Object)this._testBean1Type, (Object)this._testBeanSubclassType);
        codeRes = new TestFileResource();
        codeRes.load(TestsPlugin.getDefault().getBundle(), "/testfiles/AnotherBean.java.data");
        code = codeRes.toString();
        this._jdtTestEnvironment.addSourceFile(srcFolderName, packageName1, testAnotherBeanName, code);
        TestTypeUtil.assertNotNull((Object)this._jdtTestEnvironment.getJavaProject().findType("com.test.AnotherBean"));
        codeRes = new TestFileResource();
        codeRes.load(TestsPlugin.getDefault().getBundle(), "/testfiles/TestBeanGeneric.java.data");
        code = codeRes.toString();
        this._jdtTestEnvironment.addSourceFile(srcFolderName, packageName1, testBeanGenericName, code);
        this._testBeanGenericType = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestBeanGeneric");
        TestTypeUtil.assertNotNull((Object)this._testBeanGenericType);
        JDTBeanIntrospector beanIntrospector = new JDTBeanIntrospector(this._testBean1Type);
        this._properties = beanIntrospector.getProperties();
        beanIntrospector = new JDTBeanIntrospector(this._testBeanSubclassType);
        this._subClassProperties = beanIntrospector.getProperties();
        beanIntrospector = new JDTBeanIntrospector(this._testBeanGenericType);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testResolveTypeSignatureITypeString() {
        TestTypeUtil.assertEquals((String)"Ljava.lang.String;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QString;", (boolean)true));
        TestTypeUtil.assertEquals((String)"Ljava.lang.String;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QString;", (boolean)false));
        TestTypeUtil.assertEquals((String)"Ljava.util.Collection;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QCollection;", (boolean)true));
        TestTypeUtil.assertEquals((String)"Ljava.util.Collection;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QCollection;", (boolean)false));
        TestTypeUtil.assertEquals((String)"Ljava.util.Map;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap;", (boolean)true));
        TestTypeUtil.assertEquals((String)"Ljava.util.Map;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap;", (boolean)false));
        TestTypeUtil.assertEquals((String)"Ljava.util.Map;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap<QString;QString;>;", (boolean)true));
        TestTypeUtil.assertEquals((String)"Ljava.util.Map<Ljava.lang.String;Ljava.lang.String;>;", (String)TypeUtil.resolveTypeSignature((IType)this._testBean1Type, (String)"QMap<QString;QString;>;", (boolean)false));
    }
}

