/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.core.tests;

import junit.framework.TestCase;
import org.eclipse.wst.common.snippets.core.ISnippetCategory;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.core.ISnippetVariable;
import org.eclipse.wst.common.snippets.internal.SnippetDefinitions;
import org.eclipse.wst.common.snippets.internal.model.SnippetManager;
import org.eclipse.wst.common.snippets.internal.palette.SnippetVariable;

public class SnippetCoreTests
extends TestCase {
    private SnippetDefinitions fCurrentDefinitions;

    public SnippetCoreTests() {
    }

    public SnippetCoreTests(String name) {
        super(name);
    }

    private ISnippetVariable getVariable(ISnippetItem item, String id) {
        int i = 0;
        while (i < item.getVariables().length) {
            if (((SnippetVariable)item.getVariables()[i]).getId().equals(id)) {
                return item.getVariables()[i];
            }
            ++i;
        }
        return null;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fCurrentDefinitions = SnippetManager.getInstance().getDefinitions();
    }

    public void testCategoryLoadedFromPlugin() {
        ISnippetCategory testCategory = this.fCurrentDefinitions.getCategory("org.eclipse.wst.common.snippets.tests.category0");
        SnippetCoreTests.assertNotNull((String)"test category not found", (Object)testCategory);
        SnippetCoreTests.assertEquals((String)"test category source type incorrect", (Object)"PLUGINS", (Object)testCategory.getSourceType());
        SnippetCoreTests.assertNotNull((String)"test category source description missing", (Object)testCategory.getSourceDescriptor());
        SnippetCoreTests.assertEquals((String)"test category description incorrect", null, (String)testCategory.getDescription());
        SnippetCoreTests.assertEquals((String)"test category label incorrect", (String)"org.eclipse.wst.common.snippets.tests-category", (String)testCategory.getLabel());
        SnippetCoreTests.assertNotNull((String)"test category has no content-type visibility filters", (Object)testCategory.getFilters());
        SnippetCoreTests.assertTrue((String)"test category has no visibility filters", (testCategory.getFilters().length > 0 ? 1 : 0) != 0);
        SnippetCoreTests.assertEquals((String)"test category has wrong content-type visibility filter", (String)"*", (String)testCategory.getFilters()[0]);
    }

    public void testItem0LoadedFromPlugin() {
        ISnippetCategory testCategory = this.fCurrentDefinitions.getCategory("org.eclipse.wst.common.snippets.tests.category0");
        SnippetCoreTests.assertNotNull((String)"test category not found", (Object)testCategory);
        ISnippetItem item = this.fCurrentDefinitions.getItem("org.eclipse.wst.common.snippets.tests.item0");
        SnippetCoreTests.assertNotNull((String)"test item 0 not found", (Object)item);
        SnippetCoreTests.assertEquals((String)"parent category mismatched", (Object)testCategory, (Object)item.getCategory());
        SnippetCoreTests.assertEquals((String)"item content incorrect", (String)"sample content 0", (String)item.getContentString());
        SnippetCoreTests.assertEquals((String)"item description incorrect", (String)"", (String)item.getDescription());
        SnippetCoreTests.assertEquals((String)"item label incorrect", (String)"test item 0", (String)item.getLabel());
        SnippetCoreTests.assertEquals((String)"item source type incorrect", (Object)"PLUGINS", (Object)item.getSourceType());
        SnippetCoreTests.assertNotNull((String)"item source description missing", (Object)item.getSourceDescriptor());
        SnippetCoreTests.assertEquals((String)"item has extra variables", (int)0, (int)item.getVariables().length);
        SnippetCoreTests.assertTrue((String)"item has visibility filters", (item.getFilters().length == 0 ? 1 : 0) != 0);
    }

    public void testItem1LoadedFromPlugin() {
        ISnippetCategory testCategory = this.fCurrentDefinitions.getCategory("org.eclipse.wst.common.snippets.tests.category0");
        SnippetCoreTests.assertNotNull((String)"test category not found", (Object)testCategory);
        ISnippetItem item = this.fCurrentDefinitions.getItem("org.eclipse.wst.common.snippets.tests.item1");
        SnippetCoreTests.assertNotNull((String)"test item 1 not found", (Object)item);
        SnippetCoreTests.assertEquals((String)"parent category mismatched", (Object)testCategory, (Object)item.getCategory());
        SnippetCoreTests.assertEquals((String)"item content incorrect", (String)"test content ${variableA} and more ${variableB}", (String)item.getContentString());
        SnippetCoreTests.assertEquals((String)"item description incorrect", (String)"", (String)item.getDescription());
        SnippetCoreTests.assertEquals((String)"item label incorrect", (String)"test item 1", (String)item.getLabel());
        SnippetCoreTests.assertEquals((String)"item source type incorrect", (Object)"PLUGINS", (Object)item.getSourceType());
        SnippetCoreTests.assertNotNull((String)"item source description missing", (Object)item.getSourceDescriptor());
        SnippetCoreTests.assertTrue((String)"item has visibility filters", (item.getFilters().length == 0 ? 1 : 0) != 0);
        SnippetCoreTests.assertEquals((String)"item has the wrong number of variables", (int)2, (int)item.getVariables().length);
        ISnippetVariable variable = this.getVariable(item, "variableA");
        SnippetCoreTests.assertNotNull((String)"variable A missing", (Object)variable);
        SnippetCoreTests.assertEquals((String)"variable has the wrong default value", (String)"", (String)variable.getDefaultValue());
        SnippetCoreTests.assertEquals((String)"variable has the wrong description", (String)"variable A", (String)variable.getDescription());
        SnippetCoreTests.assertEquals((String)"variable has the wrong name", (String)"variableA", (String)variable.getName());
        variable = this.getVariable(item, "variableB");
        SnippetCoreTests.assertNotNull((String)"variable B missing", (Object)variable);
        SnippetCoreTests.assertEquals((String)"variable has the wrong default value", (String)"bfoo", (String)variable.getDefaultValue());
        SnippetCoreTests.assertEquals((String)"variable has the wrong description", (String)"variable B", (String)variable.getDescription());
        SnippetCoreTests.assertEquals((String)"variable has the wrong name", (String)"variableB", (String)variable.getName());
    }
}

