/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy.initParser;

import javax.swing.JLabel;
import org.eclipse.jem.tests.proxy.initParser.AbstractInitParserTestCase;
import org.eclipse.jem.tests.proxy.initParser.NavigationParameters;

public class CastTest
extends AbstractInitParserTestCase {
    public CastTest(String name) {
        super(name);
    }

    public void testIntToFloat() throws Throwable {
        this.testHelper.testInitString("new Float((float)10)", new Float(10.0f));
    }

    public void testIntToFloatSpace() throws Throwable {
        this.testHelper.testInitString("new Float( (float) 10 )", new Float(10.0f));
    }

    public void testFloatToFloat() throws Throwable {
        this.testHelper.testInitString("new Float((float)10.3)", new Float(10.3f));
    }

    public void testFloatToFloat2() throws Throwable {
        this.testHelper.testInitString("new Float((float)5.3)", new Float(5.3f));
    }

    public void testFloatToFloatSpace() throws Throwable {
        this.testHelper.testInitString("new Float( (float) 10.3 )", new Float(10.3f));
    }

    public void testNullToString() throws Throwable {
        this.testHelper.testInitString("(String)null", null);
    }

    public void testStringLiteralToString() throws Throwable {
        this.testHelper.testInitString("(String)\"hi\"", "hi");
    }

    public void testNullToStringParam() throws Throwable {
        this.testHelper.testInitString("new javax.swing.JLabel( (String) null)", new JLabel(null));
    }

    public void testIntToShort() throws Throwable {
        this.testHelper.testInitString("(short)10", new Short(10));
    }

    public void testFloatToFloatPrim() throws Throwable {
        this.testHelper.testInitString("(float)10.3", new Float(10.3f));
    }

    public void testQualifiedStringReturn() throws Throwable {
        this.testHelper.testInitString("(java.lang.String)org.eclipse.jem.tests.proxy.initParser.NavigationParameters.getReversed(\"Frog\")", NavigationParameters.getReversed("Frog"));
    }

    public void testStringReturn() throws Throwable {
        this.testHelper.testInitString("(String)org.eclipse.jem.tests.proxy.initParser.NavigationParameters.getReversed(\"Frog\")", NavigationParameters.getReversed("Frog"));
    }

    public void testQualifiedColorReturn() throws Throwable {
        this.testHelper.testInitString("(java.awt.Color)org.eclipse.jem.tests.proxy.initParser.NavigationParameters.getColor(\"red\")", NavigationParameters.getColor("red"));
    }

    public void testCastUpColor() throws Throwable {
        this.testHelper.testInitString("(java.awt.SystemColor)org.eclipse.jem.tests.proxy.initParser.NavigationParameters.getColor(\"window\")", NavigationParameters.getColor("window"));
    }
}

