/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.tests.performance.internal.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.eclipse.swt.widgets.Display;

final class DisplayWaiter {
    private final Display fDisplay;
    private final Object fMutex = new Object();
    private final boolean fKeepRunningOnTimeout;
    private static final int RUNNING = 2;
    private static final int STOPPED = 4;
    private static final int IDLE = 8;
    private int fState;
    private long fNextTimeout;
    private Thread fCurrentThread;
    private Timeout fCurrentTimeoutState;

    public DisplayWaiter(Display display) {
        this(display, false);
    }

    public DisplayWaiter(Display display, boolean keepRunning) {
        Assert.assertNotNull((Object)display);
        this.fDisplay = display;
        this.fState = 4;
        this.fKeepRunningOnTimeout = keepRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timeout start(long delay) {
        Assert.assertTrue((delay > 0L ? 1 : 0) != 0);
        Object object = this.fMutex;
        synchronized (object) {
            switch (this.fState) {
                case 4: {
                    this.startThread();
                    this.setNextTimeout(delay);
                    break;
                }
                case 8: {
                    this.unhold();
                    this.setNextTimeout(delay);
                }
            }
            return this.fCurrentTimeoutState;
        }
    }

    private void setNextTimeout(long delay) {
        long currentTimeMillis = System.currentTimeMillis();
        long next = currentTimeMillis + delay;
        this.fNextTimeout = next > currentTimeMillis ? next : Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timeout restart(long delay) {
        Assert.assertTrue((delay > 0L ? 1 : 0) != 0);
        Object object = this.fMutex;
        synchronized (object) {
            switch (this.fState) {
                case 4: {
                    this.startThread();
                    break;
                }
                case 8: {
                    this.unhold();
                }
            }
            this.setNextTimeout(delay);
            return this.fCurrentTimeoutState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.fMutex;
        synchronized (object) {
            if (this.tryTransition(10, 4)) {
                this.fMutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hold() {
        Object object = this.fMutex;
        synchronized (object) {
            if (this.tryTransition(2, 8)) {
                this.fMutex.notifyAll();
            }
        }
    }

    private void unhold() {
        this.checkedTransition(8, 2);
        this.fCurrentTimeoutState = new Timeout(false);
        this.fMutex.notifyAll();
    }

    private void startThread() {
        this.checkedTransition(4, 2);
        this.fCurrentTimeoutState = new Timeout(false);
        this.fCurrentThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    this.run2();
                }
                catch (InterruptedException e) {
                    Logger.global.log(Level.FINE, "", e);
                }
                catch (ThreadChangedException e) {
                    Logger.global.log(Level.FINE, "", e);
                    Object object = DisplayWaiter.this.fMutex;
                    synchronized (object) {
                        DisplayWaiter.this.fMutex.notifyAll();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void run2() throws InterruptedException, ThreadChangedException {
                Object object = DisplayWaiter.this.fMutex;
                synchronized (object) {
                    this.checkThread();
                    this.tryHold();
                    DisplayWaiter.this.assertStates(6);
                    while (DisplayWaiter.this.isState(2)) {
                        this.waitForTimeout();
                        if (DisplayWaiter.this.isState(2)) {
                            this.timedOut();
                        }
                        DisplayWaiter.this.assertStates(12);
                        this.tryHold();
                        DisplayWaiter.this.assertStates(6);
                    }
                    DisplayWaiter.this.assertStates(4);
                }
            }

            private void checkThread() throws ThreadChangedException {
                if (DisplayWaiter.this.fCurrentThread != this) {
                    throw new ThreadChangedException();
                }
            }

            private void waitForTimeout() throws InterruptedException, ThreadChangedException {
                long delta;
                while (DisplayWaiter.this.isState(2) && (delta = DisplayWaiter.this.fNextTimeout - System.currentTimeMillis()) > 0L) {
                    delta = Math.max(delta, 50L);
                    Logger.global.finest("sleeping for " + delta + "ms");
                    DisplayWaiter.this.fMutex.wait(delta);
                    this.checkThread();
                }
            }

            private void timedOut() {
                Logger.global.finer("timed out");
                DisplayWaiter.this.fCurrentTimeoutState.setTimedOut(true);
                DisplayWaiter.this.fDisplay.wake();
                if (DisplayWaiter.this.fKeepRunningOnTimeout) {
                    DisplayWaiter.this.checkedTransition(2, 8);
                } else {
                    DisplayWaiter.this.checkedTransition(2, 4);
                }
            }

            private void tryHold() throws InterruptedException, ThreadChangedException {
                while (DisplayWaiter.this.isState(8)) {
                    DisplayWaiter.this.fMutex.wait(0L);
                    this.checkThread();
                }
                DisplayWaiter.this.assertStates(6);
            }

            final class ThreadChangedException
            extends Exception {
                private static final long serialVersionUID = 1L;

                ThreadChangedException() {
                }
            }
        };
        this.fCurrentThread.start();
    }

    private boolean tryTransition(int possibleStates, int nextState) {
        if (this.isState(possibleStates)) {
            Logger.global.finer(String.valueOf(this.name(this.fState)) + " > " + this.name(nextState) + " (" + this.name(possibleStates) + ")");
            this.fState = nextState;
            return true;
        }
        Logger.global.finest("noTransition" + this.name(this.fState) + " !> " + this.name(nextState) + " (" + this.name(possibleStates) + ")");
        return false;
    }

    private void checkedTransition(int possibleStates, int nextState) {
        this.assertStates(possibleStates);
        Logger.global.finer(String.valueOf(this.name(this.fState)) + " > " + this.name(nextState));
        this.fState = nextState;
    }

    private void assertStates(int states) {
        Assert.assertTrue((String)"illegal state", (boolean)this.isState(states));
    }

    private boolean isState(int states) {
        return (states & this.fState) == this.fState;
    }

    private String name(int states) {
        StringBuffer buf = new StringBuffer();
        boolean comma = false;
        if ((states & 2) == 2) {
            buf.append("RUNNING");
            comma = true;
        }
        if ((states & 4) == 4) {
            if (comma) {
                buf.append(",");
            }
            buf.append("STOPPED");
            comma = true;
        }
        if ((states & 8) == 8) {
            if (comma) {
                buf.append(",");
            }
            buf.append("IDLE");
        }
        return buf.toString();
    }

    public final class Timeout {
        boolean fTimeoutState = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasTimedOut() {
            Object object = DisplayWaiter.this.fMutex;
            synchronized (object) {
                return this.fTimeoutState;
            }
        }

        void setTimedOut(boolean timedOut) {
            this.fTimeoutState = timedOut;
        }

        Timeout(boolean initialState) {
            this.fTimeoutState = initialState;
        }
    }
}

