/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.tests;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatConfigurationWorkingCopy;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour;
import org.eclipse.jst.server.tomcat.core.tests.RuntimeLocation;
import org.eclipse.jst.server.tomcat.core.tests.module.ModuleTestCase;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.tests.ext.AbstractServerTestCase;

public abstract class AbstractTomcatServerTestCase
extends AbstractServerTestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected abstract String getServerTypeId();

    public void deleteServer(IServer server2) throws Exception {
        server2.getRuntime().delete();
        server2.delete();
    }

    protected IRuntime createRuntime() throws Exception {
        IServerType st = ServerCore.findServerType((String)this.getServerTypeId());
        IRuntimeWorkingCopy wc = st.getRuntimeType().createRuntime(null, null);
        wc.setLocation((IPath)new Path(RuntimeLocation.runtimeLocation));
        return wc.save(true, null);
    }

    public IServer createServer() throws Exception {
        List portsList;
        IServerType st = ServerCore.findServerType((String)this.getServerTypeId());
        IRuntime runtime = this.createRuntime();
        IServerWorkingCopy wc = st.createServer(null, null, runtime, null);
        ServerPort[] ports = wc.getServerPorts(null);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TomcatServer tomcatServer = (TomcatServer)wc.getAdapter((Class)clazz);
        ITomcatConfigurationWorkingCopy configuration = (ITomcatConfigurationWorkingCopy)tomcatServer.getServerConfiguration();
        if ((ports == null || ports.length == 0) && (portsList = configuration.getServerPorts()) != null && portsList.size() > 0) {
            ports = portsList.toArray(new ServerPort[portsList.size()]);
        }
        if (ports != null) {
            int size = ports.length;
            int i = 0;
            while (i < size) {
                configuration.modifyServerPort(ports[i].getId(), 22100 + i);
                ++i;
            }
        }
        return wc.save(true, null);
    }

    public TomcatServer getTomcatServer() throws Exception {
        IServer iServer = this.getServer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TomcatServer)iServer.loadAdapter((Class)clazz, null);
    }

    public TomcatServerBehaviour getTomcatServerBehaviour() throws Exception {
        IServer iServer = this.getServer();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TomcatServerBehaviour)iServer.loadAdapter((Class)clazz, null);
    }

    public void test0100CanAddModule() {
        IModule webModule = ModuleTestCase.webModule;
        IStatus status = server.canModifyModules(new IModule[]{webModule}, null, null);
        AbstractTomcatServerTestCase.assertTrue((boolean)status.isOK());
    }

    public void test0101HasModule() {
        IModule webModule = ModuleTestCase.webModule;
        IModule[] modules = server.getModules();
        int size = modules.length;
        boolean found = false;
        int i = 0;
        while (i < size) {
            if (webModule.equals(modules[i])) {
                found = true;
            }
            ++i;
        }
        if (found) {
            AbstractTomcatServerTestCase.assertTrue((boolean)false);
        }
    }

    public void test0102AddModule() throws Exception {
        IModule webModule = ModuleTestCase.webModule;
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.modifyModules(new IModule[]{webModule}, null, null);
        wc.save(true, null);
    }

    public void test0103HasModule() {
        IModule webModule = ModuleTestCase.webModule;
        IModule[] modules = server.getModules();
        int size = modules.length;
        boolean found = false;
        int i = 0;
        while (i < size) {
            if (webModule.equals(modules[i])) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            AbstractTomcatServerTestCase.assertTrue((boolean)false);
        }
    }

    public void test0104RemoveModule() throws Exception {
        IModule webModule = ModuleTestCase.webModule;
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.modifyModules(null, new IModule[]{webModule}, null);
        wc.save(true, null);
    }

    public void test0105HasModule() {
        IModule webModule = ModuleTestCase.webModule;
        IModule[] modules = server.getModules();
        int size = modules.length;
        boolean found = false;
        int i = 0;
        while (i < size) {
            if (webModule.equals(modules[i])) {
                found = true;
            }
            ++i;
        }
        if (found) {
            AbstractTomcatServerTestCase.assertTrue((boolean)false);
        }
    }

    public void test200VerifyDefaultDeployConfig() throws Exception {
        TomcatServer ts = this.getTomcatServer();
        AbstractTomcatServerTestCase.assertNotNull((Object)ts);
        TomcatServerBehaviour tsb = this.getTomcatServerBehaviour();
        AbstractTomcatServerTestCase.assertNotNull((Object)tsb);
        AbstractTomcatServerTestCase.assertEquals((String)"wtpwebapps", (String)ts.getDeployDirectory());
        IPath tempDir = tsb.getTempDirectory();
        IPath baseDir = tsb.getRuntimeBaseDirectory();
        AbstractTomcatServerTestCase.assertEquals((Object)tempDir, (Object)baseDir);
        IPath deployDir = tsb.getServerDeployDirectory();
        AbstractTomcatServerTestCase.assertEquals((Object)baseDir.append("wtpwebapps"), (Object)deployDir);
    }

    protected abstract void verifyPublishedModule(IPath var1, IModule var2) throws Exception;

    public void test201VerifyDefaultAddPublish() throws Exception {
        IModule webModule = ModuleTestCase.webModule;
        IServerWorkingCopy wc = this.getServer().createWorkingCopy();
        wc.modifyModules(new IModule[]{webModule}, null, null);
        wc.save(true, null);
        this.getServer().publish(2, null);
        TomcatServerBehaviour tsb = this.getTomcatServerBehaviour();
        IPath baseDir = tsb.getRuntimeBaseDirectory();
        IPath moduleDir = baseDir.append("wtpwebapps").append(ModuleTestCase.webModule.getName());
        AbstractTomcatServerTestCase.assertTrue((boolean)moduleDir.toFile().exists());
        this.verifyPublishedModule(baseDir, ModuleTestCase.webModule);
    }

    public void test202VerifyDefaultRemovePublish() throws Exception {
        IModule webModule = ModuleTestCase.webModule;
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.modifyModules(null, new IModule[]{webModule}, null);
        wc.save(true, null);
        this.getServer().publish(2, null);
        TomcatServerBehaviour tsb = this.getTomcatServerBehaviour();
        IPath baseDir = tsb.getRuntimeBaseDirectory();
        IPath moduleDir = baseDir.append("wtpwebapps").append(ModuleTestCase.webModule.getName());
        AbstractTomcatServerTestCase.assertFalse((boolean)moduleDir.toFile().exists());
    }

    public void test203VerifyLegacyDeployConfig() throws Exception {
        TomcatServer ts = this.getTomcatServer();
        AbstractTomcatServerTestCase.assertNotNull((Object)ts);
        ts.setDeployDirectory("webapps");
        TomcatServerBehaviour tsb = this.getTomcatServerBehaviour();
        AbstractTomcatServerTestCase.assertNotNull((Object)tsb);
        AbstractTomcatServerTestCase.assertEquals((String)"webapps", (String)ts.getDeployDirectory());
        IServer iServer = this.getServer();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.server.core.internal.Server");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Server svr = (Server)iServer.loadAdapter((Class)clazz, null);
        AbstractTomcatServerTestCase.assertNotNull((Object)svr);
        String attr = svr.getAttribute("webapps", null);
        AbstractTomcatServerTestCase.assertNull((Object)attr);
        IPath tempDir = tsb.getTempDirectory();
        IPath baseDir = tsb.getRuntimeBaseDirectory();
        AbstractTomcatServerTestCase.assertEquals((Object)tempDir, (Object)baseDir);
        IPath deployDir = tsb.getServerDeployDirectory();
        AbstractTomcatServerTestCase.assertEquals((Object)baseDir.append("webapps"), (Object)deployDir);
    }

    public void test204VerifyLegacyAddPublish() throws Exception {
        IModule webModule = ModuleTestCase.webModule;
        IServerWorkingCopy wc = this.getServer().createWorkingCopy();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ((TomcatServer)wc.loadAdapter((Class)clazz, null)).setDeployDirectory(null);
        wc.modifyModules(new IModule[]{webModule}, null, null);
        wc.save(true, null);
        this.getServer().publish(2, null);
        TomcatServerBehaviour tsb = this.getTomcatServerBehaviour();
        IPath baseDir = tsb.getRuntimeBaseDirectory();
        IPath moduleDir = baseDir.append("webapps").append(ModuleTestCase.webModule.getName());
        AbstractTomcatServerTestCase.assertTrue((boolean)moduleDir.toFile().exists());
        this.verifyPublishedModule(baseDir, ModuleTestCase.webModule);
    }

    public void test205VerifyLegacyRemovePublish() throws Exception {
        IModule webModule = ModuleTestCase.webModule;
        IServerWorkingCopy wc = server.createWorkingCopy();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ((TomcatServer)wc.loadAdapter((Class)clazz, null)).setDeployDirectory(null);
        wc.modifyModules(null, new IModule[]{webModule}, null);
        wc.save(true, null);
        this.getServer().publish(2, null);
        TomcatServerBehaviour tsb = this.getTomcatServerBehaviour();
        IPath baseDir = tsb.getRuntimeBaseDirectory();
        IPath moduleDir = baseDir.append("webapps").append(ModuleTestCase.webModule.getName());
        AbstractTomcatServerTestCase.assertFalse((boolean)moduleDir.toFile().exists());
    }
}

