/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.provisional.preferences.CommonEditorPreferenceNames;
import org.eclipse.wst.sse.ui.internal.reconcile.DocumentRegionProcessor;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorMetaData;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorStrategy;
import org.eclipse.wst.xml.ui.tests.Logger;

public class TestSourceValidationFramework
extends TestCase {
    private static final String PROJECT_NAME = "TestSourceValidationFramework";
    private static final String SEPARATOR = String.valueOf('/');
    private boolean fPreviousReconcilerPref;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public TestSourceValidationFramework() {
        super(PROJECT_NAME);
    }

    private IFile ensureFileIsAccessible(String filePath, byte[] contents) {
        IFile blankFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        if (blankFile != null && !blankFile.isAccessible()) {
            try {
                byte[] bytes = contents;
                if (bytes == null) {
                    bytes = new byte[]{};
                }
                blankFile.create((InputStream)new ByteArrayInputStream(bytes), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return blankFile;
    }

    private IContentType[] detectContentTypes(String fileName) {
        IContentType[] types = null;
        IFile file = this.ensureFileIsAccessible(PROJECT_NAME + SEPARATOR + fileName, null);
        types = Platform.getContentTypeManager().findContentTypesFor(file.getName());
        if (types.length == 0) {
            IContentDescription d = null;
            try {
                d = file.getContentDescription();
                if (d != null) {
                    types = new IContentType[]{d.getContentType()};
                }
            }
            catch (CoreException coreException) {}
        }
        if (types == null) {
            types = Platform.getContentTypeManager().findContentTypesFor(file.getName());
        }
        return types;
    }

    private String[] detectContentTypeIDs(String fileName) {
        IContentType[] types = this.detectContentTypes(fileName);
        String[] ids = new String[types.length];
        int i = 0;
        while (i < types.length) {
            ids[i] = types[i].getId();
            ++i;
        }
        return ids;
    }

    private boolean identicalContents(Object[] o1, Object[] o2) {
        if (o1.length == 0 && o2.length == 0) {
            return true;
        }
        Object[] array1 = new Object[o1.length];
        Object[] array2 = new Object[o2.length];
        System.arraycopy(o1, 0, array1, 0, o1.length);
        System.arraycopy(o2, 0, array2, 0, o2.length);
        Arrays.sort(array1);
        Arrays.sort(array2);
        return Arrays.equals(array1, array2);
    }

    private void ensureProjectIsAccessible(String projName) {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        try {
            if (!project.exists()) {
                project.create(description, (IProgressMonitor)new NullProgressMonitor());
            }
            if (!project.isAccessible()) {
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getSourceValidatorIDs(String fileName) throws Exception {
        ArrayList<String> validatorIds = new ArrayList<String>(1);
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IFile file = this.ensureFileIsAccessible(PROJECT_NAME + SEPARATOR + fileName, null);
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.wst.xml.ui.tests.TestSourceValidationFramework$TestStructuredTextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)clazz.getName(), (boolean)true);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz3 = class$1 = clazz4;
        }
        ITextEditor textEditor = (ITextEditor)editor.getAdapter((Class)clazz3);
        TestStructuredTextEditor testTextEditor = (TestStructuredTextEditor)textEditor;
        IReconciler reconciler = testTextEditor.textViewerConfiguration.getReconciler((ISourceViewer)testTextEditor.getTextViewer());
        TestSourceValidationFramework.assertNotNull((Object)reconciler);
        TestSourceValidationFramework.assertTrue((String)("unexpected IReconciler implementation: " + reconciler.getClass()), (boolean)(reconciler instanceof DocumentRegionProcessor));
        Class<?> reconcilerClass = reconciler.getClass();
        Method method = null;
        block6: while (true) {
            Class<?> clazz5;
            if ((clazz5 = class$2) == null) {
                try {
                    clazz5 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (reconcilerClass == clazz5 || method != null) break;
            Method[] methods = reconcilerClass.getDeclaredMethods();
            int i = 0;
            while (true) {
                if (i >= methods.length) {
                    reconcilerClass = reconcilerClass.getSuperclass();
                    continue block6;
                }
                if (methods[i].getName().equals("getValidatorStrategy")) {
                    method = methods[i];
                }
                ++i;
            }
            break;
        }
        TestSourceValidationFramework.assertNotNull((String)("no getValidatorStrategy method found on " + reconciler.getClass()), method);
        method.setAccessible(true);
        ValidatorStrategy strategy = (ValidatorStrategy)method.invoke((Object)reconciler, new Object[0]);
        TestSourceValidationFramework.assertNotNull((Object)strategy);
        Field fMetaData = strategy.getClass().getDeclaredField("fMetaData");
        TestSourceValidationFramework.assertNotNull((String)("validator metadata field \"fMetaData\" not found on strategy " + strategy.getClass()), (Object)fMetaData);
        fMetaData.setAccessible(true);
        List metadata = (List)fMetaData.get(strategy);
        TestSourceValidationFramework.assertNotNull((Object)metadata);
        int i = 0;
        while (true) {
            if (i >= metadata.size()) {
                page.closeEditor(editor, false);
                return validatorIds;
            }
            validatorIds.add(((ValidatorMetaData)metadata.get(i)).getValidatorId());
            ++i;
        }
    }

    protected void setUp() throws Exception {
        this.ensureProjectIsAccessible(PROJECT_NAME);
        IPreferenceStore store = SSEUIPlugin.getDefault().getPreferenceStore();
        this.fPreviousReconcilerPref = store.getBoolean(CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS);
        if (!this.fPreviousReconcilerPref) {
            store.setValue(CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS, true);
        }
    }

    protected void tearDown() throws Exception {
        IPreferenceStore store = SSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue(CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS, this.fPreviousReconcilerPref);
    }

    public void testSourceValidationEnablementWithInheritedValidators() throws Exception {
        Object[] xmlValidatorIDs = this.getSourceValidatorIDs("testValidatorConfigurations.xml").toArray();
        TestSourceValidationFramework.assertTrue((String)"No XML source validators found", (xmlValidatorIDs.length > 0 ? 1 : 0) != 0);
        Object[] xml99ValidatorIDs = this.getSourceValidatorIDs("testValidatorConfigurations.xml99").toArray();
        TestSourceValidationFramework.assertTrue((String)"No XML99 source validators found", (xml99ValidatorIDs.length > 0 ? 1 : 0) != 0);
        Arrays.sort(xmlValidatorIDs);
        Arrays.sort(xml99ValidatorIDs);
        TestSourceValidationFramework.assertEquals((String)"validator lists should be the same length", (int)xmlValidatorIDs.length, (int)xml99ValidatorIDs.length);
        int i = 0;
        while (i < xmlValidatorIDs.length) {
            TestSourceValidationFramework.assertEquals((String)("validator IDs should be the same [" + i + "]"), (Object)xmlValidatorIDs[i], (Object)xml99ValidatorIDs[i]);
            ++i;
        }
    }

    public void testSourceValidationEnablementWithUniqueValidators() throws Exception {
        Object[] xsdContentTypes;
        Object[] xmlContentTypes = this.detectContentTypeIDs("testValidatorConfigurations.xml");
        if (!this.identicalContents(xmlContentTypes, xsdContentTypes = this.detectContentTypeIDs("testValidatorConfigurations.xsd"))) {
            List xmlValidatorIDs = this.getSourceValidatorIDs("testValidatorConfigurations.xml");
            TestSourceValidationFramework.assertTrue((String)"No XML source validators found", (!xmlValidatorIDs.isEmpty() ? 1 : 0) != 0);
            List xsdValidatorIDs = this.getSourceValidatorIDs("testValidatorConfigurations.xsd");
            TestSourceValidationFramework.assertTrue((String)"No XSD source validators found", (!xsdValidatorIDs.isEmpty() ? 1 : 0) != 0);
            int i = 0;
            while (i < xmlValidatorIDs.size()) {
                TestSourceValidationFramework.assertTrue((String)"XML Validator found on XSD input", (!xsdValidatorIDs.contains(xmlValidatorIDs.get(i)) ? 1 : 0) != 0);
                ++i;
            }
        } else {
            String message = "No distinct XSD content type found while running " + ((Object)((Object)this)).getClass().getName();
            System.err.println(message);
            Logger.log(2, message);
        }
    }

    public void testSourceValidationEnablementWithUnrelatedContentTypes() throws Exception {
        String message;
        Object[] dtdContentTypes = this.detectContentTypeIDs("testValidatorConfigurations.dtd");
        Object[] jspContentTypes = this.detectContentTypeIDs("testValidatorConfigurations.jsp");
        if (dtdContentTypes.length == 0) {
            message = "No DTD content type found while running " + ((Object)((Object)this)).getClass().getName();
            System.err.println(message);
            Logger.log(2, message);
        }
        if (jspContentTypes.length == 0) {
            message = "No JSP content type found while running " + ((Object)((Object)this)).getClass().getName();
            System.err.println(message);
            Logger.log(2, message);
        }
        if (dtdContentTypes.length > 0 && jspContentTypes.length > 0 && !this.identicalContents(dtdContentTypes, jspContentTypes)) {
            List dtdValidatorIDs = this.getSourceValidatorIDs("testValidatorConfigurations.dtd");
            TestSourceValidationFramework.assertTrue((String)"No DTD source validators found", (!dtdValidatorIDs.isEmpty() ? 1 : 0) != 0);
            List jspValidatorIDs = this.getSourceValidatorIDs("testValidatorConfigurations.jsp");
            TestSourceValidationFramework.assertTrue((String)"No JSP source validators found", (!jspValidatorIDs.isEmpty() ? 1 : 0) != 0);
            int dtdValidatorCount = dtdValidatorIDs.size();
            dtdValidatorIDs.removeAll(jspValidatorIDs);
            TestSourceValidationFramework.assertEquals((String)"validators found running on both CSS and DTD", (int)dtdValidatorCount, (int)dtdValidatorIDs.size());
        }
    }

    public static class TestStructuredTextEditor
    extends StructuredTextEditor {
        public SourceViewerConfiguration textViewerConfiguration = null;

        protected void setSourceViewerConfiguration(SourceViewerConfiguration config) {
            super.setSourceViewerConfiguration(config);
            this.textViewerConfiguration = config;
        }
    }
}

