/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.tests.util;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class JSFUITestHelper {
    public static PreferenceDialog getPreferenceDialog(String id) {
        PreferenceDialogWrapper dialog = null;
        PreferenceManager manager = WorkbenchPlugin.getDefault().getPreferenceManager();
        if (manager != null) {
            dialog = new PreferenceDialogWrapper(JSFUITestHelper.getShell(), manager);
            dialog.create();
            for (IPreferenceNode node : manager.getElements(0)) {
                if (!node.getId().equals(id)) continue;
                dialog.showPage(node);
                break;
            }
        }
        return dialog;
    }

    public static PropertyDialog getPropertyDialog(String id, IAdaptable element) {
        Iterator pages;
        PropertyDialogWrapper dialog = null;
        PropertyPageManager manager = new PropertyPageManager();
        String title = "";
        String name = "";
        PropertyPageContributorManager.getManager().contribute(manager, (Object)element);
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)element.getAdapter(IWorkbenchAdapter.class);
        if (adapter != null) {
            name = adapter.getLabel((Object)element);
        }
        if (!(pages = manager.getElements(0).iterator()).hasNext()) {
            return null;
        }
        title = "Title: " + name;
        dialog = new PropertyDialogWrapper(JSFUITestHelper.getShell(), (PreferenceManager)manager, (ISelection)new StructuredSelection((Object)element));
        dialog.create();
        dialog.getShell().setText(title);
        for (IPreferenceNode node : manager.getElements(0)) {
            if (!node.getId().equals(id)) continue;
            dialog.showPage(node);
            break;
        }
        return dialog;
    }

    protected static Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private static class PreferenceDialogWrapper
    extends PreferenceDialog {
        public PreferenceDialogWrapper(Shell parentShell, PreferenceManager manager) {
            super(parentShell, manager);
        }

        protected boolean showPage(IPreferenceNode node) {
            return super.showPage(node);
        }
    }

    private static class PropertyDialogWrapper
    extends PropertyDialog {
        public PropertyDialogWrapper(Shell parentShell, PreferenceManager manager, ISelection selection) {
            super(parentShell, manager, selection);
        }

        protected boolean showPage(IPreferenceNode node) {
            return super.showPage(node);
        }
    }
}

