/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.model.ModuleArtifactDelegate;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.viewers.BaseLabelProvider;

public class ModuleArtifactComposite
extends Dialog {
    protected IModuleArtifact[] moduleArtifacts;
    private TableViewer tableViewer;
    private String launchMode;
    private IModuleArtifact selection;

    public ModuleArtifactComposite(Shell parent, IModuleArtifact[] moduleArtifacts, String launchMode) {
        super(parent);
        this.moduleArtifacts = moduleArtifacts;
        this.launchMode = launchMode;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getWindowTitle());
    }

    private String getWindowTitle() {
        String title = Messages.wizRunOnServerTitle;
        if ("debug".equals(this.launchMode)) {
            title = Messages.wizDebugOnServerTitle;
        } else if ("profile".equals(this.launchMode)) {
            title = Messages.wizProfileOnServerTitle;
        }
        return title;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 10;
        layout.numColumns = 1;
        GridData data = new GridData(1808);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Text description = new Text(composite, 0);
        description.setText(Messages.wizModuleArtifactsDescription);
        description.setEditable(false);
        description.setEnabled(true);
        description.setCursor(composite.getDisplay().getSystemCursor(0));
        this.createTable(composite);
        return composite;
    }

    private void createTable(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.numColumns = 1;
        GridData data = new GridData(1808);
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)data);
        tableComposite.setFont(parent.getFont());
        Label tableTitle = new Label(tableComposite, 0);
        tableTitle.setText(Messages.wizModuleArtifactsAvailableList);
        Table table = new Table(tableComposite, 68352);
        data = new GridData(1808);
        data.heightHint = 100;
        table.setLayoutData((Object)data);
        table.setLinesVisible(true);
        table.setHeaderVisible(false);
        table.setFocus();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 100, true));
        new TableColumn(table, 0);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ModuleArtifactComposite.this.getSelection();
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new BaseLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ModuleArtifactDelegate) {
                    ModuleArtifactDelegate moduleArtifact = (ModuleArtifactDelegate)element;
                    if (moduleArtifact.getName() == null || moduleArtifact.getName().length() == 0) {
                        return moduleArtifact.getClass().getName();
                    }
                    return moduleArtifact.getName();
                }
                return Messages.elementUnknownName;
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ModuleArtifactComposite.this.moduleArtifacts;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewer.setInput((Object)"root");
    }

    public IModuleArtifact getSelection() {
        IStructuredSelection selection2 = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection2 == null || selection2.getFirstElement() == null) {
            return this.selection;
        }
        this.selection = (IModuleArtifact)selection2.getFirstElement();
        return this.selection;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && this.getSelection() == null) {
            MessageBox messageBox = new MessageBox(this.getShell(), 33);
            messageBox.setMessage(Messages.wizModuleArtifactsNoSelectionError);
            messageBox.setText(this.getWindowTitle());
            messageBox.open();
            return;
        }
        super.buttonPressed(buttonId);
    }
}

