/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.jpt.core.internal.IAttributeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaBasic;
import org.eclipse.jpt.core.internal.content.orm.XmlBasic;
import org.eclipse.jpt.core.internal.content.orm.XmlTypeMapping;
import org.eclipse.jpt.core.internal.mappings.IColumn;
import org.eclipse.jpt.core.internal.platform.ColumnContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.XmlAttributeContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBasicContext
extends XmlAttributeContext {
    private ColumnContext columnContext;

    public XmlBasicContext(IContext parentContext, XmlBasic xmlBasic) {
        super(parentContext, xmlBasic);
        this.columnContext = new ColumnContext(this, xmlBasic.getColumn());
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        super.refreshDefaults(defaultsContext);
        this.columnContext.refreshDefaults(defaultsContext);
    }

    @Override
    protected Object getDefault(String key, DefaultsContext defaultsContext) {
        if (key.equals("column.name")) {
            if (this.attributeMapping().getPersistentAttribute().isVirtual() && this.javaBasicMapping() != null) {
                if (!this.attributeMapping().getPersistentType().getMapping().isXmlMetadataComplete()) {
                    return this.javaBasicMapping().getColumn().getName();
                }
                return this.javaBasicMapping().getColumn().getDefaultName();
            }
            return this.attributeMapping().getPersistentAttribute().getName();
        }
        return super.getDefault(key, defaultsContext);
    }

    protected JavaBasic javaBasicMapping() {
        IAttributeMapping attributeMapping = this.javaAttributeMapping();
        if (attributeMapping.getKey() == "basic") {
            return (JavaBasic)attributeMapping;
        }
        return null;
    }

    protected XmlBasic getBasic() {
        return (XmlBasic)this.attributeMapping();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        if (this.entityOwned()) {
            this.addColumnMessages(messages);
        }
    }

    protected void addColumnMessages(List<IMessage> messages) {
        XmlBasic basic = this.getBasic();
        XmlTypeMapping typeMapping = basic.typeMapping();
        IColumn column = basic.getColumn();
        String table = column.getTable();
        boolean doContinue = column.isConnected();
        if (doContinue && typeMapping.tableNameIsInvalid(table)) {
            if (basic.isVirtual()) {
                messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_TABLE", new String[]{basic.getPersistentAttribute().getName(), table, column.getName()}, column, column.tableTextRange()));
            } else {
                messages.add(JpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{table, column.getName()}, column, column.tableTextRange()));
            }
            doContinue = false;
        }
        if (doContinue && !column.isResolved()) {
            if (basic.isVirtual()) {
                messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME", new String[]{basic.getPersistentAttribute().getName(), column.getName()}, column, column.nameTextRange()));
            } else {
                messages.add(JpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName()}, column, column.nameTextRange()));
            }
        }
    }
}

