/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.content.java.IJavaTypeMapping;
import org.eclipse.jpt.core.internal.content.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.content.java.JavaPersistentType;
import org.eclipse.jpt.core.internal.platform.BaseContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.GeneratorRepository;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JavaPersistentAttributeContext;
import org.eclipse.jpt.core.internal.platform.TypeContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaTypeContext
extends BaseContext
implements TypeContext {
    private IJavaTypeMapping typeMapping;
    private Collection<JavaPersistentAttributeContext> javaPersistentAttributeContexts;
    private boolean refreshed;

    public JavaTypeContext(IContext parentContext, IJavaTypeMapping typeMapping) {
        super(parentContext);
        this.typeMapping = typeMapping;
        this.javaPersistentAttributeContexts = this.buildJavaPersistentAttributeContexts();
    }

    protected Collection<JavaPersistentAttributeContext> buildJavaPersistentAttributeContexts() {
        ArrayList<JavaPersistentAttributeContext> persistentAttributes = new ArrayList<JavaPersistentAttributeContext>();
        Iterator i = this.getPersistentType().getAttributes().iterator();
        while (i.hasNext()) {
            persistentAttributes.add(new JavaPersistentAttributeContext(this, (JavaPersistentAttribute)i.next()));
        }
        return persistentAttributes;
    }

    @Override
    protected void initialize() {
    }

    protected void populateGeneratorRepository(GeneratorRepository generatorRepository) {
        for (JavaPersistentAttributeContext context : this.getJavaPersistentAttributeContexts()) {
            context.populateGeneratorRepository(generatorRepository);
        }
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        this.refreshed = true;
        this.getPersistentType().refreshDefaults(defaultsContext);
        for (JavaPersistentAttributeContext context : this.javaPersistentAttributeContexts) {
            context.refreshDefaults(defaultsContext);
        }
    }

    @Override
    public JavaPersistentType getPersistentType() {
        return (JavaPersistentType)this.typeMapping.getPersistentType();
    }

    protected IJavaTypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    protected Collection<JavaPersistentAttributeContext> getJavaPersistentAttributeContexts() {
        return this.javaPersistentAttributeContexts;
    }

    @Override
    public boolean isRefreshed() {
        return this.refreshed;
    }

    public boolean contains(IPersistentType persistentType) {
        return persistentType == this.getPersistentType();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        this.addAttributeMessages(messages);
    }

    protected void addAttributeMessages(List<IMessage> messages) {
        for (JavaPersistentAttributeContext attributeContext : this.javaPersistentAttributeContexts) {
            attributeContext.addToMessages(messages);
        }
    }
}

