/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.content.orm.XmlMultiRelationshipMappingInternal;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.INonOwningMapping;
import org.eclipse.jpt.core.internal.mappings.ITable;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JoinTableContext;
import org.eclipse.jpt.core.internal.platform.XmlRelationshipMappingContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlMultiRelationshipMappingContext
extends XmlRelationshipMappingContext {
    private JoinTableContext joinTableContext;

    protected XmlMultiRelationshipMappingContext(IContext parentContext, XmlMultiRelationshipMappingInternal mapping) {
        super(parentContext, mapping);
        this.joinTableContext = new JoinTableContext(this, mapping.getJoinTable());
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        super.refreshDefaults(defaultsContext);
        this.joinTableContext.refreshDefaults(defaultsContext);
    }

    @Override
    protected Object getDefault(String key, DefaultsContext defaultsContext) {
        if (key.equals("joinTable.name")) {
            return this.joinTableDefaultName(defaultsContext);
        }
        return super.getDefault(key, defaultsContext);
    }

    protected String joinTableDefaultName(DefaultsContext defaultsContext) {
        String tableName = this.multiRelationshipMapping().typeMapping().getTableName();
        if (tableName == null) {
            return null;
        }
        IEntity targetEntity = this.targetEntity(defaultsContext);
        if (targetEntity == null) {
            return null;
        }
        ITable targetTable = targetEntity.getTable();
        return targetTable == null ? null : String.valueOf(tableName) + "_" + targetTable.getName();
    }

    protected XmlMultiRelationshipMappingInternal multiRelationshipMapping() {
        return (XmlMultiRelationshipMappingInternal)this.relationshipMapping();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        if (this.multiRelationshipMapping().getMappedBy() != null) {
            this.addMappedByMessages(messages);
        } else if (this.entityOwned()) {
            this.addJoinTableMessages(messages);
        }
    }

    protected void addJoinTableMessages(List<IMessage> messages) {
        this.joinTableContext.addToMessages(messages);
    }

    protected void addMappedByMessages(List<IMessage> messages) {
        INonOwningMapping mappedByMapping;
        IEntity targetEntity;
        XmlMultiRelationshipMappingInternal mapping = this.multiRelationshipMapping();
        String mappedBy = mapping.getMappedBy();
        if (mapping.isJoinTableSpecified()) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_WITH_JOIN_TABLE", mapping.getJoinTable(), mapping.getJoinTable().validationTextRange()));
        }
        if ((targetEntity = mapping.getResolvedTargetEntity()) == null) {
            return;
        }
        IPersistentAttribute attribute = targetEntity.getPersistentType().resolveAttribute(mappedBy);
        if (attribute == null) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_UNRESOLVED_MAPPED_BY", new String[]{mappedBy}, mapping, mapping.mappedByTextRange()));
            return;
        }
        if (!mapping.mappedByIsValid(attribute.getMapping())) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_INVALID_MAPPED_BY", new String[]{mappedBy}, mapping, mapping.mappedByTextRange()));
            return;
        }
        try {
            mappedByMapping = (INonOwningMapping)attribute.getMapping();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        if (mappedByMapping.getMappedBy() != null) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_ON_BOTH_SIDES", mapping, mapping.mappedByTextRange()));
        }
    }
}

