/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.jpt.core.internal.IAttributeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaVersion;
import org.eclipse.jpt.core.internal.content.orm.XmlTypeMapping;
import org.eclipse.jpt.core.internal.content.orm.XmlVersion;
import org.eclipse.jpt.core.internal.mappings.IColumn;
import org.eclipse.jpt.core.internal.platform.ColumnContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.XmlAttributeContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlVersionContext
extends XmlAttributeContext {
    private ColumnContext columnContext;

    public XmlVersionContext(IContext parentContext, XmlVersion xmlVersion) {
        super(parentContext, xmlVersion);
        this.columnContext = new ColumnContext(this, xmlVersion.getColumn());
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        super.refreshDefaults(defaultsContext);
        this.columnContext.refreshDefaults(defaultsContext);
    }

    @Override
    protected Object getDefault(String key, DefaultsContext defaultsContext) {
        if (key.equals("column.name")) {
            if (this.attributeMapping().getPersistentAttribute().isVirtual() && this.javaVersionMapping() != null) {
                if (!this.attributeMapping().getPersistentType().getMapping().isXmlMetadataComplete()) {
                    return this.javaVersionMapping().getColumn().getName();
                }
                return this.javaVersionMapping().getColumn().getDefaultName();
            }
            return this.attributeMapping().getPersistentAttribute().getName();
        }
        return super.getDefault(key, defaultsContext);
    }

    protected JavaVersion javaVersionMapping() {
        IAttributeMapping attributeMapping = this.javaAttributeMapping();
        if (attributeMapping.getKey() == "version") {
            return (JavaVersion)attributeMapping;
        }
        return null;
    }

    protected XmlVersion getVersion() {
        return (XmlVersion)this.attributeMapping();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        if (this.entityOwned()) {
            this.addColumnMessages(messages);
        }
    }

    protected void addColumnMessages(List<IMessage> messages) {
        boolean doContinue;
        XmlVersion version = this.getVersion();
        XmlTypeMapping typeMapping = version.typeMapping();
        IColumn column = version.getColumn();
        String table = column.getTable();
        boolean bl = doContinue = this.entityOwned() && column.isConnected();
        if (doContinue && typeMapping.tableNameIsInvalid(table)) {
            if (version.isVirtual()) {
                messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_TABLE", new String[]{version.getPersistentAttribute().getName(), table, column.getName()}, column, column.tableTextRange()));
            } else {
                messages.add(JpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{table, column.getName()}, column, column.tableTextRange()));
            }
            doContinue = false;
        }
        if (doContinue && !column.isResolved()) {
            if (version.isVirtual()) {
                messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME", new String[]{version.getPersistentAttribute().getName(), column.getName()}, column, column.nameTextRange()));
            } else {
                messages.add(JpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName()}, column, column.nameTextRange()));
            }
        }
    }
}

