/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.gen.internal;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.db.internal.Column;
import org.eclipse.jpt.db.internal.ForeignKey;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.gen.internal.GenTable;
import org.eclipse.jpt.gen.internal.ManyToManyRelation;
import org.eclipse.jpt.gen.internal.ManyToOneRelation;
import org.eclipse.jpt.gen.internal.OneToManyRelation;
import org.eclipse.jpt.utility.internal.IndentingPrintWriter;
import org.eclipse.jpt.utility.internal.JavaType;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityGenerator {
    final Config config;
    private final IPackageFragment packageFragment;
    private final GenTable genTable;
    private final String entityClassName;
    private final OverwriteConfirmer overwriteConfirmer;
    private final IProgressMonitor monitor;

    public static void generateEntity(Config config, IPackageFragment packageFragment, GenTable genTable, OverwriteConfirmer overwriteConfirmer, IProgressMonitor monitor) {
        if (config == null || packageFragment == null || genTable == null) {
            throw new NullPointerException();
        }
        new EntityGenerator(config, packageFragment, genTable, overwriteConfirmer, monitor).generateEntity();
    }

    private EntityGenerator(Config config, IPackageFragment packageFragment, GenTable genTable, OverwriteConfirmer overwriteConfirmer, IProgressMonitor monitor) {
        this.config = config;
        this.packageFragment = packageFragment;
        this.genTable = genTable;
        this.entityClassName = this.fullyQualify(this.entityName());
        this.overwriteConfirmer = overwriteConfirmer;
        this.monitor = monitor;
    }

    private void generateEntity() {
        try {
            this.generateEntity_();
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void generateEntity_() throws JavaModelException {
        String fileName = String.valueOf(this.entityName()) + ".java";
        String source = this.buildSource();
        try {
            this.packageFragment.createCompilationUnit(fileName, source, false, this.monitor);
        }
        catch (JavaModelException ex) {
            if (ex.getJavaModelStatus().getCode() == 977) {
                if (this.overwriteConfirmer.overwrite(this.entityClassName)) {
                    this.packageFragment.createCompilationUnit(fileName, source, true, this.monitor);
                }
            }
            throw ex;
        }
    }

    private String buildSource() {
        BodySource bodySource = this.buildBodySource();
        StringWriter sw = new StringWriter(bodySource.length() + 1000);
        PrintWriter pw = new PrintWriter(sw);
        this.printPackageAndImportsOn(pw, bodySource);
        pw.print(bodySource.source());
        return sw.toString();
    }

    private BodySource buildBodySource() {
        EntitySourceWriter pw = new EntitySourceWriter(this.packageName(), this.entityClassName);
        this.printBodySourceOn(pw);
        return pw;
    }

    private void printBodySourceOn(EntitySourceWriter pw) {
        this.printClassDeclarationOn(pw);
        pw.indent();
        this.printEntityPrimaryKeyFieldsOn(pw);
        this.printEntityNonPrimaryKeyBasicFieldsOn(pw);
        this.printEntityManyToOneFieldsOn(pw);
        this.printEntityOneToManyFieldsOn(pw);
        this.printEntityOwnedManyToManyFieldsOn(pw);
        this.printEntityNonOwnedManyToManyFieldsOn(pw);
        this.printSerialVersionUID(pw);
        pw.println();
        this.printZeroArgumentConstructorOn(this.entityName(), this.config.methodVisibility(), pw);
        if (this.config.propertyAccessType() || this.config.generateGettersAndSetters()) {
            this.printEntityPrimaryKeyGettersAndSettersOn(pw);
            this.printEntityNonPrimaryKeyBasicGettersAndSettersOn(pw);
            this.printEntityManyToOneGettersAndSettersOn(pw);
            this.printEntityOneToManyGettersAndSettersOn(pw);
            this.printEntityOwnedManyToManyGettersAndSettersOn(pw);
            this.printEntityNonOwnedManyToManyGettersAndSettersOn(pw);
        }
        this.printPrimaryKeyClassOn(pw);
        pw.undent();
        pw.print('}');
        pw.println();
    }

    private void printClassDeclarationOn(EntitySourceWriter pw) {
        this.printEntityAnnotationOn(pw);
        this.printTableAnnotationOn(pw);
        this.printIdClassAnnotationOn(pw);
        pw.print("public class ");
        pw.printTypeDeclaration(this.entityClassName);
        if (this.config.serializable()) {
            pw.print(" implements ");
            pw.printTypeDeclaration(Serializable.class.getName());
        }
        pw.print(" {");
        pw.println();
    }

    private void printEntityAnnotationOn(EntitySourceWriter pw) {
        pw.printAnnotation("javax.persistence.Entity");
        pw.println();
    }

    private void printTableAnnotationOn(EntitySourceWriter pw) {
        if (!this.table().matchesShortJavaClassName(this.entityName())) {
            pw.printAnnotation("javax.persistence.Table");
            pw.print("(name=\"");
            pw.print(this.table().getName());
            pw.print("\")");
            pw.println();
        }
    }

    private void printIdClassAnnotationOn(EntitySourceWriter pw) {
        if (this.table().primaryKeyColumnsSize() > 1 && this.config.generateIdClassForCompoundPK()) {
            pw.printAnnotation("javax.persistence.IdClass");
            pw.print('(');
            pw.printTypeDeclaration(String.valueOf(this.entityClassName) + ".PK");
            pw.print(".class)");
            pw.println();
        }
    }

    private void printEntityPrimaryKeyFieldsOn(EntitySourceWriter pw) {
        if (this.table().primaryKeyColumnsSize() > 1 && this.config.generateEmbeddedIdForCompoundPK()) {
            this.printEntityEmbeddedIdPrimaryKeyFieldOn(pw);
        } else {
            this.printEntityReadOnlyPrimaryKeyFieldsOn(pw);
            this.printEntityWritablePrimaryKeyFieldsOn(pw);
        }
    }

    private void printEntityEmbeddedIdPrimaryKeyFieldOn(EntitySourceWriter pw) {
        if (this.config.fieldAccessType()) {
            pw.printAnnotation("javax.persistence.EmbeddedId");
            pw.println();
        }
        pw.printVisibility(this.config.fieldVisibility());
        pw.printTypeDeclaration(String.valueOf(this.entityClassName) + ".PK");
        pw.print(' ');
        pw.print(this.genTable.fieldNameForEmbeddedId());
        pw.print(';');
        pw.println();
        pw.println();
    }

    private void printEntityReadOnlyPrimaryKeyFieldsOn(EntitySourceWriter pw) {
        Iterator<Column> stream = this.genTable.readOnlyPrimaryKeyColumns();
        while (stream.hasNext()) {
            this.printEntityReadOnlyPrimaryKeyFieldOn(stream.next(), pw);
        }
    }

    private void printEntityReadOnlyPrimaryKeyFieldOn(Column column, EntitySourceWriter pw) {
        String fieldName = this.genTable.fieldNameFor(column);
        if (this.config.fieldAccessType()) {
            pw.printAnnotation("javax.persistence.Id");
            pw.println();
            if (column.matchesJavaFieldName(fieldName)) {
                this.printReadOnlyColumnAnnotationOn(pw);
            } else {
                this.printReadOnlyColumnAnnotationOn(column.getName(), pw);
            }
        }
        pw.printVisibility(this.config.fieldVisibility());
        pw.printTypeDeclaration(column.javaTypeDeclaration());
        pw.print(' ');
        pw.print(fieldName);
        pw.print(';');
        pw.println();
        pw.println();
    }

    private void printReadOnlyColumnAnnotationOn(String columnName, EntitySourceWriter pw) {
        pw.printAnnotation("javax.persistence.Column");
        pw.print("(name=\"");
        pw.print(columnName);
        pw.print("\", insertable=false, updatable=false)");
        pw.println();
    }

    private void printReadOnlyColumnAnnotationOn(EntitySourceWriter pw) {
        pw.printAnnotation("javax.persistence.Column");
        pw.print("(insertable=false, updatable=false)");
        pw.println();
    }

    private void printEntityWritablePrimaryKeyFieldsOn(EntitySourceWriter pw) {
        Iterator<Column> stream = this.genTable.writablePrimaryKeyColumns();
        while (stream.hasNext()) {
            this.printEntityWritablePrimaryKeyFieldOn(stream.next(), pw);
        }
    }

    private void printEntityWritablePrimaryKeyFieldOn(Column column, EntitySourceWriter pw) {
        String fieldName = this.genTable.fieldNameFor(column);
        if (this.config.fieldAccessType()) {
            pw.printAnnotation("javax.persistence.Id");
            pw.println();
            if (!column.matchesJavaFieldName(fieldName)) {
                this.printColumnAnnotationOn(column.getName(), pw);
            }
        }
        pw.printVisibility(this.config.fieldVisibility());
        pw.printTypeDeclaration(column.javaTypeDeclaration());
        pw.print(' ');
        pw.print(fieldName);
        pw.print(';');
        pw.println();
        pw.println();
    }

    private void printEntityNonPrimaryKeyBasicFieldsOn(EntitySourceWriter pw) {
        Iterator<Column> stream = this.genTable.nonPrimaryKeyBasicColumns();
        while (stream.hasNext()) {
            this.printEntityNonPrimaryKeyBasicFieldOn(stream.next(), pw);
        }
    }

    private void printEntityNonPrimaryKeyBasicFieldOn(Column column, EntitySourceWriter pw) {
        String fieldName = this.genTable.fieldNameFor(column);
        if (this.config.fieldAccessType() && !column.matchesJavaFieldName(fieldName)) {
            this.printColumnAnnotationOn(column.getName(), pw);
        }
        if (column.isLob()) {
            pw.printAnnotation("javax.persistence.Lob");
            pw.println();
        }
        pw.printVisibility(this.config.fieldVisibility());
        pw.printTypeDeclaration(column.javaTypeDeclaration());
        pw.print(' ');
        pw.print(fieldName);
        pw.print(';');
        pw.println();
        pw.println();
    }

    private void printColumnAnnotationOn(String columnName, EntitySourceWriter pw) {
        pw.printAnnotation("javax.persistence.Column");
        pw.print("(name=\"");
        pw.print(columnName);
        pw.print("\")");
        pw.println();
    }

    private void printEntityManyToOneFieldsOn(EntitySourceWriter pw) {
        Iterator<ManyToOneRelation> stream = this.genTable.manyToOneRelations();
        while (stream.hasNext()) {
            this.printEntityManyToOneFieldOn(stream.next(), pw);
        }
    }

    private void printEntityManyToOneFieldOn(ManyToOneRelation relation, EntitySourceWriter pw) {
        String fieldName = this.genTable.fieldNameFor(relation);
        if (this.config.fieldAccessType()) {
            this.printManyToOneAnnotationOn(fieldName, relation, pw);
        }
        pw.printVisibility(this.config.fieldVisibility());
        pw.printTypeDeclaration(this.fullyQualify(relation.referencedEntityName()));
        pw.print(' ');
        pw.print(fieldName);
        pw.print(';');
        pw.println();
        pw.println();
    }

    private void printManyToOneAnnotationOn(String fieldName, ManyToOneRelation relation, EntitySourceWriter pw) {
        pw.printAnnotation("javax.persistence.ManyToOne");
        pw.println();
        ForeignKey fk = relation.getForeignKey();
        if (fk.matchesJavaFieldName(fieldName)) {
            return;
        }
        if (fk.referencesSingleColumnPrimaryKey()) {
            pw.printAnnotation("javax.persistence.JoinColumn");
            pw.print("(name=\"");
            pw.print(((ForeignKey.ColumnPair)fk.columnPairs().next()).getBaseColumn().getName());
            pw.print("\")");
        } else {
            if (fk.columnPairsSize() > 1) {
                pw.printAnnotation("javax.persistence.JoinColumns");
                pw.print("({");
                pw.println();
                pw.indent();
            }
            this.printJoinColumnAnnotationsOn(fk, pw);
            if (fk.columnPairsSize() > 1) {
                pw.undent();
                pw.println();
                pw.print("})");
            }
        }
        pw.println();
    }

    private void printJoinColumnAnnotationsOn(ForeignKey foreignKey, EntitySourceWriter pw) {
        Iterator stream = foreignKey.columnPairs();
        while (stream.hasNext()) {
            this.printJoinColumnAnnotationOn((ForeignKey.ColumnPair)stream.next(), pw);
            if (!stream.hasNext()) continue;
            pw.println(',');
        }
    }

    private void printJoinColumnAnnotationOn(ForeignKey.ColumnPair columnPair, EntitySourceWriter pw) {
        this.printJoinColumnAnnotationOn(columnPair.getBaseColumn().getName(), columnPair.getReferencedColumn().getName(), pw);
    }

    private void printJoinColumnAnnotationOn(String baseColumnName, String referencedColumnName, EntitySourceWriter pw) {
        pw.printAnnotation("javax.persistence.JoinColumn");
        pw.print('(');
        if (baseColumnName != null) {
            pw.print("name=\"");
            pw.print(baseColumnName);
        }
        if (referencedColumnName != null) {
            if (baseColumnName != null) {
                pw.print("\", ");
            }
            pw.print("referencedColumnName=\"");
            pw.print(referencedColumnName);
        }
        pw.print("\")");
    }

    private void printEntityOneToManyFieldsOn(EntitySourceWriter pw) {
        Iterator<OneToManyRelation> stream = this.genTable.oneToManyRelations();
        while (stream.hasNext()) {
            this.printEntityOneToManyFieldOn(stream.next(), pw);
        }
    }

    private void printEntityOneToManyFieldOn(OneToManyRelation relation, EntitySourceWriter pw) {
        String fieldName = this.genTable.fieldNameFor(relation);
        if (this.config.fieldAccessType()) {
            this.printOneToManyAnnotationOn(fieldName, relation, pw);
        }
        pw.printVisibility(this.config.fieldVisibility());
        pw.printTypeDeclaration(this.config.getCollectionTypeName());
        pw.print('<');
        pw.printTypeDeclaration(this.fullyQualify(relation.referencedEntityName()));
        pw.print('>');
        pw.print(' ');
        pw.print(fieldName);
        pw.print(';');
        pw.println();
        pw.println();
    }

    private void printOneToManyAnnotationOn(String fieldName, OneToManyRelation relation, EntitySourceWriter pw) {
        pw.printAnnotation("javax.persistence.OneToMany");
        pw.print("(mappedBy=\"");
        pw.print(relation.mappedBy());
        pw.print("\")");
        pw.println();
    }

    private void printEntityOwnedManyToManyFieldsOn(EntitySourceWriter pw) {
        Iterator<ManyToManyRelation> stream = this.genTable.ownedManyToManyRelations();
        while (stream.hasNext()) {
            this.printEntityOwnedManyToManyFieldOn(stream.next(), pw);
        }
    }

    private void printEntityOwnedManyToManyFieldOn(ManyToManyRelation relation, EntitySourceWriter pw) {
        String fieldName = this.genTable.fieldNameFor(relation);
        if (this.config.fieldAccessType()) {
            this.printOwnedManyToManyAnnotationOn(fieldName, relation, pw);
        }
        pw.printVisibility(this.config.fieldVisibility());
        pw.printTypeDeclaration(this.config.getCollectionTypeName());
        pw.print('<');
        pw.printTypeDeclaration(this.fullyQualify(relation.nonOwningEntityName()));
        pw.print('>');
        pw.print(' ');
        pw.print(fieldName);
        pw.print(';');
        pw.println();
        pw.println();
    }

    private void printOwnedManyToManyAnnotationOn(String fieldName, ManyToManyRelation relation, EntitySourceWriter pw) {
        String inverseFieldName;
        pw.printAnnotation("javax.persistence.ManyToMany");
        pw.println();
        boolean first = true;
        boolean comma = false;
        if (!relation.joinTableNameIsDefault()) {
            if (first) {
                first = false;
                pw.printAnnotation("javax.persistence.JoinTable");
                pw.print('(');
            }
            pw.print("name=\"");
            pw.print(relation.getJoinTable().name());
            pw.print('\"');
            comma = true;
        }
        if (!relation.joinColumnsIsDefaultFor(fieldName)) {
            if (first) {
                first = false;
                pw.printAnnotation("javax.persistence.JoinTable");
                pw.print('(');
            } else if (comma) {
                pw.print(',');
            }
            pw.println();
            pw.indent();
            this.printJoinTableJoinColumnsOn("joinColumns", fieldName, relation.getOwningForeignKey(), pw);
            pw.undent();
            comma = true;
        }
        if (!relation.inverseJoinColumnsIsDefaultFor(inverseFieldName = relation.getNonOwningTable().fieldNameFor(relation))) {
            if (first) {
                first = false;
                pw.printAnnotation("javax.persistence.JoinTable");
                pw.print('(');
            } else if (comma) {
                pw.print(',');
            }
            pw.println();
            pw.indent();
            this.printJoinTableJoinColumnsOn("inverseJoinColumns", inverseFieldName, relation.getNonOwningForeignKey(), pw);
            pw.undent();
            comma = true;
        }
        if (!first) {
            pw.print(')');
        }
        pw.println();
    }

    private void printJoinTableJoinColumnsOn(String elementName, String fieldName, ForeignKey foreignKey, EntitySourceWriter pw) {
        if (foreignKey.columnPairsSize() != 1) {
            this.printJoinTableJoinColumnsOn(elementName, foreignKey, pw);
        } else if (foreignKey.getReferencedTable().primaryKeyColumnsSize() != 1) {
            this.printJoinTableJoinColumnsOn(elementName, foreignKey, pw);
        } else {
            ForeignKey.ColumnPair columnPair = (ForeignKey.ColumnPair)foreignKey.columnPairs().next();
            Column pkColumn = (Column)foreignKey.getReferencedTable().primaryKeyColumns().next();
            if (columnPair.getBaseColumn().matchesJavaFieldName(String.valueOf(fieldName) + "_" + pkColumn.getName())) {
                if (columnPair.getReferencedColumn() != pkColumn) {
                    pw.print(elementName);
                    pw.print('=');
                    this.printJoinColumnAnnotationOn(null, columnPair.getReferencedColumn().getName(), pw);
                }
            } else if (columnPair.getReferencedColumn() == pkColumn) {
                pw.print(elementName);
                pw.print('=');
                this.printJoinColumnAnnotationOn(columnPair.getBaseColumn().getName(), null, pw);
            } else {
                this.printJoinTableJoinColumnsOn(elementName, foreignKey, pw);
            }
        }
    }

    private void printJoinTableJoinColumnsOn(String elementName, ForeignKey foreignKey, EntitySourceWriter pw) {
        pw.print(elementName);
        pw.print('=');
        if (foreignKey.columnPairsSize() > 1) {
            pw.print('{');
            pw.println();
            pw.indent();
        }
        this.printJoinColumnAnnotationsOn(foreignKey, pw);
        if (foreignKey.columnPairsSize() > 1) {
            pw.undent();
            pw.println();
            pw.print('}');
            pw.println();
        }
    }

    private void printEntityNonOwnedManyToManyFieldsOn(EntitySourceWriter pw) {
        Iterator<ManyToManyRelation> stream = this.genTable.nonOwnedManyToManyRelations();
        while (stream.hasNext()) {
            this.printEntityNonOwnedManyToManyFieldOn(stream.next(), pw);
        }
    }

    private void printEntityNonOwnedManyToManyFieldOn(ManyToManyRelation relation, EntitySourceWriter pw) {
        String fieldName = this.genTable.fieldNameFor(relation);
        if (this.config.fieldAccessType()) {
            this.printNonOwnedManyToManyAnnotationOn(fieldName, relation, pw);
        }
        pw.printVisibility(this.config.fieldVisibility());
        pw.printTypeDeclaration(this.config.getCollectionTypeName());
        pw.print('<');
        pw.printTypeDeclaration(this.fullyQualify(relation.owningEntityName()));
        pw.print('>');
        pw.print(' ');
        pw.print(fieldName);
        pw.print(';');
        pw.println();
        pw.println();
    }

    private void printNonOwnedManyToManyAnnotationOn(String fieldName, ManyToManyRelation relation, EntitySourceWriter pw) {
        pw.printAnnotation("javax.persistence.ManyToMany");
        pw.print("(mappedBy=\"");
        pw.print(relation.getMappedBy());
        pw.print("\")");
        pw.println();
    }

    private String fullyQualify(String shortClassName) {
        String pkg = this.packageName();
        return pkg.length() == 0 ? shortClassName : String.valueOf(pkg) + '.' + shortClassName;
    }

    private void printSerialVersionUID(EntitySourceWriter pw) {
        if (this.config.generateSerialVersionUID()) {
            pw.print("private static final long serialVersionUID = 1L;");
            pw.println();
        }
    }

    private void printZeroArgumentConstructorOn(String ctorName, String visibility, EntitySourceWriter pw) {
        if (this.config.generateDefaultConstructor()) {
            pw.printVisibility(visibility);
            pw.print(ctorName);
            pw.print("() {");
            pw.println();
            pw.indent();
            pw.println("super();");
            pw.undent();
            pw.print('}');
            pw.println();
            pw.println();
        }
    }

    private void printEntityPrimaryKeyGettersAndSettersOn(EntitySourceWriter pw) {
        if (this.table().primaryKeyColumnsSize() > 1 && this.config.generateEmbeddedIdForCompoundPK()) {
            this.printEntityEmbeddedIdPrimaryKeyGetterAndSetterOn(pw);
        } else {
            this.printEntityReadOnlyPrimaryKeyGettersAndSettersOn(pw);
            this.printEntityWritablePrimaryKeyGettersAndSettersOn(pw);
        }
    }

    private void printEntityEmbeddedIdPrimaryKeyGetterAndSetterOn(EntitySourceWriter pw) {
        if (this.config.propertyAccessType()) {
            pw.printAnnotation("javax.persistence.EmbeddedId");
            pw.println();
        }
        pw.printGetterAndSetter(this.genTable.fieldNameForEmbeddedId(), String.valueOf(this.entityClassName) + ".PK", this.config.methodVisibility());
    }

    private void printEntityReadOnlyPrimaryKeyGettersAndSettersOn(EntitySourceWriter pw) {
        Iterator<Column> stream = this.genTable.readOnlyPrimaryKeyColumns();
        while (stream.hasNext()) {
            this.printEntityReadOnlyPrimaryKeyGetterAndSetterOn(stream.next(), pw);
        }
    }

    private void printEntityReadOnlyPrimaryKeyGetterAndSetterOn(Column column, EntitySourceWriter pw) {
        String propertyName = this.genTable.fieldNameFor(column);
        if (this.config.propertyAccessType()) {
            pw.printAnnotation("javax.persistence.Id");
            pw.println();
            if (column.matchesJavaFieldName(propertyName)) {
                this.printReadOnlyColumnAnnotationOn(pw);
            } else {
                this.printReadOnlyColumnAnnotationOn(column.getName(), pw);
            }
        }
        pw.printGetterAndSetter(propertyName, column.javaTypeDeclaration(), this.config.methodVisibility());
    }

    private void printEntityWritablePrimaryKeyGettersAndSettersOn(EntitySourceWriter pw) {
        Iterator<Column> stream = this.genTable.writablePrimaryKeyColumns();
        while (stream.hasNext()) {
            this.printEntityWritablePrimaryKeyGetterAndSetterOn(stream.next(), pw);
        }
    }

    private void printEntityWritablePrimaryKeyGetterAndSetterOn(Column column, EntitySourceWriter pw) {
        String propertyName = this.genTable.fieldNameFor(column);
        if (this.config.propertyAccessType()) {
            pw.printAnnotation("javax.persistence.Id");
            pw.println();
            if (!column.matchesJavaFieldName(propertyName)) {
                this.printColumnAnnotationOn(column.getName(), pw);
            }
        }
        pw.printGetterAndSetter(propertyName, column.javaTypeDeclaration(), this.config.methodVisibility());
    }

    private void printEntityNonPrimaryKeyBasicGettersAndSettersOn(EntitySourceWriter pw) {
        Iterator<Column> stream = this.genTable.nonPrimaryKeyBasicColumns();
        while (stream.hasNext()) {
            this.printEntityNonPrimaryKeyBasicGetterAndSetterOn(stream.next(), pw);
        }
    }

    private void printEntityNonPrimaryKeyBasicGetterAndSetterOn(Column column, EntitySourceWriter pw) {
        String propertyName = this.genTable.fieldNameFor(column);
        if (this.config.propertyAccessType() && !column.matchesJavaFieldName(propertyName)) {
            this.printColumnAnnotationOn(column.getName(), pw);
        }
        pw.printGetterAndSetter(propertyName, column.javaTypeDeclaration(), this.config.methodVisibility());
    }

    private void printEntityManyToOneGettersAndSettersOn(EntitySourceWriter pw) {
        Iterator<ManyToOneRelation> stream = this.genTable.manyToOneRelations();
        while (stream.hasNext()) {
            this.printEntityManyToOneGetterAndSetterOn(stream.next(), pw);
        }
    }

    private void printEntityManyToOneGetterAndSetterOn(ManyToOneRelation relation, EntitySourceWriter pw) {
        String propertyName = this.genTable.fieldNameFor(relation);
        if (this.config.propertyAccessType()) {
            this.printManyToOneAnnotationOn(propertyName, relation, pw);
        }
        String typeDeclaration = this.fullyQualify(relation.referencedEntityName());
        pw.printGetterAndSetter(propertyName, typeDeclaration, this.config.methodVisibility());
    }

    private void printEntityOneToManyGettersAndSettersOn(EntitySourceWriter pw) {
        Iterator<OneToManyRelation> stream = this.genTable.oneToManyRelations();
        while (stream.hasNext()) {
            this.printEntityOneToManyGetterAndSetterOn(stream.next(), pw);
        }
    }

    private void printEntityOneToManyGetterAndSetterOn(OneToManyRelation relation, EntitySourceWriter pw) {
        String propertyName = this.genTable.fieldNameFor(relation);
        if (this.config.propertyAccessType()) {
            this.printOneToManyAnnotationOn(propertyName, relation, pw);
        }
        String elementTypeDeclaration = this.fullyQualify(relation.referencedEntityName());
        pw.printCollectionGetterAndSetter(propertyName, this.config.getCollectionTypeName(), elementTypeDeclaration, this.config.methodVisibility());
    }

    private void printEntityOwnedManyToManyGettersAndSettersOn(EntitySourceWriter pw) {
        Iterator<ManyToManyRelation> stream = this.genTable.ownedManyToManyRelations();
        while (stream.hasNext()) {
            this.printEntityOwnedManyToManyGetterAndSetterOn(stream.next(), pw);
        }
    }

    private void printEntityOwnedManyToManyGetterAndSetterOn(ManyToManyRelation relation, EntitySourceWriter pw) {
        String propertyName = this.genTable.fieldNameFor(relation);
        if (this.config.propertyAccessType()) {
            this.printOwnedManyToManyAnnotationOn(propertyName, relation, pw);
        }
        String elementTypeDeclaration = this.fullyQualify(relation.nonOwningEntityName());
        pw.printCollectionGetterAndSetter(propertyName, this.config.getCollectionTypeName(), elementTypeDeclaration, this.config.methodVisibility());
    }

    private void printEntityNonOwnedManyToManyGettersAndSettersOn(EntitySourceWriter pw) {
        Iterator<ManyToManyRelation> stream = this.genTable.nonOwnedManyToManyRelations();
        while (stream.hasNext()) {
            this.printEntityNonOwnedManyToManyGetterAndSetterOn(stream.next(), pw);
        }
    }

    private void printEntityNonOwnedManyToManyGetterAndSetterOn(ManyToManyRelation relation, EntitySourceWriter pw) {
        String propertyName = this.genTable.fieldNameFor(relation);
        if (this.config.propertyAccessType()) {
            this.printNonOwnedManyToManyAnnotationOn(propertyName, relation, pw);
        }
        String elementTypeDeclaration = this.fullyQualify(relation.owningEntityName());
        pw.printCollectionGetterAndSetter(propertyName, this.config.getCollectionTypeName(), elementTypeDeclaration, this.config.methodVisibility());
    }

    private void printPrimaryKeyClassOn(EntitySourceWriter pw) {
        if (this.table().primaryKeyColumnsSize() <= 1) {
            return;
        }
        pw.println();
        if (this.config.generateEmbeddedIdForCompoundPK()) {
            pw.printAnnotation("javax.persistence.Embeddable");
            pw.println();
        }
        pw.print("public static class PK implements ");
        pw.printTypeDeclaration(Serializable.class.getName());
        pw.print(" {");
        pw.println();
        pw.indent();
        this.printIdFieldsOn(pw);
        this.printSerialVersionUID(pw);
        pw.println();
        this.printZeroArgumentConstructorOn("PK", "public", pw);
        if (this.config.propertyAccessType() || this.config.generateGettersAndSetters()) {
            this.printIdGettersAndSettersOn(pw);
        }
        this.printEqualsMethodOn("PK", this.table().primaryKeyColumns(), pw);
        this.printHashCodeMethodOn(this.table().primaryKeyColumns(), pw);
        pw.undent();
        pw.print('}');
        pw.println();
        pw.println();
    }

    private void printIdFieldsOn(EntitySourceWriter pw) {
        Iterator stream = this.table().primaryKeyColumns();
        while (stream.hasNext()) {
            this.printIdFieldOn((Column)stream.next(), pw);
        }
    }

    private void printIdFieldOn(Column column, EntitySourceWriter pw) {
        String fieldName = this.genTable.fieldNameFor(column);
        pw.printVisibility(this.config.fieldVisibility());
        pw.printTypeDeclaration(column.javaTypeDeclaration());
        pw.print(' ');
        pw.print(fieldName);
        pw.print(';');
        pw.println();
    }

    private void printIdGettersAndSettersOn(EntitySourceWriter pw) {
        Iterator stream = this.table().primaryKeyColumns();
        while (stream.hasNext()) {
            this.printIdGetterAndSetterOn((Column)stream.next(), pw);
        }
    }

    private void printIdGetterAndSetterOn(Column column, EntitySourceWriter pw) {
        String propertyName = this.genTable.fieldNameFor(column);
        pw.printGetterAndSetter(propertyName, column.javaTypeDeclaration(), this.config.methodVisibility());
    }

    private void printEqualsMethodOn(String className, Iterator<Column> columns, EntitySourceWriter pw) {
        pw.printAnnotation("java.lang.Override");
        pw.println();
        pw.println("public boolean equals(Object o) {");
        pw.indent();
        pw.println("if (o == this) {");
        pw.indent();
        pw.println("return true;");
        pw.undent();
        pw.print('}');
        pw.println();
        pw.print("if ( ! (o instanceof ");
        pw.print(className);
        pw.print(")) {");
        pw.println();
        pw.indent();
        pw.println("return false;");
        pw.undent();
        pw.print('}');
        pw.println();
        pw.print(className);
        pw.print(" other = (");
        pw.print(className);
        pw.print(") o;");
        pw.println();
        pw.print("return ");
        pw.indent();
        while (columns.hasNext()) {
            this.printEqualsClauseOn(columns.next(), pw);
            if (!columns.hasNext()) continue;
            pw.println();
            pw.print("&& ");
        }
        pw.print(';');
        pw.println();
        pw.undent();
        pw.undent();
        pw.print('}');
        pw.println();
        pw.println();
    }

    private void printEqualsClauseOn(Column column, EntitySourceWriter pw) {
        String fieldName = this.genTable.fieldNameFor(column);
        JavaType javaType = column.javaType();
        if (javaType.isPrimitive()) {
            this.printPrimitiveEqualsClauseOn(fieldName, pw);
        } else {
            this.printReferenceEqualsClauseOn(fieldName, pw);
        }
    }

    private void printPrimitiveEqualsClauseOn(String fieldName, EntitySourceWriter pw) {
        pw.print("(this.");
        pw.print(fieldName);
        pw.print(" == other.");
        pw.print(fieldName);
        pw.print(')');
    }

    private void printReferenceEqualsClauseOn(String fieldName, EntitySourceWriter pw) {
        pw.print("this.");
        pw.print(fieldName);
        pw.print(".equals(other.");
        pw.print(fieldName);
        pw.print(')');
    }

    private void printHashCodeMethodOn(Iterator<Column> columns, EntitySourceWriter pw) {
        pw.printAnnotation("java.lang.Override");
        pw.println();
        pw.println("public int hashCode() {");
        pw.indent();
        pw.print("return ");
        pw.indent();
        while (columns.hasNext()) {
            this.printHashCodeClauseOn(columns.next(), pw);
            if (!columns.hasNext()) continue;
            pw.println();
            pw.print("^ ");
        }
        pw.print(';');
        pw.println();
        pw.undent();
        pw.undent();
        pw.print('}');
        pw.println();
        pw.println();
    }

    private void printHashCodeClauseOn(Column column, EntitySourceWriter pw) {
        String fieldName = this.genTable.fieldNameFor(column);
        JavaType javaType = column.javaType();
        if (javaType.isPrimitive()) {
            this.printPrimitiveHashCodeClauseOn(javaType.getElementTypeName(), fieldName, pw);
        } else {
            this.printReferenceHashCodeClauseOn(fieldName, pw);
        }
    }

    private void printPrimitiveHashCodeClauseOn(String primitiveName, String fieldName, EntitySourceWriter pw) {
        if (primitiveName.equals("int") || primitiveName.equals("short") || primitiveName.equals("byte") || primitiveName.equals("char")) {
            pw.print("this.");
            pw.print(fieldName);
        } else if (primitiveName.equals("long")) {
            pw.print("((int) (this.");
            pw.print(fieldName);
            pw.print(" ^ (this.");
            pw.print(fieldName);
            pw.print(" >>> 32)))");
        } else if (primitiveName.equals("double")) {
            pw.print("((int) (");
            pw.printTypeDeclaration("java.lang.Double");
            pw.print(".doubleToLongBits(this.");
            pw.print(fieldName);
            pw.print(") ^ (");
            pw.printTypeDeclaration("java.lang.Double");
            pw.print(".doubleToLongBits(this.");
            pw.print(fieldName);
            pw.print(") >>> 32)))");
        } else if (primitiveName.equals("float")) {
            pw.printTypeDeclaration("java.lang.Float");
            pw.print(".floatToIntBits(this.");
            pw.print(fieldName);
            pw.print(')');
        } else if (primitiveName.equals("boolean")) {
            pw.print("(this.");
            pw.print(fieldName);
            pw.print(" ? 1231 : 1237)");
        } else {
            throw new IllegalArgumentException(primitiveName);
        }
    }

    private void printReferenceHashCodeClauseOn(String fieldName, EntitySourceWriter pw) {
        pw.print("this.");
        pw.print(fieldName);
        pw.print(".hashCode()");
    }

    private void printPackageAndImportsOn(PrintWriter pw, BodySource bodySource) {
        if (this.packageName().length() != 0) {
            pw.print("package ");
            pw.print(this.packageName());
            pw.print(';');
            pw.println();
            pw.println();
        }
        Iterator<Map.Entry<String, String>> stream = bodySource.importEntries();
        while (stream.hasNext()) {
            Map.Entry<String, String> entry = stream.next();
            pw.print("import ");
            pw.print(entry.getValue());
            pw.print('.');
            pw.print(entry.getKey());
            pw.print(';');
            pw.println();
        }
        pw.println();
    }

    private String packageName() {
        return this.packageFragment.getElementName();
    }

    private Table table() {
        return this.genTable.getTable();
    }

    private String entityName() {
        return this.genTable.getEntityName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface BodySource {
        public Iterator<Map.Entry<String, String>> importEntries();

        public String source();

        public int length();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Config {
        private boolean convertToCamelCase = true;
        private boolean propertyAccessType = false;
        private String collectionTypeName = Set.class.getName();
        private int fieldVisibility = 2;
        private int methodVisibility = 1;
        private boolean generateGettersAndSetters = true;
        private boolean generateDefaultConstructor = true;
        private boolean serializable = true;
        private boolean generateSerialVersionUID = true;
        private boolean generateEmbeddedIdForCompoundPK = true;
        private Map<Table, String> overrideEntityNames = new HashMap<Table, String>();
        public static final int PRIVATE = 0;
        public static final int PACKAGE = 1;
        public static final int PROTECTED = 2;
        public static final int PUBLIC = 3;

        public boolean convertToCamelCase() {
            return this.convertToCamelCase;
        }

        public void setConvertToCamelCase(boolean convertToCamelCase) {
            this.convertToCamelCase = convertToCamelCase;
        }

        public boolean propertyAccessType() {
            return this.propertyAccessType;
        }

        public void setPropertyAccessType(boolean propertyAccessType) {
            this.propertyAccessType = propertyAccessType;
        }

        public boolean fieldAccessType() {
            return !this.propertyAccessType;
        }

        public void setFieldAccessType(boolean fieldAccessType) {
            this.propertyAccessType = !fieldAccessType;
        }

        public String getCollectionTypeName() {
            return this.collectionTypeName;
        }

        public void setCollectionTypeName(String collectionTypeName) {
            this.collectionTypeName = collectionTypeName;
        }

        public int getFieldVisibility() {
            return this.fieldVisibility;
        }

        public void setFieldVisibility(int fieldVisibility) {
            switch (fieldVisibility) {
                case 0: 
                case 1: 
                case 2: {
                    this.fieldVisibility = fieldVisibility;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid field visibility: " + fieldVisibility);
                }
            }
        }

        String fieldVisibility() {
            switch (this.fieldVisibility) {
                case 0: {
                    return "private";
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return "protected";
                }
            }
            throw new IllegalStateException("invalid field visibility: " + this.fieldVisibility);
        }

        public int getMethodVisibility() {
            return this.methodVisibility;
        }

        public void setMethodVisibility(int methodVisibility) {
            switch (methodVisibility) {
                case 2: 
                case 3: {
                    this.methodVisibility = methodVisibility;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid method visibility: " + methodVisibility);
                }
            }
        }

        String methodVisibility() {
            switch (this.methodVisibility) {
                case 2: {
                    return "protected";
                }
                case 3: {
                    return "public";
                }
            }
            throw new IllegalStateException("invalid method visibility: " + this.methodVisibility);
        }

        public boolean generateGettersAndSetters() {
            return this.generateGettersAndSetters;
        }

        public void setGenerateGettersAndSetters(boolean generateGettersAndSetters) {
            this.generateGettersAndSetters = generateGettersAndSetters;
        }

        public boolean generateDefaultConstructor() {
            return this.generateDefaultConstructor;
        }

        public void setGenerateDefaultConstructor(boolean generateDefaultConstructor) {
            this.generateDefaultConstructor = generateDefaultConstructor;
        }

        public boolean serializable() {
            return this.serializable;
        }

        public void setSerializable(boolean serializable) {
            this.serializable = serializable;
        }

        public boolean generateSerialVersionUID() {
            return this.generateSerialVersionUID;
        }

        public void setGenerateSerialVersionUID(boolean generateSerialVersionUID) {
            this.generateSerialVersionUID = generateSerialVersionUID;
        }

        public boolean generateEmbeddedIdForCompoundPK() {
            return this.generateEmbeddedIdForCompoundPK;
        }

        public void setGenerateEmbeddedIdForCompoundPK(boolean generateEmbeddedIdForCompoundPK) {
            this.generateEmbeddedIdForCompoundPK = generateEmbeddedIdForCompoundPK;
        }

        public boolean generateIdClassForCompoundPK() {
            return !this.generateEmbeddedIdForCompoundPK;
        }

        public void setGenerateIdClassForCompoundPK(boolean generateIdClassForCompoundPK) {
            this.generateEmbeddedIdForCompoundPK = !generateIdClassForCompoundPK;
        }

        public String getOverrideEntityName(Table table) {
            return this.overrideEntityNames.get(table);
        }

        public void setOverrideEntityName(Table table, String overrideEntityName) {
            this.overrideEntityNames.put(table, overrideEntityName);
        }

        public void clearOverrideEntityNames() {
            this.overrideEntityNames.clear();
        }

        public void setOverrideEntityNames(Map<Table, String> overrideEntityNames) {
            this.clearOverrideEntityNames();
            for (Map.Entry<Table, String> entry : overrideEntityNames.entrySet()) {
                this.setOverrideEntityName(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntitySourceWriter
    extends IndentingPrintWriter
    implements BodySource {
        final String packageName;
        final String entityClassName;
        private final Map<String, String> imports = new HashMap<String, String>();

        EntitySourceWriter(String packageName, String entityClassName) {
            super((Writer)new StringWriter(20000));
            this.packageName = packageName;
            this.entityClassName = entityClassName;
        }

        void printVisibility(String visibilityModifier) {
            if (visibilityModifier.length() != 0) {
                this.print(visibilityModifier);
                this.print(' ');
            }
        }

        void printAnnotation(String annotationName) {
            this.print('@');
            this.printTypeDeclaration(annotationName);
        }

        void printTypeDeclaration(String typeDeclaration) {
            this.print(this.importedTypeDeclaration(typeDeclaration));
        }

        private String importedTypeDeclaration(String typeDeclaration) {
            String shortTypeDeclaration;
            if (this.typeDeclarationIsMemberClass(typeDeclaration)) {
                return this.memberClassTypeDeclaration(typeDeclaration);
            }
            int last = typeDeclaration.lastIndexOf(46);
            String pkg = last == -1 ? "" : typeDeclaration.substring(0, last);
            String shortElementTypeName = shortTypeDeclaration = typeDeclaration.substring(last + 1);
            while (shortElementTypeName.endsWith("[]")) {
                shortElementTypeName = shortElementTypeName.substring(0, shortElementTypeName.length() - 2);
            }
            String prev = this.imports.get(shortElementTypeName);
            if (prev == null) {
                this.imports.put(shortElementTypeName, pkg);
                return shortTypeDeclaration;
            }
            if (prev.equals(pkg)) {
                return shortTypeDeclaration;
            }
            return typeDeclaration;
        }

        private boolean typeDeclarationIsMemberClass(String typeDeclaration) {
            return typeDeclaration.length() > this.entityClassName.length() && typeDeclaration.startsWith(this.entityClassName) && typeDeclaration.charAt(this.entityClassName.length()) == '.';
        }

        private String memberClassTypeDeclaration(String typeDeclaration) {
            int index = this.packageName.length();
            if (index != 0) {
                ++index;
            }
            return typeDeclaration.substring(index);
        }

        @Override
        public Iterator<Map.Entry<String, String>> importEntries() {
            return new FilteringIterator<Map.Entry<String, String>>(this.sortedImportEntries()){

                protected boolean accept(Object next) {
                    String pkg = (String)((Map.Entry)next).getValue();
                    return !pkg.equals("") && !pkg.equals("java.lang") && !pkg.equals(EntitySourceWriter.this.packageName);
                }
            };
        }

        private Iterator<Map.Entry<String, String>> sortedImportEntries() {
            TreeSet<Map.Entry<String, String>> sortedImports = new TreeSet<Map.Entry<String, String>>(this.buildImportEntriesComparator());
            sortedImports.addAll((Collection<Map.Entry<String, String>>)this.imports.entrySet());
            return sortedImports.iterator();
        }

        private Comparator<Map.Entry<String, String>> buildImportEntriesComparator() {
            return new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
                    Collator collator = Collator.getInstance();
                    int pkg = collator.compare(e1.getValue(), e2.getValue());
                    return pkg == 0 ? collator.compare(e1.getKey(), e2.getKey()) : pkg;
                }
            };
        }

        void printGetterAndSetter(String propertyName, String typeDeclaration, String visibility) {
            this.printGetter(propertyName, typeDeclaration, visibility);
            this.println();
            this.println();
            this.printSetter(propertyName, typeDeclaration, visibility);
            this.println();
            this.println();
        }

        private void printGetter(String propertyName, String typeDeclaration, String visibility) {
            this.printVisibility(visibility);
            this.printTypeDeclaration(typeDeclaration);
            this.print(' ');
            this.print(typeDeclaration.equals("boolean") ? "is" : "get");
            this.print(StringTools.capitalize((String)propertyName));
            this.print("() {");
            this.println();
            this.indent();
            this.print("return this.");
            this.print(propertyName);
            this.print(';');
            this.println();
            this.undent();
            this.print('}');
        }

        private void printSetter(String propertyName, String typeDeclaration, String visibility) {
            this.printVisibility(visibility);
            this.print("void set");
            this.print(StringTools.capitalize((String)propertyName));
            this.print('(');
            this.printTypeDeclaration(typeDeclaration);
            this.print(' ');
            this.print(propertyName);
            this.print(") {");
            this.println();
            this.indent();
            this.print("this.");
            this.print(propertyName);
            this.print(" = ");
            this.print(propertyName);
            this.print(';');
            this.println();
            this.undent();
            this.print('}');
        }

        void printCollectionGetterAndSetter(String propertyName, String collectionTypeDeclaration, String elementTypeDeclaration, String visibility) {
            this.printCollectionGetter(propertyName, collectionTypeDeclaration, elementTypeDeclaration, visibility);
            this.println();
            this.println();
            this.printCollectionSetter(propertyName, collectionTypeDeclaration, elementTypeDeclaration, visibility);
            this.println();
            this.println();
        }

        private void printCollectionGetter(String propertyName, String collectionTypeDeclaration, String elementTypeDeclaration, String visibility) {
            this.printVisibility(visibility);
            this.printTypeDeclaration(collectionTypeDeclaration);
            this.print('<');
            this.printTypeDeclaration(elementTypeDeclaration);
            this.print("> get");
            this.print(StringTools.capitalize((String)propertyName));
            this.print("() {");
            this.println();
            this.indent();
            this.print("return this.");
            this.print(propertyName);
            this.print(';');
            this.println();
            this.undent();
            this.print('}');
        }

        private void printCollectionSetter(String propertyName, String collectionTypeDeclaration, String elementTypeDeclaration, String visibility) {
            this.printVisibility(visibility);
            this.print("void set");
            this.print(StringTools.capitalize((String)propertyName));
            this.print('(');
            this.printTypeDeclaration(collectionTypeDeclaration);
            this.print('<');
            this.printTypeDeclaration(elementTypeDeclaration);
            this.print('>');
            this.print(' ');
            this.print(propertyName);
            this.print(") {");
            this.println();
            this.indent();
            this.print("this.");
            this.print(propertyName);
            this.print(" = ");
            this.print(propertyName);
            this.print(';');
            this.println();
            this.undent();
            this.print('}');
        }

        @Override
        public String source() {
            return this.out.toString();
        }

        @Override
        public int length() {
            return ((StringWriter)this.out).getBuffer().length();
        }
    }

    public static interface OverwriteConfirmer {
        public boolean overwrite(String var1);
    }
}

