/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.encoding.JSPDocumentLoader;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.wst.sse.core.internal.encoding.ContentBasedPreferenceGateway;
import org.eclipse.wst.sse.core.internal.encoding.ContentTypeEncodingPreferences;
import org.eclipse.wst.sse.core.internal.provisional.document.IEncodedDocument;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.prefs.Preferences;

public class JSPCorePreferencesTest
extends TestCase {
    public void testBundleGetPreferences() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.jst.jsp.core");
        try {
            if (bundle != null) {
                bundle.start();
            } else {
                JSPCorePreferencesTest.fail((String)"Get preference value failed because could not find bundle: org.eclipse.jst.jsp.core");
            }
        }
        catch (BundleException e) {
            JSPCorePreferencesTest.fail((String)("Get preference value failed because of exception starting bundle: org.eclipse.jst.jsp.core exception: " + (Object)((Object)e)));
        }
        this.bundleGetPreference("org.eclipse.jst.jsp.core", "defaultExtension");
    }

    private void bundleGetPreference(String bundleName, String prefKey) {
        String defaultValue = null;
        String value = Platform.getPreferencesService().getString(bundleName, prefKey, defaultValue, null);
        JSPCorePreferencesTest.assertTrue((String)("Get preference value failed using Platform.getPreferencesService. Key: " + prefKey), (defaultValue != value ? 1 : 0) != 0);
    }

    public void testPluginGetDefaultPreferences() {
        IEclipsePreferences node = new DefaultScope().getNode(JSPCorePlugin.getDefault().getBundle().getSymbolicName());
        this.pluginGetDefaultPreference(node, "validateFragments", Boolean.toString(true));
    }

    private void pluginGetDefaultPreference(IEclipsePreferences node, String prefKey, String expected) {
        String defaultValue = Long.toString(System.currentTimeMillis());
        String theDefaultValue = node.get(prefKey, defaultValue);
        JSPCorePreferencesTest.assertEquals((String)("Get default preference value failed using plugin.getPreferenceStore. Key: " + prefKey), (String)expected, (String)theDefaultValue);
    }

    public void testPluginSetPreferences() {
        IEclipsePreferences node = new InstanceScope().getNode(JSPCorePlugin.getDefault().getBundle().getSymbolicName());
        this.pluginSetPreferenceBoolean(node, "validateFragments");
    }

    private void pluginSetPreferenceBoolean(IEclipsePreferences node, String prefKey) {
        boolean originalValue = false;
        boolean expectedValue = true;
        String originalString = node.get(prefKey, "bogus");
        if (!"bogus".equals(originalString)) {
            originalValue = Boolean.valueOf(originalString);
            expectedValue = !originalValue;
        }
        node.putBoolean(prefKey, expectedValue);
        boolean foundValue = node.getBoolean(prefKey, true);
        JSPCorePreferencesTest.assertEquals((String)("Set preference value failed using plugin.getPreferenceStore. Key: " + prefKey + "  expected: " + expectedValue + " found: " + foundValue), (boolean)expectedValue, (boolean)foundValue);
        if ("bogus".equals(originalString)) {
            node.remove(prefKey);
        } else {
            node.put(prefKey, originalString);
        }
    }

    public void testDelimiterPreferences() {
        String preferredDelimiter = ContentTypeEncodingPreferences.getPreferredNewLineDelimiter((String)ContentTypeIdForJSP.ContentTypeID_JSP);
        Preferences prefs = ContentBasedPreferenceGateway.getPreferences((String)ContentTypeIdForJSP.ContentTypeID_JSP);
        String gatewayDelimiter = prefs.get("endOfLineCode", null);
        JSPCorePreferencesTest.assertEquals((String)"ContentTypeEncodingPreferences and ContentBasedPreferenceGateway preferences do not match", (String)gatewayDelimiter, (String)preferredDelimiter);
        prefs.put("endOfLineCode", "EOL_Unix");
        JSPDocumentLoader loader = new JSPDocumentLoader();
        IEncodedDocument document = loader.createNewStructuredDocument();
        String documentDelimiter = document.getPreferredLineDelimiter();
        JSPCorePreferencesTest.assertEquals((String)"Delimiter in document does not match preference", (String)"\n", (String)documentDelimiter);
        prefs.remove("endOfLineCode");
    }
}

