/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.validation;

import junit.framework.TestCase;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.internal.validation.JSPActionValidator;
import org.eclipse.jst.jsp.core.tests.taglibindex.BundleResourceUtil;
import org.eclipse.jst.jsp.core.tests.validation.ReporterForTest;
import org.eclipse.jst.jsp.core.tests.validation.ValidationContextForTest;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public class JSPActionValidatorTest
extends TestCase {
    String wtp_autotest_noninteractive = null;
    private static final String PROJECT_NAME = "testvalidatejspactions";

    protected void setUp() throws Exception {
        super.setUp();
        String noninteractive = System.getProperty("wtp.autotest.noninteractive");
        if (noninteractive != null) {
            this.wtp_autotest_noninteractive = noninteractive;
        }
        System.setProperty("wtp.autotest.noninteractive", "true");
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists()) {
            BundleResourceUtil.createSimpleProject(PROJECT_NAME, null, new String[]{"org.eclipse.jdt.core.javanature"});
            BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/testvalidatejspactions", "/testvalidatejspactions");
        }
        JSPActionValidatorTest.assertTrue((String)"project could not be created", (boolean)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.wtp_autotest_noninteractive != null) {
            System.setProperty("wtp.autotest.noninteractive", this.wtp_autotest_noninteractive);
        }
    }

    public void testUknownAttribute() throws Exception {
        JSPActionValidator validator = new JSPActionValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/testvalidatejspactions/WebContent/undefinedattribute.jsp";
        JSPActionValidatorTest.assertTrue((String)("unable to find file: " + filePath), (boolean)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath)).exists());
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPActionValidatorTest.assertTrue((String)"jsp action validator did not detect undefined attributes", (reporter.getMessages().size() == 3 ? 1 : 0) != 0);
    }

    public void testMissingRequiredAttribute() throws Exception {
        JSPActionValidator validator = new JSPActionValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/testvalidatejspactions/WebContent/norequiredattribute.jsp";
        JSPActionValidatorTest.assertTrue((String)("unable to find file: " + filePath), (boolean)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath)).exists());
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPActionValidatorTest.assertTrue((String)"jsp action validator did not detect missing required attributes", (reporter.getMessages().size() == 2 ? 1 : 0) != 0);
    }

    public void testAttributesCorrect() throws Exception {
        JSPActionValidator validator = new JSPActionValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/testvalidatejspactions/WebContent/worksfine.jsp";
        JSPActionValidatorTest.assertTrue((String)("unable to find file: " + filePath), (boolean)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath)).exists());
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPActionValidatorTest.assertTrue((String)"jsp action validator found errors when it should not have", (boolean)reporter.getMessages().isEmpty());
    }
}

