/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsp.ui.tests.JSPUITestsPlugin;

public class ProjectUtil {
    public static final String JAVA_NATURE_ID = "org.eclipse.jdt.core.javanature";

    public static void addLibraryEntry(IProject proj, String pathToJar) {
        IPath projLocation = proj.getLocation();
        IPath absJarPath = projLocation.append(pathToJar);
        IJavaProject jProj = JavaCore.create((IProject)proj);
        IClasspathEntry strutsJarEntry = JavaCore.newLibraryEntry((IPath)absJarPath, null, null);
        try {
            IClasspathEntry[] currentEntries = jProj.getRawClasspath();
            ArrayList<IClasspathEntry> l = new ArrayList<IClasspathEntry>();
            l.addAll(Arrays.asList(currentEntries));
            l.add(strutsJarEntry);
            IClasspathEntry[] newEntries = l.toArray(new IClasspathEntry[l.size()]);
            jProj.setRawClasspath(newEntries, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    static void _copyBundleEntriesIntoWorkspace(String rootEntry, String fullTargetPath) throws CoreException {
        Enumeration entries = JSPUITestsPlugin.getDefault().getBundle().getEntryPaths(rootEntry);
        while (entries != null && entries.hasMoreElements()) {
            String entryPath = entries.nextElement().toString();
            String targetPath = new Path(String.valueOf(fullTargetPath) + "/" + entryPath.substring(rootEntry.length())).toString();
            if (entryPath.endsWith("/")) {
                IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(targetPath));
                if (!folder.exists()) {
                    folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                ProjectUtil._copyBundleEntriesIntoWorkspace(entryPath, targetPath);
                continue;
            }
            ProjectUtil._copyBundleEntryIntoWorkspace(entryPath, targetPath);
        }
    }

    static IFile _copyBundleEntryIntoWorkspace(String entryname, String fullPath) throws CoreException {
        IFile file = null;
        URL entry = JSPUITestsPlugin.getDefault().getBundle().getEntry(entryname);
        if (entry != null) {
            try {
                byte[] b = new byte[2048];
                InputStream input = entry.openStream();
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                int i = -1;
                while ((i = input.read(b)) > -1) {
                    output.write(b, 0, i);
                }
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fullPath));
                if (file != null) {
                    if (!file.exists()) {
                        file.create((InputStream)new ByteArrayInputStream(output.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
                    } else {
                        file.setContents((InputStream)new ByteArrayInputStream(output.toByteArray()), true, false, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static void copyBundleEntriesIntoWorkspace(final String rootEntry, final String fullTargetPath) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ProjectUtil._copyBundleEntriesIntoWorkspace(rootEntry, fullTargetPath);
                ResourcesPlugin.getWorkspace().checkpoint(true);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static IFile copyBundleEntryIntoWorkspace(final String entryname, final String fullPath) {
        final IFile[] file = new IFile[1];
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                file[0] = ProjectUtil._copyBundleEntryIntoWorkspace(entryname, fullPath);
                ResourcesPlugin.getWorkspace().checkpoint(true);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return file[0];
    }

    public static IProject createProject(String name, IPath location, String[] natureIds) {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        if (location != null) {
            description.setLocation(location);
        }
        if (natureIds != null) {
            description.setNatureIds(natureIds);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return project;
    }
}

