/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.validation;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsf.validation.internal.IJSPSemanticValidatorTest;
import org.eclipse.jst.jsf.validation.internal.JSPSemanticsValidator;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestJSPSemanticsValidator
extends TestCase {
    private WebProjectTestEnvironment _testEnv;
    private IFile _jspFile;
    private IFile _jspFragmentFile;
    private IStructuredModel _jspStructuredModel;
    private IStructuredDocument _jspStructuredDocument;
    private IStructuredModel _jspFragStructuredModel;
    private IStructuredDocument _jspFragStructuredDocument;

    protected void setUp() throws Exception {
        super.setUp();
        this._testEnv = new WebProjectTestEnvironment("ContainmentValidationTest" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName());
        this._testEnv.createProject(false);
        TestJSPSemanticsValidator.assertNotNull((Object)this._testEnv);
        TestJSPSemanticsValidator.assertNotNull((Object)this._testEnv.getTestProject());
        TestJSPSemanticsValidator.assertTrue((boolean)this._testEnv.getTestProject().isAccessible());
        this._testEnv.loadResourceInWebRoot(TestsPlugin.getDefault().getBundle(), "/testfiles/jsf-core.tld.data", "META-INF/jsf-core.tld");
        this._jspFile = (IFile)this._testEnv.loadResourceInWebRoot(TestsPlugin.getDefault().getBundle(), "/testfiles/jsps/testContainment.jsp.data", "testContainment.jsp");
        this._jspStructuredModel = StructuredModelManager.getModelManager().getModelForRead(this._jspFile);
        this._jspStructuredDocument = this._jspStructuredModel.getStructuredDocument();
        this._jspFragmentFile = (IFile)this._testEnv.loadResourceInWebRoot(TestsPlugin.getDefault().getBundle(), "/testfiles/jsps/testContainment.jsp.data", "testContainment.jsf");
        this._jspFragStructuredModel = StructuredModelManager.getModelManager().getModelForRead(this._jspFile);
        this._jspFragStructuredDocument = this._jspFragStructuredModel.getStructuredDocument();
        JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this._testEnv);
        jsfFacedEnv.initialize("1.1");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this._jspStructuredModel != null) {
            this._jspStructuredModel.releaseFromRead();
        }
        if (this._jspFragStructuredModel != null) {
            this._jspFragStructuredModel.releaseFromRead();
        }
    }

    public void testContainmentInJSP() {
        IJSPSemanticValidatorTest validator = new JSPSemanticsValidator().getTestInterface();
        IStructuredDocumentContext correctlyNested = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._jspStructuredDocument, 487);
        IStructuredDocumentContext firstIncorrectlyNested = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._jspStructuredDocument, 538);
        IStructuredDocumentContext secondIncorrectlyNested = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._jspStructuredDocument, 568);
        this.checkTag(correctlyNested, validator, this._jspFile, 0);
        this.checkTag(firstIncorrectlyNested, validator, this._jspFile, 1);
        this.checkTag(secondIncorrectlyNested, validator, this._jspFile, 0);
    }

    public void testContainmentInJSPFrag() {
        IJSPSemanticValidatorTest validator = new JSPSemanticsValidator().getTestInterface();
        IStructuredDocumentContext correctlyNested = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._jspFragStructuredDocument, 487);
        IStructuredDocumentContext firstIncorrectlyNested = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._jspFragStructuredDocument, 538);
        IStructuredDocumentContext secondIncorrectlyNested = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._jspFragStructuredDocument, 568);
        this.checkTag(correctlyNested, validator, this._jspFragmentFile, 0);
        this.checkTag(firstIncorrectlyNested, validator, this._jspFragmentFile, 0);
        this.checkTag(secondIncorrectlyNested, validator, this._jspFragmentFile, 0);
    }

    private void checkTag(IStructuredDocumentContext context, IJSPSemanticValidatorTest validator, IFile file, int expectedCount) {
        IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
        Node node = resolver.getNode();
        TestJSPSemanticsValidator.assertTrue((boolean)(node instanceof Element));
        Element elem = (Element)node;
        TestJSPSemanticsValidator.assertEquals((String)"inputText", (String)elem.getLocalName());
        MyReporter reporter = new MyReporter();
        validator.validateContainment(elem, "http://java.sun.com/jsf/html", "inputText", (IReporter)reporter, file, context);
        TestJSPSemanticsValidator.assertEquals((int)expectedCount, (int)reporter.getMessages().size());
    }

    private class MyReporter
    implements IReporter {
        List<IMessage> messages = new ArrayList<IMessage>();

        private MyReporter() {
        }

        public void addMessage(IValidator origin, IMessage message) {
            this.messages.add(message);
        }

        public void displaySubtask(IValidator validator, IMessage message) {
            throw new UnsupportedOperationException("This reporter is for specific test purposes only");
        }

        public List getMessages() {
            return this.messages;
        }

        public boolean isCancelled() {
            return false;
        }

        public void removeAllMessages(IValidator origin) {
            throw new UnsupportedOperationException("This reporter is for specific test purposes only");
        }

        public void removeAllMessages(IValidator origin, Object object) {
            throw new UnsupportedOperationException("This reporter is for specific test purposes only");
        }

        public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
            throw new UnsupportedOperationException("This reporter is for specific test purposes only");
        }
    }
}

