/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.appclient.operations;

import junit.framework.Assert;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.project.facet.IAppClientFacetInstallDataModelProperties;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.tests.SimpleTestSuite;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleProjectCreationOperationTest;

public class AppClientProjectCreationOperationTest
extends ModuleProjectCreationOperationTest {
    public static String DEFAULT_PROJECT_NAME = "SimpleAppClient";

    public AppClientProjectCreationOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new SimpleTestSuite(AppClientProjectCreationOperationTest.class);
    }

    public IDataModel getComponentCreationDataModel() {
        return DataModelFactory.createDataModel(IAppClientFacetInstallDataModelProperties.class);
    }

    public IDataModel getComponentCreationDataModelWithEar() {
        IDataModel model = this.getComponentCreationDataModel();
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetDM = map.getFacetDataModel("jst.appclient");
        facetDM.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", true);
        return model;
    }

    public void testUsingPublicAPI() throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel(IAppClientFacetInstallDataModelProperties.class);
        String projName = "TestAPIAppClientProject";
        String appVersionString = J2EEVersionUtil.convertVersionIntToString((int)14);
        IProjectFacet appFacet = ProjectFacetsManager.getProjectFacet((String)"jst.appclient");
        IProjectFacetVersion appFacetVersion = appFacet.getVersion(appVersionString);
        this.addAppProjectProperties(dataModel, projName, appFacetVersion);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        this.validateAppProjectProperties(projName, appFacetVersion);
        this.validateAppDescriptorProperties(projName);
    }

    public void testUsingPublicAPIApp50() throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel(IAppClientFacetInstallDataModelProperties.class);
        String projName = "TestAPIAppClientProject";
        String appVersionString = J2EEVersionUtil.convertVersionIntToString((int)50);
        IProjectFacet appFacet = ProjectFacetsManager.getProjectFacet((String)"jst.appclient");
        IProjectFacetVersion appFacetVersion = appFacet.getVersion(appVersionString);
        this.addAppProjectProperties(dataModel, projName, appFacetVersion);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        this.validateAppProjectProperties(projName, appFacetVersion);
    }

    public void testUsingPublicAPIApp50WithAddToEar() throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel(IAppClientFacetInstallDataModelProperties.class);
        String projName = "TestAPIAppClientProject";
        String appVersionString = J2EEVersionUtil.convertVersionIntToString((int)50);
        IProjectFacet appFacet = ProjectFacetsManager.getProjectFacet((String)"jst.appclient");
        IProjectFacetVersion appFacetVersion = appFacet.getVersion(appVersionString);
        this.addAppProjectProperties(dataModel, projName, appFacetVersion);
        String earProjName = String.valueOf(projName) + "EAR";
        this.addEARProperties(dataModel, earProjName);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        this.validateAppProjectProperties(projName, appFacetVersion);
        this.validateEARProjectProperties(earProjName, appVersionString);
    }

    private void addEARProperties(IDataModel dataModel, String earProjName) {
        dataModel.setBooleanProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", true);
        dataModel.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)earProjName);
    }

    private void validateEARProjectProperties(String earProjName, String earFacetVersionString) throws CoreException {
        IProject earProj = ResourcesPlugin.getWorkspace().getRoot().getProject(earProjName);
        Assert.assertTrue((boolean)earProj.exists());
        IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProj);
        Assert.assertNotNull((Object)earComponent);
        if (earComponent != null) {
            Assert.assertNotNull((Object)earComponent.getName());
        }
        IVirtualReference[] references = earComponent.getReferences();
        Assert.assertNotNull((Object)references);
        IProjectFacet earFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
        IProjectFacetVersion earFacetVersion = earFacet.getVersion(earFacetVersionString);
        IFacetedProject facetedEARProject = ProjectFacetsManager.create((IProject)earProj);
        Assert.assertTrue((boolean)facetedEARProject.hasProjectFacet(earFacetVersion));
    }

    private void validateAppDescriptorProperties(String projName) {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        IVirtualComponent component = ComponentCore.createComponent((IProject)proj);
        IFile deploymentDescriptorFile = component.getRootFolder().getFile("META-INF/application-client.xml").getUnderlyingFile();
        Assert.assertTrue((boolean)deploymentDescriptorFile.exists());
        AppClientArtifactEdit appClient = AppClientArtifactEdit.getAppClientArtifactEditForRead((IProject)proj);
        Assert.assertNotNull((Object)appClient);
        if (appClient != null) {
            Assert.assertNotNull((Object)appClient.getApplicationClient());
        }
    }

    private void validateAppProjectProperties(String projName, IProjectFacetVersion appFacetVersion) throws CoreException {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        Assert.assertTrue((boolean)proj.exists());
        IVirtualComponent component = ComponentCore.createComponent((IProject)proj);
        Assert.assertNotNull((Object)component);
        if (component != null) {
            Assert.assertNotNull((Object)component.getName());
        }
        Assert.assertTrue((boolean)proj.exists((IPath)new Path("/appcc333")));
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)proj);
        Assert.assertTrue((boolean)facetedProject.hasProjectFacet(appFacetVersion));
    }

    private void addAppProjectProperties(IDataModel dataModel, String projName, IProjectFacetVersion appFacetVersion) {
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel appmodel = (IDataModel)map.get((Object)"jst.appclient");
        appmodel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)appFacetVersion);
        appmodel.setStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", "appcc333");
    }
}

