/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.ear.operations;

import junit.framework.Assert;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.earcreation.IEarFacetInstallDataModelProperties;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wst.common.tests.SimpleTestSuite;

public class EARProjectCreationOperationTest
extends OperationTestCase {
    public EARProjectCreationOperationTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new SimpleTestSuite(EARProjectCreationOperationTest.class);
    }

    public void testUsingPublicAPI() throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel(IEarFacetInstallDataModelProperties.class);
        String projName = "TestAPIEarProject";
        String appVersionString = J2EEVersionUtil.convertVersionIntToString((int)14);
        IProjectFacet earFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
        IProjectFacetVersion earFacetVersion = earFacet.getVersion(appVersionString);
        this.addEarProjectProperties(dataModel, projName, earFacetVersion);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        this.validateEarProjectProperties(projName, earFacetVersion);
        this.validateEarDescriptorProperties(projName);
    }

    public void testUsingPublicAPIEar50() throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel(IEarFacetInstallDataModelProperties.class);
        String projName = "TestAPIEarProject";
        String appVersionString = J2EEVersionUtil.convertVersionIntToString((int)50);
        IProjectFacet earFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
        IProjectFacetVersion earFacetVersion = earFacet.getVersion(appVersionString);
        this.addEarProjectProperties(dataModel, projName, earFacetVersion);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        this.validateEarProjectProperties(projName, earFacetVersion);
    }

    private void validateEarDescriptorProperties(String projName) {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        IVirtualComponent component = ComponentCore.createComponent((IProject)proj);
        IFile deploymentDescriptorFile = component.getRootFolder().getFile("META-INF/application.xml").getUnderlyingFile();
        Assert.assertTrue((boolean)deploymentDescriptorFile.exists());
        EARArtifactEdit ear = EARArtifactEdit.getEARArtifactEditForRead((IProject)proj);
        Assert.assertNotNull((Object)ear);
        if (ear != null) {
            Assert.assertNotNull((Object)ear.getApplication());
        }
    }

    private void validateEarProjectProperties(String projName, IProjectFacetVersion earFacetVersion) throws CoreException {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        Assert.assertTrue((boolean)proj.exists());
        IVirtualComponent component = ComponentCore.createComponent((IProject)proj);
        Assert.assertNotNull((Object)component);
        if (component != null) {
            Assert.assertNotNull((Object)component.getName());
        }
        Assert.assertTrue((boolean)proj.exists((IPath)new Path("/ear333")));
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)proj);
        Assert.assertTrue((boolean)facetedProject.hasProjectFacet(earFacetVersion));
    }

    private void addEarProjectProperties(IDataModel dataModel, String projName, IProjectFacetVersion earFacetVersion) {
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel earmodel = (IDataModel)map.get((Object)"jst.ear");
        earmodel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)earFacetVersion);
        earmodel.setStringProperty("IEarFacetInstallDataModelProperties.CONTENT_DIR", "ear333");
    }
}

