/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.web.operations;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wtp.headless.tests.savestrategy.ModuleImportOperationTestCase;
import org.eclipse.wtp.headless.tests.savestrategy.WebImportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleExportOperationTestCase;

public class WebExportOperationTest
extends ModuleExportOperationTestCase {
    protected boolean excludeCompileJsp = false;

    public WebExportOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(WebExportOperationTest.class);
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.excludeCompileJsp = false;
    }

    public void testExcludeCompileJspOn() throws Exception {
        this.excludeCompileJsp = true;
        this.testAllExportTestCases();
    }

    protected IDataModel getModelInstance() {
        return DataModelFactory.createDataModel((IDataModelProvider)new WebComponentExportDataModelProvider());
    }

    protected ModuleImportOperationTestCase getImportTestCase() {
        return new WebImportOperationTest("");
    }

    protected IProject[] getExportableProjects() throws Exception {
        IProject[] projs = super.getExportableProjects();
        ArrayList<IProject> filteredProjs = new ArrayList<IProject>();
        int i = 0;
        while (i < projs.length) {
            IProject project = projs[i];
            IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
            if (J2EEProjectUtilities.isDynamicWebProject((IProject)comp.getProject())) {
                filteredProjs.add(project);
            }
            ++i;
        }
        return filteredProjs.toArray(new IProject[filteredProjs.size()]);
    }

    public String getModuleExportFileExt() {
        return ".war";
    }

    public void testExport(IVirtualComponent component, String filename) throws Exception {
        super.testExport(component, filename);
        this.testDDExported(component);
    }

    protected void testDDExported(IVirtualComponent component) throws Exception {
        block7: {
            WebArtifactEdit webEdit = null;
            WARFile warFile = null;
            try {
                webEdit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)component);
                if (webEdit == null) break block7;
                warFile = (WARFile)webEdit.asArchive(true);
                Resource res = warFile.getDeploymentDescriptorResource();
                WebExportOperationTest.assertNotNull((Object)res);
            }
            finally {
                if (webEdit != null) {
                    webEdit.dispose();
                }
                if (warFile != null) {
                    warFile.close();
                }
            }
        }
    }
}

