/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.emftests;

import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.ApplicationPackage;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFEditingTest;
import org.eclipse.jst.j2ee.archive.testutilities.EMFAttributeFeatureGenerator;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.SecurityIdentity;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.RoleSource;
import org.eclipse.jst.j2ee.ejb.internal.impl.MethodPermissionImpl;
import org.eclipse.jst.j2ee.ejb.internal.impl.QueryMethodImpl;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;
import org.eclipse.wst.common.internal.emf.resource.EMF2SAXRendererFactory;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;

public class EjbEMFEditTest
extends GeneralEMFEditingTest {
    protected static final EjbPackage EJB_PKG = EjbPackage.eINSTANCE;
    EARFile earFile;
    EJBJarFile ejbFile;
    EObject mesBean;
    EObject entityBean;
    SecurityIdentity secID;
    RoleSource roleSource;
    int NUM_BEANS = 10;
    final int NUM_RELATION_ROLES = 2;
    int createdBeans = 0;
    int createdSecRoles = 0;
    protected int createdSecurityIdentities = 0;
    boolean mpFlag = false;
    static /* synthetic */ Class class$0;

    public EjbEMFEditTest(String name) {
        super(name);
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    public EjbFactory getEjbFactory() {
        return EjbPackage.eINSTANCE.getEjbFactory();
    }

    public ApplicationFactory getApplicationFactory() {
        return ApplicationPackage.eINSTANCE.getApplicationFactory();
    }

    public WebapplicationFactory getWebAppFactory() {
        return WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
    }

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.archive.emftests.EjbEMFEditTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new EjbEMFEditTest("testEJBJarEdit"));
        suite.addTest((Test)new EjbEMFEditTest("testWCCMJar"));
        return suite;
    }

    public void testEJBJarEdit() throws Exception {
        this.getEJB();
        EjbEMFEditTest.assertEquals((String)"2.0", (String)this.ejbFile.getDeploymentDescriptor().getVersion());
        EJBResource DD = (EJBResource)this.ejbFile.getDeploymentDescriptorResource();
        this.setVersion(1);
        this.setModuleType(3);
        this.editRoot(DD.getRootObject());
        String curDir = AutomatedBVT.baseDirectory;
        String out = String.valueOf(curDir) + "testOutput/EMFModelCreationTests/EditEjbEAR";
        this.ejbFile.extractTo(out, 126);
        this.ejbFile.close();
        if (RendererFactory.getDefaultRendererFactory() instanceof EMF2SAXRendererFactory) {
            String cfr_ignored_0 = String.valueOf(curDir) + "EMFTests/ejb-jar2-0sax.xml";
        } else {
            String cfr_ignored_1 = String.valueOf(curDir) + "EMFTests/ejb-jar2-0.xml";
        }
        String cfr_ignored_2 = String.valueOf(out) + "/META-INF/ejb-jar.xml";
    }

    public void testWCCMJar() throws Exception {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "../testData/ejb";
        ArchiveOptions options = new ArchiveOptions();
        options.setIsReadOnly(true);
        this.ejbFile = this.getArchiveFactory().openEJBJarFile(options, in);
        EJBResource DD = (EJBResource)this.ejbFile.getDeploymentDescriptorResource();
        DD.getRootObject();
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "../testData/testOutput";
        this.ejbFile.extractTo(out, 126);
        this.ejbFile.close();
        String exampleDeploymentDesURI = String.valueOf(in) + "/META-INF/ejb-jar.xml";
        String curDeploymentDesURI = String.valueOf(out) + "/META-INF/ejb-jar.xml";
        this.compareContents(curDeploymentDesURI, exampleDeploymentDesURI);
    }

    public void getEJB() throws DuplicateObjectException, OpenFailureException {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "loose_module_workspace/LooseEAREjb/ejbModule/";
        this.ejbFile = this.getArchiveFactory().openEJBJarFile(in);
        EjbEMFEditTest.assertTrue((this.ejbFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public EObject createInstance(EClass eClassifier) {
        if (eClassifier.getName().equals("EnterpriseBean")) {
            ++this.createdBeans;
            switch (this.createdBeans) {
                case 3: {
                    return this.createContainerManagedEntityInstance(eClassifier);
                }
                case 7: {
                    return this.createMessageBeanInstance(eClassifier);
                }
                case 4: 
                case 8: {
                    return this.createSessionBeanInstance(eClassifier);
                }
            }
            return this.createEntityBeanInstance(eClassifier);
        }
        if (eClassifier.getName().equals("SecurityIdentity")) {
            return this.createSecurityIdentitiyInstance(eClassifier);
        }
        if (eClassifier.getName().equals("RoleSource")) {
            return this.createRoleSourceInstance(eClassifier);
        }
        if (eClassifier == EcorePackage.eINSTANCE.getEAttribute()) {
            return this.getEjbFactory().createCMPAttribute();
        }
        return super.createInstance(eClassifier);
    }

    private EObject createSecurityIdentitiyInstance(EClass eClassifier) {
        ++this.createdSecRoles;
        if ((this.createdSecRoles & 1) == 0) {
            return CommonFactory.eINSTANCE.createUseCallerIdentity();
        }
        return CommonFactory.eINSTANCE.createRunAsSpecifiedIdentity();
    }

    private EObject createRoleSourceInstance(EClass eClassifier) {
        return ((EjbFactory)eClassifier.getEPackage().getEFactoryInstance()).createRoleSource();
    }

    private EObject createMessageBeanInstance(EClass eClassifier) {
        return ((EjbFactory)eClassifier.getEPackage().getEFactoryInstance()).createMessageDriven();
    }

    private EObject createSessionBeanInstance(EClass eClassifier) {
        return ((EjbFactory)eClassifier.getEPackage().getEFactoryInstance()).createSession();
    }

    private EObject createEntityBeanInstance(EClass eClassifier) {
        return ((EjbFactory)eClassifier.getEPackage().getEFactoryInstance()).createEntity();
    }

    private EObject createContainerManagedEntityInstance(EClass eClassifier) {
        return EjbFactory.eINSTANCE.createContainerManagedEntity();
    }

    public int getDepthForAttribute(EReference ref) {
        if (ref.getName().equals("enterpriseBeans")) {
            return this.NUM_BEANS;
        }
        if (ref.getName().equals("entityBeans")) {
            return this.NUM_BEANS;
        }
        if (ref.getName().equals("relationshipRoles")) {
            return 2;
        }
        return super.getDepthForAttribute(ref);
    }

    public void populateFeatures(EObject eObject) {
        if (eObject.eClass() == EJB_PKG.getCMPAttribute()) {
            ((CMPAttribute)eObject).setName((String)EMFAttributeFeatureGenerator.createAttribute(EcorePackage.eINSTANCE.getENamedElement_Name(), eObject));
            ((CMPAttribute)eObject).setEType((EClassifier)this.createJavaClassProxy(null));
        } else {
            super.editFeatures(eObject);
        }
    }

    protected void populateAttributes(EObject eObject) {
        if (eObject instanceof QueryMethodImpl) {
            EList attributes = eObject.eClass().getEAllAttributes();
            int i = 0;
            while (i < attributes.size()) {
                EAttribute att = (EAttribute)attributes.get(i);
                Object value = this.createAttributeValue(att, eObject);
                if (att.getName().equals("parms") && value == null) {
                    value = this.createAttributeValue(att, eObject);
                }
                if (att.isChangeable()) {
                    eObject.eSet((EStructuralFeature)att, value);
                }
                ++i;
            }
        } else if (eObject instanceof MethodPermissionImpl) {
            EList attributes = eObject.eClass().getEAllAttributes();
            int i = 0;
            while (i < attributes.size()) {
                EAttribute att = (EAttribute)attributes.get(i);
                if (!att.getName().equals("unchecked") || !this.mpFlag) {
                    Object value = this.createAttributeValue(att, eObject);
                    if (att.isChangeable()) {
                        eObject.eSet((EStructuralFeature)att, value);
                    }
                }
                ++i;
            }
            this.mpFlag = !this.mpFlag;
        } else {
            super.editAttributes(eObject);
        }
    }

    protected void populateSharedReference(EObject eObject, EReference ref) {
        if (eObject instanceof MethodPermissionImpl && ref.getName().equals("roles")) {
            boolean bl = this.mpFlag = !this.mpFlag;
            if (!this.mpFlag) {
                return;
            }
        }
        super.populateSharedReference(eObject, ref);
    }

    public HashSet ignorableAttributes() {
        HashSet<String> set = new HashSet<String>();
        set.add("id");
        return set;
    }

    protected void tearDown() throws Exception {
        this.earFile = null;
        this.ejbFile = null;
        this.mesBean = null;
        this.entityBean = null;
        this.secID = null;
        this.roleSource = null;
        super.tearDown();
    }
}

