/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.emftests;

import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.ApplicationPackage;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFPopulationTest;
import org.eclipse.jst.j2ee.archive.testutilities.EMFAttributeFeatureGenerator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.jca.ConnectorResource;
import org.eclipse.jst.j2ee.jca.JcaPackage;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;

public class RarEMFTest
extends GeneralEMFPopulationTest {
    EARFile earFile;
    protected RARFile rarFile;

    public RarEMFTest(String name) {
        super(name);
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    public EjbFactory getEjbFactory() {
        return EjbPackage.eINSTANCE.getEjbFactory();
    }

    public ApplicationFactory getApplicationFactory() {
        return ApplicationPackage.eINSTANCE.getApplicationFactory();
    }

    public WebapplicationFactory getWebAppFactory() {
        return WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.RarEMFTest", "-noloading"};
        TestRunner.main((String[])className);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new RarEMFTest("testRARPopulation"));
        return suite;
    }

    public void testRARPopulation() throws Exception {
        EMFAttributeFeatureGenerator.reset();
        this.createEAR();
        this.createRAR();
        ConnectorResource DD = (ConnectorResource)this.rarFile.getDeploymentDescriptorResource();
        DD.setVersionID(13);
        this.setVersion(1);
        this.setModuleType(2);
        this.populateRoot(DD.getRootObject());
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestRarEAR";
        this.earFile.extractTo(out, 126);
        this.earFile.close();
        String curDir = AutomatedBVT.baseDirectory;
        String exampleDeploymentDesURI = String.valueOf(curDir) + "EMFTestNoID/ra.xml";
        String curDeploymentDesURI = String.valueOf(curDir) + "testOutput/TestRarEAR/fooRAR/META-INF/ra.xml";
        RarEMFTest.setIgnoreAtt(this.ignorableAttributes());
        this.compareContentsIgnoreWhitespace(curDeploymentDesURI, exampleDeploymentDesURI, null);
    }

    public void test14RARPopulation() throws Exception {
        EMFAttributeFeatureGenerator.reset();
        this.createEAR();
        this.createRAR();
        ConnectorResource DD = (ConnectorResource)this.rarFile.getDeploymentDescriptorResource();
        DD.setVersionID(14);
        this.setVersion(2);
        this.setModuleType(2);
        this.populateRoot(DD.getRootObject());
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/Test14RarEAR";
        this.earFile.extractTo(out, 126);
        this.earFile.close();
        this.getRar();
        RarEMFTest.assertTrue((boolean)"1.5".equals(this.rarFile.getDeploymentDescriptor().getSpecVersion()));
        out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/Test14RarEAR2";
        this.rarFile.extractTo(out, 126);
        this.rarFile.close();
        String curDir = AutomatedBVT.baseDirectory;
        String exampleDeploymentDesURI = String.valueOf(curDir) + "testOutput/Test14RarEAR2/META-INF/ra.xml";
        String curDeploymentDesURI = String.valueOf(curDir) + "testOutput/Test14RarEAR/fooRAR/META-INF/ra.xml";
        RarEMFTest.setIgnoreAtt(this.ignorableAttributes());
        this.compareContentsIgnoreWhitespace(curDeploymentDesURI, exampleDeploymentDesURI, null);
    }

    public void getRar() throws DuplicateObjectException, OpenFailureException {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/Test14RarEAR/fooRAR";
        this.rarFile = this.getArchiveFactory().openRARFile(in);
        RarEMFTest.assertTrue((this.rarFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public void createRAR() throws DuplicateObjectException {
        this.rarFile = this.getArchiveFactory().createRARFileInitialized("fooRAR");
        this.rarFile = (RARFile)this.earFile.addCopy((ModuleFile)this.rarFile);
        this.rarFile.getDeploymentDescriptor().setDisplayName("fooRAR");
        RarEMFTest.assertTrue((this.rarFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public void createEAR() {
        String earName = "Test.ear";
        this.earFile = this.getArchiveFactory().createEARFileInitialized(earName);
        RarEMFTest.assertTrue((this.earFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public HashSet ignorableAttributes() {
        HashSet<String> set = new HashSet<String>();
        set.add("id");
        return set;
    }

    protected Object createAttributeValue(EAttribute att, EObject eObject) {
        if (att == JcaPackage.eINSTANCE.getConfigProperty_Type()) {
            return "java.lang.String";
        }
        if (att == JcaPackage.eINSTANCE.getAuthenticationMechanism_CredentialInterface()) {
            return "javax.resource.spi.security.PasswordCredential";
        }
        if (att == JcaPackage.eINSTANCE.getConnector_SpecVersion() && this.version == 1) {
            return "1.0";
        }
        return super.createAttributeValue(att, eObject);
    }
}

