/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.internal.IDomainSourceModelType;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataLocator;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataLocatorFactory;

public class DomainSourceModelTypeDescriptor {
    private static final String TRANSLATORS_EXTENSION_POINT_ID = "domainSourceModelTypeTranslators";
    private static final String STANDARD_FILE_NULL_TRANSLATOR = "org.eclipse.jst.jsf.common.metadata.internal.StandardAnnotationFilesTranslator";
    private String domain = "DEFAULT";
    private String domainSourceModelTypeId;
    private String locatorClassName = "org.eclipse.jst.jsf.common.metadata.internal.StandardMetaDataLocator";
    private Set translatorDescriptors;
    private String bundleId = "org.eclipse.jst.jsf.common";
    private int ordinal;
    private IDomainSourceModelType _instance;

    public DomainSourceModelTypeDescriptor(String domain, String domainSourceModelTypeId, String locatorClassName, String bundleId, int ordinal) {
        this.domain = domain;
        this.locatorClassName = locatorClassName;
        this.domainSourceModelTypeId = domainSourceModelTypeId;
        this.bundleId = bundleId;
        this.ordinal = ordinal;
        this.init();
    }

    public DomainSourceModelTypeDescriptor() {
        this.translatorDescriptors = new HashSet();
    }

    private synchronized void init() {
        this.translatorDescriptors = new HashSet();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint("org.eclipse.jst.jsf.common", TRANSLATORS_EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                String srcHdlrId = element.getAttribute("domainSourceModelTypeId");
                if (srcHdlrId.equals(this.domainSourceModelTypeId)) {
                    this.addTranslatorDescriptor(element);
                }
                ++i;
            }
        }
    }

    private void addTranslatorDescriptor(IConfigurationElement element) {
        String translator = element.getAttribute("translatorClass");
        DomainSourceModelTranslatorDescriptor d = new DomainSourceModelTranslatorDescriptor(translator, element.getContributor().getName());
        this.getTranslatorDescriptors().add(d);
    }

    private Set getTranslatorDescriptors() {
        if (this.translatorDescriptors == null) {
            this.translatorDescriptors = new HashSet();
        }
        return this.translatorDescriptors;
    }

    public String getDomain() {
        return this.domain;
    }

    public IDomainSourceModelType getInstance() {
        if (this._instance == null) {
            this._instance = this.newInstance();
        }
        return this._instance;
    }

    private IDomainSourceModelType newInstance() {
        return new DomainSourceModelTypeImpl();
    }

    class DomainSourceModelTranslatorDescriptor {
        private String _translator;
        private String _bundleId;

        public DomainSourceModelTranslatorDescriptor(String translator, String bundleId) {
            this._translator = translator;
            this._bundleId = bundleId;
        }

        String getTranslator() {
            return this._translator;
        }

        String getBundleId() {
            return this._bundleId;
        }
    }

    class DomainSourceModelTypeImpl
    implements IDomainSourceModelType {
        private Set translators;
        private IMetaDataLocator locator;

        DomainSourceModelTypeImpl() {
        }

        public String getDomain() {
            return DomainSourceModelTypeDescriptor.this.domain;
        }

        public int getOrdinal() {
            return DomainSourceModelTypeDescriptor.this.ordinal;
        }

        public IMetaDataLocator getLocator() {
            if (this.locator == null) {
                this.locator = MetaDataLocatorFactory.getInstance().getLocator(DomainSourceModelTypeDescriptor.this.locatorClassName, DomainSourceModelTypeDescriptor.this.bundleId);
            }
            return this.locator;
        }

        public Set getTranslators() {
            if (this.translators == null) {
                this.translators = this.createTranslatorInstances();
            }
            return this.translators;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("DomainSourceModelTypeImpl");
            buf.append("(domain = ");
            buf.append(this.getDomain());
            buf.append(", locator = ");
            buf.append(this.getLocator());
            buf.append(")");
            return buf.toString();
        }

        private Set createTranslatorInstances() {
            this.translators = new HashSet();
            if (DomainSourceModelTypeDescriptor.this.translatorDescriptors.size() == 0) {
                Class<?> klass = JSFCommonPlugin.loadClass(DomainSourceModelTypeDescriptor.STANDARD_FILE_NULL_TRANSLATOR, "org.eclipse.jst.jsf.common");
                try {
                    this.translators.add(klass.newInstance());
                    return this.translators;
                }
                catch (InstantiationException e) {
                    JSFCommonPlugin.log(e, "Error in createTranslatorInstances");
                }
                catch (IllegalAccessException e) {
                    JSFCommonPlugin.log(e, "Error in createTranslatorInstances");
                }
            }
            for (DomainSourceModelTranslatorDescriptor d : DomainSourceModelTypeDescriptor.this.translatorDescriptors) {
                Class<?> klass = JSFCommonPlugin.loadClass(d.getTranslator(), d.getBundleId());
                try {
                    this.translators.add(klass.newInstance());
                }
                catch (InstantiationException e) {
                    JSFCommonPlugin.log(e, "Error in createTranslatorInstances");
                }
                catch (IllegalAccessException e) {
                    JSFCommonPlugin.log(e, "Error in createTranslatorInstances");
                }
            }
            return this.translators;
        }
    }
}

