/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.refactor.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.common.CompatibilityDescriptionGroup;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.refactor.operations.OptionalRefactorHandler;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRefactorMetadata;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRefactorOperation;
import org.eclipse.jst.j2ee.refactor.operations.UpdateDependentEARonRenameProvider;
import org.eclipse.jst.j2ee.refactor.operations.UpdateDependentModuleonRenameProvider;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;

public class ProjectRenameOperation
extends ProjectRefactorOperation {
    public ProjectRenameOperation(IDataModel model) {
        super(model);
    }

    protected ProjectRefactorMetadata getProjectMetadata() {
        return (ProjectRefactorMetadata)this.model.getProperty("ProjectRefactoringProperties.ORIGINAL_PROJECT_METADATA");
    }

    protected void updateProject(ProjectRefactorMetadata originalMetadata) throws ExecutionException {
        ProjectRefactorMetadata refactoredMetadata = super.getProjectMetadata();
        String oldProjectName = originalMetadata.getProjectName();
        String newProjectName = refactoredMetadata.getProjectName();
        StructureEdit core = null;
        try {
            core = StructureEdit.getStructureEditForWrite((IProject)refactoredMetadata.getProject());
            WorkbenchComponent component = core.getComponent();
            if (component.getName().equals(originalMetadata.getProjectName())) {
                component.setName(refactoredMetadata.getProjectName());
            }
            EList propList = component.getProperties();
            int i = 0;
            while (i < propList.size()) {
                Property prop = (Property)propList.get(i);
                if (prop.getName().equals("context-root") && prop.getValue().equals(oldProjectName)) {
                    propList.remove(i);
                    Property newProp = ComponentcoreFactory.eINSTANCE.createProperty();
                    newProp.setName("context-root");
                    newProp.setValue(newProjectName);
                    propList.add(newProp);
                    break;
                }
                ++i;
            }
        }
        finally {
            if (core != null) {
                core.saveIfNecessary(null);
                core.dispose();
            }
        }
        ArtifactEdit edit = null;
        try {
            CompatibilityDescriptionGroup cdg;
            EObject root;
            EList list;
            edit = ComponentUtilities.getArtifactEditForWrite((IVirtualComponent)refactoredMetadata.getVirtualComponent());
            if (edit == null || !(edit instanceof EnterpriseArtifactEdit)) {
                return;
            }
            Resource resource = ((EnterpriseArtifactEdit)edit).getDeploymentDescriptorResource();
            if (resource != null && (list = resource.getContents()) != null && !list.isEmpty() && (root = (EObject)list.get(0)) instanceof CompatibilityDescriptionGroup && (cdg = (CompatibilityDescriptionGroup)root).getDisplayName().equals(oldProjectName)) {
                cdg.setDisplayName(newProjectName);
            }
        }
        finally {
            if (edit != null) {
                edit.saveIfNecessary(null);
                edit.dispose();
            }
        }
    }

    protected void updateDependentProjects(ProjectRefactorMetadata originalMetadata, IProgressMonitor monitor) throws ExecutionException {
        if (!originalMetadata.isEAR()) {
            super.updateDependentProjects(originalMetadata, monitor);
        }
        ProjectRefactorMetadata refactoredMetadata = super.getProjectMetadata();
        ProjectModuleFactoryDelegate.handleGlobalProjectChange((IProject)refactoredMetadata.getProject(), (IResourceDelta)((IResourceDelta)this.model.getProperty("ProjectRefactoringProperties.RESOURCE_DELTA")));
        super.updateServerRefs(originalMetadata, refactoredMetadata);
    }

    protected void updateDependentEARProject(ProjectRefactorMetadata dependentMetadata, ProjectRefactorMetadata originalMetadata) throws ExecutionException {
        if (OptionalRefactorHandler.getInstance().shouldRefactorDependentProjectOnRename(originalMetadata, dependentMetadata)) {
            IDataModel dataModel = this.createDataModel(dependentMetadata, originalMetadata, new UpdateDependentEARonRenameProvider());
            dataModel.getDefaultOperation().execute(null, null);
        }
    }

    protected void updateDependentModuleProject(ProjectRefactorMetadata dependentMetadata, ProjectRefactorMetadata originalMetadata) throws ExecutionException {
        if (OptionalRefactorHandler.getInstance().shouldRefactorDependentProjectOnRename(originalMetadata, dependentMetadata)) {
            IDataModel dataModel = this.createDataModel(dependentMetadata, originalMetadata, new UpdateDependentModuleonRenameProvider());
            dataModel.getDefaultOperation().execute(null, null);
        }
    }

    private IDataModel createDataModel(ProjectRefactorMetadata dependentMetadata, ProjectRefactorMetadata originalMetadata, AbstractDataModelProvider provider) {
        ProjectRefactorMetadata refactoredMetadata = super.getProjectMetadata();
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)provider);
        dataModel.setProperty("ProjectRefactoringProperties.PROJECT_METADATA", (Object)refactoredMetadata);
        dataModel.setProperty("ProjectRefactoringProperties.DEPENDENT_PROJECT_METADATA", (Object)dependentMetadata);
        dataModel.setProperty("ProjectRefactoringProperties.ORIGINAL_PROJECT_METADATA", (Object)originalMetadata);
        return dataModel;
    }
}

