/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.facet;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jpt.core.internal.JpaModelManager;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.internal.content.orm.EntityMappingsInternal;
import org.eclipse.jpt.core.internal.content.orm.OrmFactory;
import org.eclipse.jpt.core.internal.content.orm.OrmXmlResource;
import org.eclipse.jpt.core.internal.content.persistence.MappingFileRef;
import org.eclipse.jpt.core.internal.content.persistence.Persistence;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceFactory;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.content.persistence.resource.PersistenceResource;
import org.eclipse.jpt.core.internal.facet.IJpaFacetDataModelProperties;
import org.eclipse.jpt.core.internal.facet.JpaFacetUtils;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JpaFacetPostInstallDelegate
implements IDelegate,
IJpaFacetDataModelProperties {
    private static final String ORM_XML_FILE_PATH = "META-INF/orm.xml";

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 2);
        }
        JpaModelManager.instance().createJpaProject(project);
        IDataModel dataModel = (IDataModel)config;
        JpaFacetUtils.setPlatform(project, dataModel.getStringProperty("IJpaFacetDataModelProperties.PLATFORM_ID"));
        JpaFacetUtils.setConnectionName(project, dataModel.getStringProperty("IJpaFacetDataModelProperties.CONNECTION"));
        JpaFacetUtils.setDiscoverAnnotatedClasses(project, dataModel.getBooleanProperty("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES"));
        this.createPersistenceXml(project, dataModel);
        if (dataModel.getBooleanProperty("IJpaFacetDataModelProperties.CREATE_ORM_XML")) {
            this.createOrmXml(project, dataModel);
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        JpaModelManager.instance().fillJpaProject(project);
        if (monitor != null) {
            monitor.worked(2);
        }
    }

    private void createPersistenceXml(IProject project, IDataModel dataModel) {
        String sourceFolder = this.computeSourceFolder(project);
        URI fileURI = URI.createPlatformResourceURI((String)(String.valueOf(sourceFolder) + "/META-INF/persistence.xml"), (boolean)false);
        PersistenceResource resource = (PersistenceResource)this.getResourceSet(project).createResource(fileURI);
        Persistence persistence = PersistenceFactory.eINSTANCE.createPersistence();
        persistence.setVersion("1.0");
        PersistenceUnit pUnit = PersistenceFactory.eINSTANCE.createPersistenceUnit();
        pUnit.setName(project.getName());
        if (dataModel.getBooleanProperty("IJpaFacetDataModelProperties.CREATE_ORM_XML")) {
            MappingFileRef mappingFile = PersistenceFactory.eINSTANCE.createMappingFileRef();
            mappingFile.setFileName(ORM_XML_FILE_PATH);
            pUnit.getMappingFiles().add((Object)mappingFile);
        }
        persistence.getPersistenceUnits().add((Object)pUnit);
        try {
            resource.getContents().add((Object)persistence);
            resource.save(null);
        }
        catch (IOException e) {
            JptCorePlugin.log(e);
        }
    }

    private void createOrmXml(IProject project, IDataModel dataModel) {
        String sourceFolder = this.computeSourceFolder(project);
        URI fileURI = URI.createPlatformResourceURI((String)(String.valueOf(sourceFolder) + "/" + ORM_XML_FILE_PATH), (boolean)false);
        OrmXmlResource resource = (OrmXmlResource)this.getResourceSet(project).createResource(fileURI);
        EntityMappingsInternal entityMappings = OrmFactory.eINSTANCE.createEntityMappingsInternal();
        entityMappings.setVersion("1.0");
        try {
            resource.getContents().add((Object)entityMappings);
            resource.save(null);
        }
        catch (IOException e) {
            JptCorePlugin.log(e);
        }
    }

    private String computeSourceFolder(IProject project) {
        Object[] classpath;
        IJavaProject jproject = JavaCore.create((IProject)project);
        try {
            classpath = jproject.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {
            classpath = new IClasspathEntry[]{};
        }
        Iterator stream = CollectionTools.iterator((Object[])classpath);
        while (stream.hasNext()) {
            IClasspathEntry next = (IClasspathEntry)stream.next();
            if (next.getEntryKind() != 3) continue;
            return next.getPath().toString();
        }
        return "/" + project.getName();
    }

    private ResourceSet getResourceSet(IProject project) {
        return WorkbenchResourceHelperBase.getResourceSet((IProject)project);
    }
}

