/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.internal.IAttributeMapping;
import org.eclipse.jpt.core.internal.IJpaPlatform;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaEmbedded;
import org.eclipse.jpt.core.internal.content.orm.OrmFactory;
import org.eclipse.jpt.core.internal.content.orm.XmlEmbedded;
import org.eclipse.jpt.core.internal.content.orm.XmlOverride;
import org.eclipse.jpt.core.internal.content.orm.XmlTypeMapping;
import org.eclipse.jpt.core.internal.mappings.IAttributeOverride;
import org.eclipse.jpt.core.internal.mappings.IEmbedded;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.XmlAttributeContext;
import org.eclipse.jpt.core.internal.platform.XmlAttributeOverrideContext;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlEmbeddedContext
extends XmlAttributeContext {
    private Collection<XmlAttributeOverrideContext> attributeOverrideContexts = this.buildAttributeOverrideContexts();

    public XmlEmbeddedContext(IContext parentContext, XmlEmbedded mapping) {
        super(parentContext, mapping);
    }

    protected Collection<XmlAttributeOverrideContext> buildAttributeOverrideContexts() {
        ArrayList<XmlAttributeOverrideContext> contexts = new ArrayList<XmlAttributeOverrideContext>();
        for (IAttributeOverride attributeOverride : this.getEmbedded().getAttributeOverrides()) {
            contexts.add(new XmlAttributeOverrideContext(this.buildParentContext(), attributeOverride));
        }
        return contexts;
    }

    private XmlAttributeOverrideContext.ParentContext buildParentContext() {
        return new XmlAttributeOverrideContext.ParentContext(){

            @Override
            public void refreshDefaults(DefaultsContext defaults) {
                XmlEmbeddedContext.this.refreshDefaults(defaults);
            }

            @Override
            public IJpaPlatform getPlatform() {
                return XmlEmbeddedContext.this.getPlatform();
            }

            @Override
            public IContext getParentContext() {
                return XmlEmbeddedContext.this.getParentContext();
            }

            @Override
            public void addToMessages(List<IMessage> messages) {
                XmlEmbeddedContext.this.addToMessages(messages);
            }

            @Override
            public IAttributeOverride javaAttributeOverride(String overrideName) {
                if (XmlEmbeddedContext.this.getEmbedded().isVirtual()) {
                    return XmlEmbeddedContext.this.getJavaEmbedded().attributeOverrideNamed(overrideName);
                }
                return null;
            }
        };
    }

    @Override
    public void refreshDefaults(DefaultsContext parentDefaults) {
        super.refreshDefaults(parentDefaults);
        this.refreshDefaultAttributeOverrides();
        for (XmlAttributeOverrideContext context : this.attributeOverrideContexts) {
            context.refreshDefaults(parentDefaults);
        }
    }

    protected void refreshDefaultAttributeOverrides() {
        Iterator<String> i = this.getEmbedded().allOverridableAttributeNames();
        while (i.hasNext()) {
            String override = i.next();
            if (this.getEmbedded().containsAttributeOverride(override)) continue;
            IAttributeOverride attributeOverride = OrmFactory.eINSTANCE.createXmlAttributeOverride(new IEmbedded.AttributeOverrideOwner(this.getEmbedded()));
            this.getEmbedded().getDefaultAttributeOverrides().add((Object)attributeOverride);
            ((XmlOverride)((Object)attributeOverride)).setName(override);
        }
        Collection attributeNames = CollectionTools.collection(this.getEmbedded().allOverridableAttributeNames());
        ArrayList<IAttributeOverride> overridesToRemove = new ArrayList<IAttributeOverride>();
        for (IAttributeOverride attributeOverride : this.getEmbedded().getDefaultAttributeOverrides()) {
            if (attributeNames.contains(attributeOverride.getName()) && !this.getEmbedded().containsSpecifiedAttributeOverride(attributeOverride.getName())) continue;
            overridesToRemove.add(attributeOverride);
        }
        this.getEmbedded().getDefaultAttributeOverrides().removeAll(overridesToRemove);
    }

    protected XmlTypeMapping getXmlTypeMapping() {
        return this.getEmbedded().getPersistentAttribute().typeMapping();
    }

    private XmlEmbedded getEmbedded() {
        return (XmlEmbedded)this.attributeMapping();
    }

    protected JavaEmbedded getJavaEmbedded() {
        IAttributeMapping javaAttributeMapping = this.javaAttributeMapping();
        if (javaAttributeMapping != null && javaAttributeMapping.getKey() == "embedded") {
            return (JavaEmbedded)javaAttributeMapping;
        }
        return null;
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        for (XmlAttributeOverrideContext aoContext : this.attributeOverrideContexts) {
            aoContext.addToMessages(messages);
        }
    }
}

