/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java.search;

import java.io.File;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.java.JSP2ServletNameUtil;
import org.eclipse.jst.jsp.core.internal.java.search.JSPIndexManager;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchDocument;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchParticipant;
import org.eclipse.jst.jsp.core.internal.java.search.JavaSearchDocumentDelegate;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;

public class JSPSearchSupport {
    static final boolean DEBUG;
    private static JSPSearchSupport singleton;
    private JSPSearchParticipant fParticipant = null;
    private IPath fJspPluginLocation = null;
    private final CRC32 fChecksumCalculator = new CRC32();
    private final IProgressMonitor fMonitor = new NullProgressMonitor();

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspsearch");
        DEBUG = value != null && value.equalsIgnoreCase("true");
        singleton = null;
    }

    private JSPSearchSupport() {
    }

    public static synchronized JSPSearchSupport getInstance() {
        if (singleton == null) {
            singleton = new JSPSearchSupport();
        }
        return singleton;
    }

    public static boolean isJsp(IFile file) {
        IContentType contentTypeJSP;
        boolean isJsp = false;
        if (file != null && file.exists() && (contentTypeJSP = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSP)).isAssociatedWith(file.getName())) {
            isJsp = true;
        }
        return isJsp;
    }

    public SearchDocument addJspFile(IFile file) {
        SearchDocument delegate;
        block6: {
            if (JSPSearchSupport.getInstance().isCanceled() || !file.isAccessible()) {
                return null;
            }
            if (DEBUG) {
                System.out.println("adding JSP file:" + file.getFullPath());
            }
            if ((delegate = this.createSearchDocument(file)) != null) {
                try {
                    this.getSearchParticipant().scheduleDocumentIndexing(delegate, this.computeIndexLocation(file.getParent().getFullPath()));
                }
                catch (Exception e) {
                    if (!DEBUG) break block6;
                    e.printStackTrace();
                }
            }
        }
        if (DEBUG) {
            System.out.println("scheduled" + delegate + "for indexing");
        }
        return delegate;
    }

    public void search(String searchText, IJavaSearchScope scope, int searchFor, int limitTo, int matchMode, boolean isCaseSensitive, SearchRequestor requestor) {
        JSPIndexManager.getInstance().rebuildIndexIfNeeded();
        SearchJob job = new SearchJob(searchText, scope, searchFor, limitTo, matchMode, isCaseSensitive, requestor);
        this.setCanceled(false);
        job.setUser(true);
        job.schedule();
    }

    public void search(IJavaElement element, IJavaSearchScope scope, SearchRequestor requestor) {
        JSPIndexManager.getInstance().rebuildIndexIfNeeded();
        SearchJob job = new SearchJob(element, scope, requestor);
        this.setCanceled(false);
        job.setUser(true);
        job.schedule();
    }

    public void searchRunnable(IJavaElement element, IJavaSearchScope scope, SearchRequestor requestor) {
        JSPIndexManager.getInstance().rebuildIndexIfNeeded();
        SearchRunnable searchRunnable = new SearchRunnable(element, scope, requestor);
        try {
            this.setCanceled(false);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)searchRunnable, JSPSearchSupport.getInstance().getProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private SearchDocument createSearchDocument(IFile jspFile) {
        JavaSearchDocumentDelegate delegate = null;
        if (jspFile != null && jspFile.exists() && JSPSearchSupport.isJsp(jspFile)) {
            delegate = new JavaSearchDocumentDelegate(new JSPSearchDocument(jspFile.getFullPath().toString(), this.getSearchParticipant()));
        }
        return delegate;
    }

    public SearchDocument getSearchDocument(String searchDocPath) {
        SearchDocument delegate = null;
        IFile f = this.fileForCUPath(searchDocPath);
        if (f != null) {
            delegate = this.createSearchDocument(f);
        }
        return delegate;
    }

    private IFile fileForCUPath(String searchDocPath) {
        Path path;
        String[] split = searchDocPath.split("/");
        String classname = split[split.length - 1];
        if (!searchDocPath.endsWith(".java")) {
            return null;
        }
        String filePath = JSP2ServletNameUtil.unmangle(classname);
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(filePath));
        if (f == null && (path = new Path(filePath)).segmentCount() >= 2) {
            f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return f;
    }

    JSPSearchParticipant getSearchParticipant() {
        if (this.fParticipant == null) {
            this.fParticipant = new JSPSearchParticipant();
        }
        return this.fParticipant;
    }

    public final IPath computeIndexLocation(IPath containerPath) {
        IPath indexLocation = null;
        String pathString = containerPath.toOSString();
        this.fChecksumCalculator.reset();
        this.fChecksumCalculator.update(pathString.getBytes());
        String fileName = String.valueOf(Long.toString(this.fChecksumCalculator.getValue())) + ".index";
        indexLocation = this.getModelJspPluginWorkingLocation().append(fileName);
        JavaModelManager.getJavaModelManager().getIndexManager().indexLocations.put((Object)containerPath, (Object)indexLocation);
        return indexLocation;
    }

    public IPath getModelJspPluginWorkingLocation() {
        File folder;
        if (this.fJspPluginLocation != null) {
            return this.fJspPluginLocation;
        }
        IPath stateLocation = JSPCorePlugin.getDefault().getStateLocation().append("jspsearch");
        String device = stateLocation.getDevice();
        if (device != null && device.charAt(0) == '/') {
            stateLocation = stateLocation.setDevice(device.substring(1));
        }
        if (!(folder = new File(stateLocation.toOSString())).isDirectory()) {
            try {
                folder.mkdir();
            }
            catch (SecurityException securityException) {}
        }
        this.fJspPluginLocation = stateLocation;
        return this.fJspPluginLocation;
    }

    public final synchronized void setCanceled(boolean cancel) {
        this.fMonitor.setCanceled(cancel);
    }

    public final synchronized boolean isCanceled() {
        return this.fMonitor.isCanceled();
    }

    public final IProgressMonitor getProgressMonitor() {
        return this.fMonitor;
    }

    private class SearchJob
    extends Job
    implements IJavaSearchConstants {
        String fSearchText = "";
        IJavaSearchScope fScope = null;
        int fSearchFor = 4;
        int fLimitTo = 3;
        int fMatchMode = 2;
        boolean fIsCaseSensitive = false;
        SearchRequestor fRequestor = null;
        IJavaElement fElement = null;

        public SearchJob(IJavaElement element, IJavaSearchScope scope, SearchRequestor requestor) {
            super(String.valueOf(JSPCoreMessages.JSP_Search) + element.getElementName());
            this.fElement = element;
            this.fScope = scope;
            this.fRequestor = requestor;
        }

        public SearchJob(String searchText, IJavaSearchScope scope, int searchFor, int limitTo, int matchMode, boolean isCaseSensitive, SearchRequestor requestor) {
            super(String.valueOf(JSPCoreMessages.JSP_Search) + searchText);
            this.fSearchText = searchText;
            this.fScope = scope;
            this.fSearchFor = searchFor;
            this.fLimitTo = limitTo;
            this.fMatchMode = matchMode;
            this.fIsCaseSensitive = isCaseSensitive;
            this.fRequestor = requestor;
        }

        /*
         * Exception decompiling
         */
        public IStatus run(IProgressMonitor jobMonitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 188->191)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class SearchRunnable
    implements IWorkspaceRunnable,
    IJavaSearchConstants {
        String fSearchText = "";
        IJavaSearchScope fScope = null;
        int fSearchFor = 4;
        int fLimitTo = 3;
        int fMatchMode = 2;
        boolean fIsCaseSensitive = false;
        SearchRequestor fRequestor = null;
        IJavaElement fElement = null;

        public SearchRunnable(IJavaElement element, IJavaSearchScope scope, SearchRequestor requestor) {
            this.fElement = element;
            this.fScope = scope;
            this.fRequestor = requestor;
        }

        public SearchRunnable(String searchText, IJavaSearchScope scope, int searchFor, int limitTo, int matchMode, boolean isCaseSensitive, SearchRequestor requestor) {
            this.fSearchText = searchText;
            this.fScope = scope;
            this.fSearchFor = searchFor;
            this.fLimitTo = limitTo;
            this.fMatchMode = matchMode;
            this.fIsCaseSensitive = isCaseSensitive;
            this.fRequestor = requestor;
        }

        /*
         * Exception decompiling
         */
        public void run(IProgressMonitor monitor) throws CoreException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 170->174)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

