/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.wsrt;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ClientRuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.RuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ServiceRuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceClientImpl;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceImpl;

public class WebServiceRuntimeExtensionRegistry2 {
    private static WebServiceRuntimeExtensionRegistry2 instance_;
    Hashtable webServiceImpls_;
    Hashtable webServiceClientImpls_;
    Hashtable runtimes_;
    Hashtable serviceRuntimes_;
    Hashtable clientRuntimes_;
    ArrayList webServiceTypesList_;
    ArrayList webServiceClientTypesList_;

    public static WebServiceRuntimeExtensionRegistry2 getInstance() {
        if (instance_ == null) {
            instance_ = new WebServiceRuntimeExtensionRegistry2();
            instance_.load();
        }
        return instance_;
    }

    private void load() {
        this.webServiceImpls_ = new Hashtable();
        this.webServiceClientImpls_ = new Hashtable();
        this.runtimes_ = new Hashtable();
        this.serviceRuntimes_ = new Hashtable();
        this.clientRuntimes_ = new Hashtable();
        this.webServiceTypesList_ = new ArrayList();
        this.webServiceClientTypesList_ = new ArrayList();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] wsImplExts = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "wsImpl");
        int idx = 0;
        while (idx < wsImplExts.length) {
            IConfigurationElement elem = wsImplExts[idx];
            if (elem.getName().equals("webServiceImpl")) {
                WebServiceImpl wsimpl = new WebServiceImpl(elem);
                this.webServiceImpls_.put(elem.getAttribute("id"), wsimpl);
            }
            ++idx;
        }
        IConfigurationElement[] wsClientImplExts = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "wsClientImpl");
        int idx2 = 0;
        while (idx2 < wsClientImplExts.length) {
            IConfigurationElement elem = wsClientImplExts[idx2];
            if (elem.getName().equals("webServiceClientImpl")) {
                WebServiceClientImpl wsClientImpl = new WebServiceClientImpl(elem);
                this.webServiceClientImpls_.put(elem.getAttribute("id"), wsClientImpl);
            }
            ++idx2;
        }
        IConfigurationElement[] runtimeExts = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "runtimes");
        int idx3 = 0;
        while (idx3 < runtimeExts.length) {
            IConfigurationElement elem = runtimeExts[idx3];
            if (elem.getName().equals("runtime")) {
                RuntimeDescriptor rd = new RuntimeDescriptor(elem);
                this.runtimes_.put(elem.getAttribute("id"), rd);
            }
            ++idx3;
        }
        IConfigurationElement[] serviceRuntimeExts = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "serviceRuntimes");
        int idx4 = 0;
        while (idx4 < serviceRuntimeExts.length) {
            IConfigurationElement elem = serviceRuntimeExts[idx4];
            if (elem.getName().equals("serviceRuntime")) {
                ServiceRuntimeDescriptor rd = new ServiceRuntimeDescriptor(elem, this.webServiceImpls_, this.runtimes_);
                this.serviceRuntimes_.put(elem.getAttribute("id"), rd);
                this.updateWebServiceTypeList(rd);
            }
            ++idx4;
        }
        IConfigurationElement[] clientRuntimeExts = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "clientRuntimes");
        int idx5 = 0;
        while (idx5 < clientRuntimeExts.length) {
            IConfigurationElement elem = clientRuntimeExts[idx5];
            if (elem.getName().equals("clientRuntime")) {
                ClientRuntimeDescriptor rd = new ClientRuntimeDescriptor(elem, this.webServiceClientImpls_, this.runtimes_);
                this.clientRuntimes_.put(elem.getAttribute("id"), rd);
                this.updateWebServiceClientTypeList(rd);
            }
            ++idx5;
        }
    }

    private void updateWebServiceTypeList(ServiceRuntimeDescriptor descriptor) {
        String entry;
        StringBuffer entrybuff;
        String serviceImplId = descriptor.getServiceImplementationType().getId();
        boolean bottomUp = descriptor.getBottomUp();
        boolean topDown = descriptor.getTopDown();
        if (bottomUp) {
            entrybuff = new StringBuffer();
            entrybuff.append(String.valueOf(0));
            entrybuff.append("/");
            entrybuff.append(serviceImplId);
            entry = entrybuff.toString();
            if (!this.webServiceTypesList_.contains(entry)) {
                this.webServiceTypesList_.add(entry);
            }
        }
        if (topDown) {
            entrybuff = new StringBuffer();
            entrybuff.append(String.valueOf(1));
            entrybuff.append("/");
            entrybuff.append(serviceImplId);
            entry = entrybuff.toString();
            if (!this.webServiceTypesList_.contains(entry)) {
                this.webServiceTypesList_.add(entry);
            }
        }
    }

    private void updateWebServiceClientTypeList(ClientRuntimeDescriptor descriptor) {
        String clientImplId = descriptor.getClientImplementationType().getId();
        StringBuffer entrybuff = new StringBuffer();
        entrybuff.append(String.valueOf(2));
        entrybuff.append("/");
        entrybuff.append(clientImplId);
        String entry = entrybuff.toString();
        if (!this.webServiceClientTypesList_.contains(entry)) {
            this.webServiceClientTypesList_.add(entry);
        }
    }
}

