/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.componentcore.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.componentcore.util.EARVirtualRootFolder;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.jee.application.ICommonModule;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.builder.DependencyGraphManager;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.internal.util.IComponentImplFactory;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class EARVirtualComponent
extends VirtualComponent
implements IComponentImplFactory {
    private IVirtualReference[] cachedReferences;
    private long depGraphModStamp;

    public EARVirtualComponent() {
    }

    public EARVirtualComponent(IProject aProject, IPath aRuntimePath) {
        super(aProject, aRuntimePath);
    }

    public IVirtualComponent createArchiveComponent(IProject aProject, String archiveLocation, IPath aRuntimePath) {
        return new J2EEModuleVirtualArchiveComponent(aProject, archiveLocation, aRuntimePath);
    }

    public IVirtualComponent createComponent(IProject aProject) {
        return new EARVirtualComponent(aProject, (IPath)new Path("/"));
    }

    public IVirtualFolder createFolder(IProject aProject, IPath aRuntimePath) {
        return new EARVirtualRootFolder(aProject, aRuntimePath);
    }

    private static String getJarURI(ReferencedComponent ref, IVirtualComponent moduleComp) {
        String uri = ref.getArchiveName();
        if (uri == null || uri.length() < 0) {
            uri = moduleComp.isBinary() ? new Path(moduleComp.getName()).lastSegment() : String.valueOf(moduleComp.getName()) + ".jar";
        } else {
            String prefix = ref.getRuntimePath().makeRelative().toString();
            if (prefix.length() > 0) {
                uri = String.valueOf(prefix) + "/" + uri;
            }
        }
        return uri;
    }

    private static List getHardReferences(IVirtualComponent earComponent) {
        StructureEdit core = null;
        ArrayList<IVirtualReference> hardReferences = new ArrayList<IVirtualReference>();
        try {
            WorkbenchComponent component;
            core = StructureEdit.getStructureEditForRead((IProject)earComponent.getProject());
            if (core != null && core.getComponent() != null && (component = core.getComponent()) != null) {
                EList referencedComponents = component.getReferencedComponents();
                for (ReferencedComponent referencedComponent : referencedComponents) {
                    IProject referencedProject;
                    IVirtualComponent referencedIVirtualComponent;
                    IVirtualReference vReference;
                    if (referencedComponent == null || (vReference = StructureEdit.createVirtualReference((IVirtualComponent)earComponent, (ReferencedComponent)referencedComponent)) == null || (referencedIVirtualComponent = vReference.getReferencedComponent()) == null || !referencedIVirtualComponent.exists()) continue;
                    String archiveName = null;
                    archiveName = referencedComponent.getDependentObject() != null ? ((ICommonModule)referencedComponent.getDependentObject()).getUri() : (referencedIVirtualComponent.isBinary() ? EARVirtualComponent.getJarURI(referencedComponent, referencedIVirtualComponent) : (J2EEProjectUtilities.isDynamicWebProject(referencedProject = referencedIVirtualComponent.getProject()) || J2EEProjectUtilities.isStaticWebProject(referencedProject) ? String.valueOf(referencedIVirtualComponent.getName()) + ".war" : (J2EEProjectUtilities.isJCAProject(referencedProject) ? String.valueOf(referencedIVirtualComponent.getName()) + ".rar" : (J2EEProjectUtilities.isUtilityProject(referencedProject) ? EARVirtualComponent.getJarURI(referencedComponent, referencedIVirtualComponent) : String.valueOf(referencedIVirtualComponent.getName()) + ".jar"))));
                    vReference.setArchiveName(archiveName);
                    hardReferences.add(vReference);
                }
            }
        }
        finally {
            if (core != null) {
                core.dispose();
            }
        }
        return hardReferences;
    }

    private static List getLooseArchiveReferences(EARVirtualComponent earComponent, List hardReferences) {
        return EARVirtualComponent.getLooseArchiveReferences(earComponent, hardReferences, null, (EARVirtualRootFolder)earComponent.getRootFolder());
    }

    private static List getLooseArchiveReferences(EARVirtualComponent earComponent, List hardReferences, List dynamicReferences, EARVirtualRootFolder folder) {
        try {
            IVirtualResource[] members = folder.superMembers();
            int i = 0;
            while (i < members.length) {
                if (16 == members[i].getType()) {
                    if (folder.isDynamicComponent((IVirtualFile)members[i])) {
                        String archiveName = members[i].getRuntimePath().toString().substring(1);
                        boolean shouldInclude = true;
                        int j = 0;
                        while (j < hardReferences.size() && shouldInclude) {
                            String tempArchiveName = ((IVirtualReference)hardReferences.get(j)).getArchiveName();
                            if (tempArchiveName != null && tempArchiveName.equals(archiveName)) {
                                shouldInclude = false;
                            }
                            ++j;
                        }
                        if (shouldInclude) {
                            IResource iResource = members[i].getUnderlyingResource();
                            IVirtualComponent dynamicComponent = ComponentCore.createArchiveComponent((IProject)earComponent.getProject(), (String)("lib" + iResource.getFullPath().toString()));
                            IVirtualReference dynamicRef = ComponentCore.createReference((IVirtualComponent)earComponent, (IVirtualComponent)dynamicComponent);
                            dynamicRef.setArchiveName(archiveName);
                            if (dynamicReferences == null) {
                                dynamicReferences = new ArrayList<IVirtualReference>();
                            }
                            dynamicReferences.add(dynamicRef);
                        }
                    }
                } else if (32 == members[i].getType()) {
                    dynamicReferences = EARVirtualComponent.getLooseArchiveReferences(earComponent, hardReferences, dynamicReferences, (EARVirtualRootFolder)members[i]);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        return dynamicReferences;
    }

    public IVirtualReference[] getReferences() {
        IVirtualReference[] cached = this.getCachedReferences();
        if (cached != null) {
            return cached;
        }
        List hardReferences = EARVirtualComponent.getHardReferences((IVirtualComponent)this);
        List dynamicReferences = EARVirtualComponent.getLooseArchiveReferences(this, hardReferences);
        if (dynamicReferences != null) {
            hardReferences.addAll(dynamicReferences);
        }
        this.cachedReferences = hardReferences.toArray(new IVirtualReference[hardReferences.size()]);
        return this.cachedReferences;
    }

    public IVirtualReference[] getCachedReferences() {
        if (this.cachedReferences != null && this.checkIfStillValid()) {
            return this.cachedReferences;
        }
        this.depGraphModStamp = DependencyGraphManager.getInstance().getModStamp();
        return null;
    }

    private boolean checkIfStillValid() {
        return DependencyGraphManager.getInstance().getModStamp() == this.depGraphModStamp;
    }
}

