/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.archive.JavaEEEMFArchiveAdapterHelper;
import org.eclipse.jst.j2ee.internal.archive.operations.EARArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyManifestUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.jee.archive.AbstractArchiveLoadAdapter;
import org.eclipse.jst.jee.archive.ArchiveModelLoadException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.archive.internal.ArchiveURIConverter;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentArchiveLoadAdapter
extends AbstractArchiveLoadAdapter {
    protected static final String DOT_SQLJ = ".sqlj";
    protected static final String DOT_JSP = ".jsp";
    protected static final String DOT_PROJECT = ".project";
    protected static final String DOT_CLASSPATH = ".classpath";
    protected static final String DOT_SETTINGS = ".settings";
    protected static final String DOT_CVS_IGORE = ".cvsignore";
    protected IVirtualComponent vComponent;
    protected boolean exportSource = true;
    private List zipFiles = new ArrayList();
    private List javaClasspathURIs = new ArrayList();
    protected boolean includeClasspathComponents = true;
    protected FilesHolder filesHolder;
    private IVirtualFile manifestFile = null;
    protected boolean archiveResourcesInitialized = false;
    private IResource[] sourceRoots = null;
    private boolean inJavaSrc = false;
    protected JavaEEEMFArchiveAdapterHelper emfHelper = null;

    public ComponentArchiveLoadAdapter(IVirtualComponent vComponent) {
        this(vComponent, true);
    }

    public ComponentArchiveLoadAdapter(IVirtualComponent vComponent, boolean includeClasspathComponents) {
        this.vComponent = vComponent;
        this.filesHolder = new FilesHolder();
        this.setIncludeClasspathComponents(includeClasspathComponents);
    }

    public void setIncludeClasspathComponents(boolean includeClasspathComponents) {
        this.includeClasspathComponents = includeClasspathComponents;
        if (includeClasspathComponents) {
            this.manifestFile = this.vComponent.getRootFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
            this.saveJavaClasspathReferences();
        } else {
            this.manifestFile = null;
            this.javaClasspathURIs.clear();
        }
    }

    public IArchiveResource getArchiveResource(IPath resourcePath) throws FileNotFoundException {
        this.initArchiveResources();
        return this.filesHolder.getArchiveResource(resourcePath);
    }

    public boolean containsArchiveResource(IPath path) {
        this.initArchiveResources();
        return this.filesHolder.contains(path);
    }

    protected void initArchiveResources() {
        if (!this.archiveResourcesInitialized) {
            this.archiveResourcesInitialized = true;
            this.aggregateSourceFiles();
            this.aggregateClassFiles();
            this.addUtilities();
        }
    }

    public List<IArchiveResource> getArchiveResources() {
        this.initArchiveResources();
        return this.filesHolder.getFiles();
    }

    protected void saveJavaClasspathReferences() {
        if (this.vComponent instanceof J2EEModuleVirtualComponent) {
            J2EEModuleVirtualComponent j2eeComp = (J2EEModuleVirtualComponent)this.vComponent;
            IVirtualReference[] refs = j2eeComp.getJavaClasspathReferences();
            if (refs == null) {
                return;
            }
            int i = 0;
            while (i < refs.length) {
                if (refs[i].getRuntimePath().equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH)) {
                    this.javaClasspathURIs.add(refs[i].getArchiveName());
                }
                ++i;
            }
        }
    }

    protected void addUtilities() {
        IVirtualReference[] components = this.vComponent.getReferences();
        int i = 0;
        while (i < components.length) {
            IVirtualReference reference = components[i];
            IVirtualComponent referencedComponent = reference.getReferencedComponent();
            if (referencedComponent.isBinary() && reference.getDependencyType() == 1) {
                File diskFile = ((VirtualArchiveComponent)referencedComponent).getUnderlyingDiskFile();
                IPath path = reference.getRuntimePath();
                try {
                    ZipFile zipFile = new ZipFile(diskFile);
                    this.zipFiles.add(zipFile);
                    Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry entry = enumeration.nextElement();
                        this.filesHolder.addEntry(entry, zipFile, path);
                    }
                }
                catch (ZipException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
                catch (IOException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            }
            ++i;
        }
    }

    protected void aggregateSourceFiles() {
        try {
            IVirtualFolder rootFolder = this.vComponent.getRootFolder();
            IVirtualResource[] members = rootFolder.members();
            IPackageFragmentRoot[] srcPkgs = J2EEProjectUtilities.getSourceContainers(this.vComponent.getProject());
            this.sourceRoots = new IResource[srcPkgs.length];
            int i = 0;
            while (i < srcPkgs.length) {
                this.sourceRoots[i] = srcPkgs[i].getCorrespondingResource();
                ++i;
            }
            this.inJavaSrc = false;
            this.aggregateFiles(members);
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    protected void aggregateClassFiles() {
        StructureEdit se = null;
        try {
            try {
                IPackageFragmentRoot[] sourceRoots = J2EEProjectUtilities.getSourceContainers(this.vComponent.getProject());
                se = StructureEdit.getStructureEditForRead((IProject)this.vComponent.getProject());
                int i = 0;
                while (i < sourceRoots.length) {
                    IProject project;
                    IPath outputPath = sourceRoots[i].getRawClasspathEntry().getOutputLocation();
                    if (outputPath == null && (project = this.vComponent.getProject()).hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject javaProject = JavaCore.create((IProject)project);
                        outputPath = javaProject.getOutputLocation();
                    }
                    if (outputPath != null) {
                        IFolder javaOutputContainer = outputPath.segmentCount() > 1 ? ResourcesPlugin.getWorkspace().getRoot().getFolder(outputPath) : ResourcesPlugin.getWorkspace().getRoot().getProject(outputPath.lastSegment());
                        Path runtimePath = null;
                        try {
                            IPath tmpSourcePath;
                            IPath tmpRuntimePath;
                            ComponentResource[] componentResources = se.findResourcesBySourcePath(sourceRoots[i].getResource().getProjectRelativePath());
                            if (componentResources.length > 0 && !(tmpRuntimePath = componentResources[0].getRuntimePath()).equals((Object)(tmpSourcePath = componentResources[0].getSourcePath()))) {
                                while (tmpSourcePath.segmentCount() > 0 && tmpRuntimePath.segmentCount() > 0 && tmpRuntimePath.lastSegment().equals(tmpSourcePath.lastSegment())) {
                                    tmpRuntimePath = tmpRuntimePath.removeLastSegments(1);
                                    tmpSourcePath = tmpSourcePath.removeLastSegments(1);
                                }
                                if (tmpRuntimePath.segmentCount() != 0) {
                                    runtimePath = tmpRuntimePath.makeRelative();
                                }
                            }
                        }
                        catch (UnresolveableURIException e) {
                            Logger.getLogger().logError((Throwable)e);
                        }
                        if (runtimePath == null) {
                            runtimePath = new Path("");
                        }
                        this.aggregateOutputFiles(new IResource[]{javaOutputContainer}, (IPath)runtimePath, javaOutputContainer.getProjectRelativePath().segmentCount());
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
                if (se != null) {
                    se.dispose();
                }
            }
        }
        finally {
            if (se != null) {
                se.dispose();
            }
        }
    }

    protected boolean aggregateOutputFiles(IResource[] resources, IPath runtimePathPrefix, int outputFolderSegmentCount) throws CoreException {
        boolean fileAdded = false;
        int i = 0;
        while (i < resources.length) {
            IPath runtimePath;
            IArchiveResource cFile = null;
            if (resources[i].exists() && (runtimePath = runtimePathPrefix.append(resources[i].getProjectRelativePath().removeFirstSegments(outputFolderSegmentCount))) != null) {
                if (resources[i].getType() == 1) {
                    if (this.shouldInclude(runtimePath)) {
                        cFile = this.createFile(runtimePath);
                        cFile.setLastModified(this.getLastModified(resources[i]));
                        this.filesHolder.addFile(cFile, resources[i]);
                        fileAdded = true;
                    }
                } else if (this.shouldInclude((IContainer)resources[i])) {
                    IResource[] nestedResources = ((IContainer)resources[i]).members();
                    this.aggregateOutputFiles(nestedResources, runtimePathPrefix, outputFolderSegmentCount);
                    if (!this.filesHolder.contains(runtimePath) && this.shouldInclude(runtimePath)) {
                        cFile = this.createDirectory(runtimePath);
                        cFile.setLastModified(this.getLastModified(resources[i]));
                        this.filesHolder.addFile(cFile);
                        fileAdded = true;
                    }
                }
            }
            ++i;
        }
        return fileAdded;
    }

    protected boolean aggregateFiles(IVirtualResource[] virtualResources) throws CoreException {
        boolean fileAdded = false;
        int i = 0;
        while (i < virtualResources.length) {
            IPath runtimePath;
            if (virtualResources[i].exists() && (runtimePath = virtualResources[i].getRuntimePath()) != null && !this.filesHolder.contains(runtimePath = runtimePath.setDevice(null).makeRelative())) {
                IArchiveResource cFile = null;
                if (virtualResources[i].getType() == 16) {
                    if (this.shouldInclude(runtimePath)) {
                        IResource resource = virtualResources[i].getUnderlyingResource();
                        if (!this.inJavaSrc || !resource.isDerived()) {
                            cFile = this.createFile(runtimePath);
                            cFile.setLastModified(this.getLastModified(resource));
                            this.filesHolder.addFile(cFile, resource);
                            fileAdded = true;
                        }
                    }
                } else if (this.shouldInclude((IVirtualContainer)virtualResources[i])) {
                    boolean inJavaSrcAtThisLevel = this.inJavaSrc;
                    try {
                        if (!this.inJavaSrc) {
                            this.inJavaSrc = this.inJavaSrc(virtualResources[i]);
                        }
                        IVirtualResource[] nestedVirtualResources = ((IVirtualContainer)virtualResources[i]).members();
                        this.aggregateFiles(nestedVirtualResources);
                        if (!this.filesHolder.contains(runtimePath) && this.shouldInclude(runtimePath)) {
                            IResource resource = virtualResources[i].getUnderlyingResource();
                            if (this.inJavaSrc && resource.isDerived()) {
                            } else {
                                cFile = this.createDirectory(runtimePath);
                                cFile.setLastModified(this.getLastModified(resource));
                                this.filesHolder.addFile(cFile);
                                fileAdded = true;
                            }
                        }
                    }
                    finally {
                        this.inJavaSrc = inJavaSrcAtThisLevel;
                    }
                }
            }
            ++i;
        }
        return fileAdded;
    }

    private boolean inJavaSrc(IVirtualResource virtualResource) {
        if (this.sourceRoots.length == 0) {
            return false;
        }
        IResource[] resources = virtualResource.getUnderlyingResources();
        boolean inJavaSrc = false;
        int i = 0;
        while (i < resources.length) {
            inJavaSrc = false;
            int j = 0;
            while (j < this.sourceRoots.length) {
                if (this.sourceRoots[j].getFullPath().isPrefixOf(resources[i].getFullPath())) {
                    inJavaSrc = true;
                    break;
                }
                ++j;
            }
            if (!inJavaSrc) break;
            ++i;
        }
        return inJavaSrc;
    }

    protected long getLastModified(IResource aResource) {
        return aResource.getLocation().toFile().lastModified();
    }

    public void setExportSource(boolean newExportSource) {
        this.exportSource = newExportSource;
    }

    public boolean isExportSource() {
        return this.exportSource;
    }

    protected boolean shouldInclude(IContainer aContainer) {
        return true;
    }

    protected boolean shouldInclude(IVirtualContainer vContainer) {
        IContainer iContainer = (IContainer)vContainer.getUnderlyingResource();
        return this.shouldInclude(iContainer);
    }

    protected boolean shouldInclude(IPath path) {
        String lastSegment = path.lastSegment();
        if (lastSegment == null) {
            return false;
        }
        if (lastSegment.endsWith(DOT_PROJECT) || lastSegment.endsWith(DOT_CLASSPATH) || lastSegment.endsWith(DOT_CVS_IGORE) || path.segment(0).startsWith(DOT_SETTINGS)) {
            return false;
        }
        return this.isExportSource() || !this.isSource(path);
    }

    protected boolean isSource(IPath path) {
        if (path == null) {
            return false;
        }
        return path.lastSegment().endsWith(".java") || path.lastSegment().endsWith(DOT_SQLJ);
    }

    protected void addExternalFile(IPath path, File externalDiskFile) {
        IArchiveResource aFile = this.createFile(path);
        this.filesHolder.addFile(aFile, externalDiskFile);
    }

    protected InputStream getSuperInputStream(IArchiveResource archiveResource) throws IOException, FileNotFoundException {
        return super.getInputStream(archiveResource);
    }

    public InputStream getInputStream(IArchiveResource archiveResource) throws IOException, FileNotFoundException {
        IPath path = archiveResource.getPath();
        if (this.includeClasspathComponents && path.equals((Object)"META-INF/MANIFEST.MF") && !this.javaClasspathURIs.isEmpty() && this.manifestFile != null && this.manifestFile.getUnderlyingFile() != null && this.manifestFile.getUnderlyingFile().exists()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ClasspathDependencyManifestUtil.updateManifestClasspath(this.manifestFile.getUnderlyingFile(), this.javaClasspathURIs, baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        if (this.filesHolder.contains(path)) {
            return this.filesHolder.getInputStream(path);
        }
        IVirtualFolder rootFolder = this.vComponent.getRootFolder();
        IVirtualResource vResource = rootFolder.findMember(path);
        String filePath = null;
        if (vResource != null && vResource.exists()) {
            filePath = vResource.getUnderlyingResource().getLocation().toOSString();
            File file = new File(filePath);
            return new FileInputStream(file);
        }
        String eString = EARArchiveOpsResourceHandler.ARCHIVE_OPERATION_FileNotFound;
        throw new FileNotFoundException(eString);
    }

    public IVirtualComponent getComponent() {
        return this.vComponent;
    }

    protected void initEMFHelper() {
        if (this.emfHelper == null) {
            this.emfHelper = new JavaEEEMFArchiveAdapterHelper(this.getArchive());
            this.emfHelper.setArchiveURIConverter(new ArchiveURIConverter(this.emfHelper.getArchive()){

                protected URI convertPathToURI(IPath modelObjectPath) {
                    IPath path = ComponentArchiveLoadAdapter.this.getComponent().getRootFolder().getFile(modelObjectPath).getUnderlyingFile().getFullPath();
                    return URI.createURI((String)("platform:/resource/" + path.toString()));
                }
            });
        }
    }

    public boolean containsModelObject(IPath modelObjectPath) {
        this.initEMFHelper();
        if (IArchive.EMPTY_MODEL_PATH == modelObjectPath) {
            modelObjectPath = this.getDefaultModelObjectPath();
        }
        return this.emfHelper.containsModelObject(modelObjectPath);
    }

    public Object getModelObject(IPath modelObjectPath) throws ArchiveModelLoadException {
        this.initEMFHelper();
        if (IArchive.EMPTY_MODEL_PATH == modelObjectPath) {
            modelObjectPath = this.getDefaultModelObjectPath();
        }
        return this.emfHelper.getModelObject(modelObjectPath);
    }

    protected IPath getDefaultModelObjectPath() {
        return new Path("/");
    }

    public String toString() {
        int packageLength = ((Object)((Object)this)).getClass().getPackage().getName().length() + 1;
        StringBuffer buffer = new StringBuffer(((Object)((Object)this)).getClass().getName().substring(packageLength));
        buffer.append(", Component: ");
        buffer.append(this.getComponent());
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FilesHolder {
        private Map pathsToArchiveResources = new HashMap();
        private Map pathsToWorkbenchResources = new HashMap();
        private Map workbenchResourcesToPaths = new HashMap();
        private Map pathsToDiskFiles;
        private Map pathsToZipEntry = new HashMap();

        protected FilesHolder() {
        }

        public void removeIFile(IFile file) {
            IPath path = (IPath)this.workbenchResourcesToPaths.get(file);
            this.remove(path);
        }

        public void remove(IPath path) {
            this.pathsToArchiveResources.remove(path);
            Object resource = this.pathsToWorkbenchResources.remove(path);
            if (resource != null) {
                this.workbenchResourcesToPaths.remove(resource);
            }
            if (this.pathsToDiskFiles != null) {
                this.pathsToDiskFiles.remove(path);
            }
        }

        public void addFile(IArchiveResource file) {
            IPath path = file.getPath();
            this.pathsToArchiveResources.put(path, file);
        }

        public void addFile(IArchiveResource file, File externalDiskFile) {
            IPath path = file.getPath();
            this.pathsToArchiveResources.put(path, file);
            if (this.pathsToDiskFiles == null) {
                this.pathsToDiskFiles = new HashMap();
            }
            this.pathsToDiskFiles.put(path, externalDiskFile);
        }

        public void addFile(IArchiveResource file, IResource resource) {
            IPath path = file.getPath();
            this.pathsToArchiveResources.put(path, file);
            this.pathsToWorkbenchResources.put(path, resource);
        }

        public InputStream getInputStream(IPath path) throws IOException, FileNotFoundException {
            File diskFile = null;
            if (this.pathsToDiskFiles != null && this.pathsToDiskFiles.containsKey(path)) {
                diskFile = (File)this.pathsToDiskFiles.get(path);
            } else if (this.pathsToWorkbenchResources != null && this.pathsToWorkbenchResources.containsKey(path)) {
                IResource resource = (IResource)this.pathsToWorkbenchResources.get(path);
                diskFile = new File(resource.getLocation().toOSString());
            }
            if (diskFile != null) {
                return new FileInputStream(diskFile);
            }
            if (this.pathsToZipEntry.containsKey(path)) {
                Map fileURIMap = (Map)this.pathsToZipEntry.get(path);
                Iterator it = fileURIMap.keySet().iterator();
                String sourceFileUri = "";
                ZipFile zipFile = null;
                while (it.hasNext()) {
                    sourceFileUri = (String)it.next();
                    zipFile = (ZipFile)fileURIMap.get(sourceFileUri);
                }
                ZipEntry entry = zipFile.getEntry(sourceFileUri);
                InputStream in = zipFile.getInputStream(entry);
                return in;
            }
            IArchiveResource res = this.getArchiveResource(path);
            return ComponentArchiveLoadAdapter.this.getSuperInputStream(res);
        }

        public List<IArchiveResource> getFiles() {
            return new ArrayList<IArchiveResource>(this.pathsToArchiveResources.values());
        }

        public boolean contains(IPath path) {
            return this.pathsToArchiveResources.containsKey(path);
        }

        public IArchiveResource getArchiveResource(IPath path) {
            return (IArchiveResource)this.pathsToArchiveResources.get(path);
        }

        public void addEntry(ZipEntry entry, ZipFile zipFile, IPath runtimePath) {
            runtimePath = runtimePath != null ? (!runtimePath.equals((Object)"/") ? runtimePath.append(entry.getName()) : new Path(entry.getName())) : new Path(entry.getName());
            IArchiveResource file = ComponentArchiveLoadAdapter.this.createFile(runtimePath);
            HashMap<String, ZipFile> fileURIMap = new HashMap<String, ZipFile>();
            fileURIMap.put(entry.getName(), zipFile);
            this.pathsToZipEntry.put(file.getPath(), fileURIMap);
            this.pathsToArchiveResources.put(file.getPath(), file);
        }
    }
}

