/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDSchemaDirectiveAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDTypeDefinitionAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.actions.BaseSelectionAction;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor;
import org.eclipse.wst.xsd.ui.internal.utils.OpenOnSelectionHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDImportImpl;

public class OpenInNewEditor
extends BaseSelectionAction {
    public static final String ID = "OpenInNewEditor";

    public OpenInNewEditor(IWorkbenchPart part) {
        super(part);
        this.setText(Messages._UI_ACTION_OPEN_IN_NEW_EDITOR);
        this.setId(ID);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        Object selection = ((IStructuredSelection)this.getSelection()).getFirstElement();
        if (selection instanceof XSDTypeDefinitionAdapter) {
            XSDTypeDefinitionAdapter xsdAdapter = (XSDTypeDefinitionAdapter)selection;
            XSDTypeDefinition fComponent = (XSDTypeDefinition)xsdAdapter.getTarget();
            if (fComponent.getSchema() != null) {
                IWorkbenchWindow workbenchWindow;
                String schemaLocation = URIHelper.removePlatformResourceProtocol((String)fComponent.getSchema().getSchemaLocation());
                Path schemaPath = new Path(schemaLocation);
                IFile schemaFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)schemaPath);
                if (schemaFile != null && schemaFile.exists() && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
                    IWorkbenchPage page = workbenchWindow.getActivePage();
                    try {
                        IEditorPart editorPart = page.openEditor((IEditorInput)new FileEditorInput(schemaFile), "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor", true);
                        if (editorPart instanceof InternalXSDMultiPageEditor) {
                            InternalXSDMultiPageEditor xsdEditor = (InternalXSDMultiPageEditor)editorPart;
                            xsdEditor.openOnGlobalReference((XSDConcreteComponent)fComponent);
                        }
                    }
                    catch (PartInitException partInitException) {}
                }
            }
        } else if (selection instanceof XSDSchemaDirectiveAdapter) {
            XSDSchemaDirective dir = (XSDSchemaDirective)((XSDSchemaDirectiveAdapter)selection).getTarget();
            String schemaLocation = "";
            if (dir instanceof XSDImportImpl) {
                ((XSDImportImpl)dir).importSchema();
            }
            if (dir.getResolvedSchema() != null && (schemaLocation = URIHelper.removePlatformResourceProtocol((String)dir.getResolvedSchema().getSchemaLocation())) != null) {
                OpenOnSelectionHelper.openXSDEditor(schemaLocation);
            }
        }
    }
}

