/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.jdt.internal.integration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.jdt.internal.integration.WorkingCopyManager;
import org.eclipse.wst.common.frameworks.internal.ISaveHandler;
import org.eclipse.wst.common.frameworks.internal.SaveFailedException;
import org.eclipse.wst.common.frameworks.internal.SaveHandlerHeadless;
import org.eclipse.wst.common.frameworks.internal.SaveHandlerRegister;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class WTPWorkingCopyManager
implements WorkingCopyManager {
    private List originalNewCompilationUnits;
    private List needsSavingCompilationUnits;
    private List newCompilationUnits;
    private HashMap deletedCompilationUnits;
    protected static final Class IRESOURCE_CLASS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IRESOURCE_CLASS = clazz;
    }

    protected void addDeletedCompilationUnit(ICompilationUnit cu) {
        this.getNeedsSavingCompilationUnits().remove(cu);
        if (!this.getOriginalNewCompilationUnits().contains(cu) && !this.getDeletedCompilationUnits().containsKey(cu)) {
            this.primAddDeletedCompilationUnit(cu);
        }
        this.getOriginalNewCompilationUnits().remove(cu);
    }

    protected void addNewCompilationUnit(ICompilationUnit cu, ICompilationUnit workingCopy) {
        this.getNewCompilationUnits().add(cu);
        this.getNeedsSavingCompilationUnits().add(workingCopy);
        if (!this.getDeletedCompilationUnits().containsKey(cu)) {
            this.getOriginalNewCompilationUnits().add(cu);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void commitWorkingCopy(ICompilationUnit wc, IProgressMonitor monitor) {
        try {
            try {
                try {
                    wc.commitWorkingCopy(false, monitor);
                }
                catch (JavaModelException e) {
                    if (!this.isFailedWriteFileFailure((Exception)((Object)e))) throw e;
                    if (!this.shouldSaveReadOnly(wc)) throw e;
                    wc.commitWorkingCopy(false, monitor);
                }
            }
            catch (JavaModelException e) {
                Logger.getLogger().logError((Throwable)e);
                throw new SaveFailedException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                wc.discardWorkingCopy();
                throw throwable;
            }
            catch (JavaModelException e1) {
                Logger.getLogger().logError((Throwable)e1);
                throw new SaveFailedException((Exception)((Object)e1));
            }
        }
        {
            Object var4_7 = null;
        }
        try {}
        catch (JavaModelException e1) {
            Logger.getLogger().logError((Throwable)e1);
            throw new SaveFailedException((Exception)((Object)e1));
        }
        wc.discardWorkingCopy();
    }

    public void delete(ICompilationUnit cu, IProgressMonitor monitor) {
        block3: {
            if (cu.isWorkingCopy()) {
                cu = cu.getPrimary();
            }
            this.addDeletedCompilationUnit(cu);
            try {
                cu.delete(false, monitor);
            }
            catch (JavaModelException e) {
                if (e.getStatus().getCode() == 969) break block3;
                Logger.getLogger().logError((Throwable)e);
            }
        }
    }

    protected void discardOriginalNewCompilationUnits() {
        if (this.getOriginalNewCompilationUnits().isEmpty()) {
            return;
        }
        List cus = this.getOriginalNewCompilationUnits();
        ICompilationUnit wc = null;
        int i = 0;
        while (i < cus.size()) {
            ICompilationUnit cu = (ICompilationUnit)cus.get(i);
            if (cu.isWorkingCopy()) {
                wc = cu;
                cu = wc.getPrimary();
            }
            this.primDelete(cu);
            if (wc != null) {
                try {
                    wc.discardWorkingCopy();
                }
                catch (JavaModelException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            }
            ++i;
        }
    }

    public void dispose() {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor aMonitor) {
                WTPWorkingCopyManager.this.primDispose();
            }
        };
        try {
            if (!WTPCommonPlugin.getWorkspace().isTreeLocked()) {
                WTPCommonPlugin.getWorkspace().run(runnable, null, 1, null);
            } else {
                runnable.run(null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void revert() {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor aMonitor) {
                WTPWorkingCopyManager.this.primRevert();
            }
        };
        this.runOperation(runnable, null, true);
    }

    public Set getAffectedFiles() {
        return Collections.EMPTY_SET;
    }

    protected HashMap getDeletedCompilationUnits() {
        if (this.deletedCompilationUnits == null) {
            this.deletedCompilationUnits = new HashMap();
        }
        return this.deletedCompilationUnits;
    }

    public ICompilationUnit getExistingWorkingCopy(ICompilationUnit cu) throws CoreException {
        ICompilationUnit newCU = this.getNewCompilationUnitWorkingCopy(cu);
        if (newCU != null) {
            return newCU;
        }
        return null;
    }

    protected List getNeedsSavingCompilationUnits() {
        if (this.needsSavingCompilationUnits == null) {
            this.needsSavingCompilationUnits = new ArrayList();
        }
        return this.needsSavingCompilationUnits;
    }

    protected List getNewCompilationUnits() {
        if (this.newCompilationUnits == null) {
            this.newCompilationUnits = new ArrayList();
        }
        return this.newCompilationUnits;
    }

    protected ICompilationUnit getNewCompilationUnitWorkingCopy(ICompilationUnit cu) {
        if (this.hasNewCompilationUnit(cu)) {
            List list = this.getNeedsSavingCompilationUnits();
            int i = 0;
            while (i < list.size()) {
                ICompilationUnit copy = (ICompilationUnit)list.get(i);
                if (cu.equals(copy.getPrimary())) {
                    return copy;
                }
                ++i;
            }
        }
        return null;
    }

    protected List getOriginalNewCompilationUnits() {
        if (this.originalNewCompilationUnits == null) {
            this.originalNewCompilationUnits = new ArrayList();
        }
        return this.originalNewCompilationUnits;
    }

    protected IPackageFragment getPackageFragment(ICompilationUnit cu) {
        if (cu == null) {
            return null;
        }
        ICompilationUnit parent = cu;
        int elementType = cu.getElementType();
        while (parent != null && elementType != 4) {
            elementType = (parent = parent.getParent()) != null ? parent.getElementType() : -1;
        }
        return (IPackageFragment)parent;
    }

    protected ISaveHandler getSaveHandler() {
        return SaveHandlerRegister.getSaveHandler();
    }

    public ICompilationUnit getWorkingCopy(ICompilationUnit cu, boolean forNewCU) throws CoreException {
        if (cu == null || cu.isWorkingCopy()) {
            return cu;
        }
        ICompilationUnit newCU = this.getNewCompilationUnitWorkingCopy(cu);
        if (newCU != null) {
            return newCU;
        }
        ICompilationUnit workingCopy = cu.getWorkingCopy(null);
        this.addNewCompilationUnit(cu, workingCopy);
        return workingCopy;
    }

    protected boolean hasNewCompilationUnit(ICompilationUnit cu) {
        return this.getNewCompilationUnits().contains(cu);
    }

    protected boolean isFailedWriteFileFailure(Exception ex) {
        return SaveHandlerHeadless.isFailedWriteFileFailure((Exception)ex);
    }

    protected void primAddDeletedCompilationUnit(ICompilationUnit cu) {
        if (cu == null) {
            return;
        }
        Object[] info = new Object[2];
        info[0] = this.getPackageFragment(cu);
        try {
            info[1] = cu.getSource();
        }
        catch (JavaModelException javaModelException) {
            info[1] = null;
        }
        this.getDeletedCompilationUnits().put(cu, info);
    }

    protected void primDelete(ICompilationUnit cu) {
        try {
            if (cu.exists()) {
                cu.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    protected void primDispose() {
        this.discardOriginalNewCompilationUnits();
        this.reviveDeletedCompilationUnits();
        this.newCompilationUnits = null;
        this.needsSavingCompilationUnits = null;
        this.originalNewCompilationUnits = null;
        this.deletedCompilationUnits = null;
    }

    protected void primRevert() {
        this.discardOriginalNewCompilationUnits();
        this.reviveDeletedCompilationUnits();
        this.newCompilationUnits = null;
        this.needsSavingCompilationUnits = null;
        this.originalNewCompilationUnits = null;
        this.deletedCompilationUnits = null;
    }

    protected ICompilationUnit primGetWorkingCopy(ICompilationUnit cu) throws CoreException {
        return null;
    }

    protected void primSaveCompilationUnits(IProgressMonitor monitor) {
        this.saveNewCompilationUnits(monitor);
        this.getDeletedCompilationUnits().clear();
    }

    protected void primSaveOnlyNewCompilationUnits(IProgressMonitor monitor) {
        List cus = this.getNeedsSavingCompilationUnits();
        int i = 0;
        while (i < cus.size()) {
            ICompilationUnit wc = (ICompilationUnit)cus.get(i);
            this.commitWorkingCopy(wc, monitor);
            ++i;
        }
        cus.clear();
    }

    protected void removeDeletedCompilationUnit(ICompilationUnit cu) {
        if (this.getDeletedCompilationUnits().remove(cu) != null && cu.isWorkingCopy()) {
            ICompilationUnit original = cu.getPrimary();
            Set cus = this.getDeletedCompilationUnits().keySet();
            Iterator it = cus.iterator();
            while (it.hasNext()) {
                ICompilationUnit testCU;
                ICompilationUnit nextCU = (ICompilationUnit)it.next();
                ICompilationUnit iCompilationUnit = testCU = nextCU.isWorkingCopy() ? nextCU.getPrimary() : nextCU;
                if (!testCU.equals(original)) continue;
                cus.remove(nextCU);
                return;
            }
        }
    }

    protected void reviveDeletedCompilationUnit(ICompilationUnit cu, Object[] info, IProgressMonitor pm) {
        if (info[0] != null && info[1] != null) {
            String typeName = cu.getElementName();
            IPackageFragment pack = (IPackageFragment)info[0];
            String source = (String)info[1];
            try {
                ICompilationUnit existingCU = pack.getCompilationUnit(typeName);
                if (existingCU.exists() && this.getNewCompilationUnits().contains(existingCU)) {
                    existingCU.delete(false, pm);
                }
                pack.createCompilationUnit(typeName, source, false, pm);
            }
            catch (JavaModelException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
    }

    protected void reviveDeletedCompilationUnits() {
        if (this.getDeletedCompilationUnits().isEmpty()) {
            return;
        }
        NullProgressMonitor pm = new NullProgressMonitor();
        Iterator it = this.getDeletedCompilationUnits().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ICompilationUnit cu = (ICompilationUnit)entry.getKey();
            Object[] info = (Object[])entry.getValue();
            this.reviveDeletedCompilationUnit(cu, info, (IProgressMonitor)pm);
        }
    }

    protected void runOperation(IWorkspaceRunnable aRunnable, IProgressMonitor monitor, boolean validate) {
        this.primRunOperation(aRunnable, monitor);
    }

    protected void primRunOperation(IWorkspaceRunnable aRunnable, IProgressMonitor monitor) {
        if (aRunnable != null && !WTPCommonPlugin.getWorkspace().isTreeLocked()) {
            try {
                WTPCommonPlugin.getWorkspace().run(aRunnable, monitor);
            }
            catch (CoreException e) {
                throw new SaveFailedException((Exception)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveCompilationUnits(IProgressMonitor monitor) {
        this.getSaveHandler().access();
        try {
            try {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor aMonitor) {
                        WTPWorkingCopyManager.this.primSaveCompilationUnits(aMonitor);
                    }
                };
                this.runOperation(runnable, monitor, true);
            }
            catch (SaveFailedException ex) {
                this.getSaveHandler().handleSaveFailed(ex, monitor);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.getSaveHandler().release();
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        this.getSaveHandler().release();
    }

    protected void saveNewCompilationUnits(IProgressMonitor monitor) {
        this.primSaveOnlyNewCompilationUnits(monitor);
        this.getOriginalNewCompilationUnits().clear();
        this.getNewCompilationUnits().clear();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveOnlyNewCompilationUnits(IProgressMonitor monitor) {
        this.getSaveHandler().access();
        try {
            try {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor aMonitor) {
                        WTPWorkingCopyManager.this.primSaveOnlyNewCompilationUnits(aMonitor);
                    }
                };
                this.runOperation(runnable, monitor, false);
            }
            catch (SaveFailedException ex) {
                this.getSaveHandler().handleSaveFailed(ex, monitor);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.getSaveHandler().release();
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        this.getSaveHandler().release();
    }

    protected boolean shouldSaveReadOnly(ICompilationUnit wc) {
        IResource resource = null;
        resource = (IResource)wc.getPrimary().getAdapter(IRESOURCE_CLASS);
        if (resource == null || resource.getType() != 1 || !resource.getResourceAttributes().isReadOnly()) {
            return false;
        }
        return this.getSaveHandler().shouldContinueAndMakeFileEditable((IFile)resource);
    }

    public boolean hasWorkingCopies() {
        return this.deletedCompilationUnits != null && !this.deletedCompilationUnits.isEmpty() || this.needsSavingCompilationUnits != null && !this.needsSavingCompilationUnits.isEmpty() || this.newCompilationUnits != null && !this.newCompilationUnits.isEmpty();
    }
}

